/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.streamscape.ds.lib.DataspaceDateTime;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonDateTimeSerializers {
    private static final ConcurrentHashMap<String, SimpleDateFormat> formatsMap = new ConcurrentHashMap();
    private static Pattern timezonePatternGeneral_z = Pattern.compile(".*([A-Z]{2,5}|GMT[+-]\\d{2}:?\\d{2})$");
    private static Pattern timezonePatternISO8601_X_1 = Pattern.compile(".*(Z|[+-]\\d{2})$");
    private static Pattern timezonePatternISO8601_X_2 = Pattern.compile(".*([+-]\\d{2}\\d{2})$");
    private static Pattern timezonePatternISO8601_X_3 = Pattern.compile(".*([+-]\\d{2}:\\d{2})$");
    private static Pattern microsecondsPattern = Pattern.compile("(.*:.*\\.\\d{3})(\\d{1,3})(.*)$");
    private static final String ISO_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String ISO_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    public static SimpleDateFormat createSimpleDateFormat(String format) {
        return formatsMap.computeIfAbsent(format + "-" + String.valueOf(DataspaceDateTime.getTimezone()), k -> {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
            simpleDateFormat.setTimeZone(DataspaceDateTime.getTimezone());
            return simpleDateFormat;
        });
    }

    public static SimpleDateFormat createSimpleDateFormatInUtc(String format) {
        return formatsMap.computeIfAbsent(format + "-GMT", k -> {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return simpleDateFormat;
        });
    }

    public static long parseDateOrTimestampToMillis(JsonParser jp, SimpleDateFormat format) throws IOException, ParseException {
        if (jp.currentToken().isNumeric()) {
            return jp.getLongValue();
        }
        return JsonDateTimeSerializers.parseDateOrTimestampToMillis(jp.getValueAsString(), format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseDateOrTimestampToMillis(String stringValue, SimpleDateFormat format) throws IOException, ParseException {
        int minTimestampLength = 14;
        boolean timezonePatternGeneral_z_match = stringValue.length() > minTimestampLength && timezonePatternGeneral_z.matcher(stringValue).matches();
        boolean timezonePatternISO8601_X_3_match = !timezonePatternGeneral_z_match && stringValue.length() > minTimestampLength && timezonePatternISO8601_X_3.matcher(stringValue).matches();
        boolean timezonePatternISO8601_X_2_match = !timezonePatternGeneral_z_match && !timezonePatternISO8601_X_3_match && stringValue.length() > minTimestampLength && timezonePatternISO8601_X_2.matcher(stringValue).matches();
        boolean timezonePatternISO8601_X_1_match = !timezonePatternGeneral_z_match && !timezonePatternISO8601_X_2_match && !timezonePatternISO8601_X_3_match && stringValue.length() > minTimestampLength && timezonePatternISO8601_X_1.matcher(stringValue).matches();
        Matcher microsecondsMatcher = microsecondsPattern.matcher(stringValue);
        if (microsecondsMatcher.matches()) {
            stringValue = microsecondsMatcher.replaceAll("$1$3");
        }
        SimpleDateFormat[] formats = new SimpleDateFormat[3];
        if (timezonePatternGeneral_z_match || timezonePatternISO8601_X_1_match || timezonePatternISO8601_X_2_match || timezonePatternISO8601_X_3_match) {
            String[] patterns = new String[3];
            if (format != null) {
                String pattern = format.toPattern();
                while (pattern.endsWith("X")) {
                    pattern = pattern.substring(0, pattern.length() - 1);
                }
                while (pattern.endsWith("Z")) {
                    pattern = pattern.substring(0, pattern.length() - 1);
                }
                while (pattern.endsWith(" z")) {
                    pattern = pattern.substring(0, pattern.length() - 2);
                }
                patterns[0] = pattern;
            }
            patterns[1] = ISO_TIMESTAMP_FORMAT;
            patterns[2] = ISO_DATE_FORMAT;
            for (int i = 0; i < patterns.length; ++i) {
                if (patterns[i] == null) continue;
                formats[i] = timezonePatternISO8601_X_1_match ? JsonDateTimeSerializers.createSimpleDateFormatInUtc(patterns[i] + "X") : (timezonePatternISO8601_X_2_match ? JsonDateTimeSerializers.createSimpleDateFormatInUtc(patterns[i] + "XX") : (timezonePatternISO8601_X_3_match ? JsonDateTimeSerializers.createSimpleDateFormatInUtc(patterns[i] + "XXX") : JsonDateTimeSerializers.createSimpleDateFormatInUtc(patterns[i] + " z")));
            }
        } else {
            if (format != null) {
                formats[0] = format;
            }
            formats[1] = JsonDateTimeSerializers.createSimpleDateFormat(ISO_TIMESTAMP_FORMAT);
            formats[2] = JsonDateTimeSerializers.createSimpleDateFormat(ISO_DATE_FORMAT);
        }
        ParseException exception = null;
        for (SimpleDateFormat f : formats) {
            if (f == null) continue;
            try {
                SimpleDateFormat simpleDateFormat = f;
                synchronized (simpleDateFormat) {
                    return f.parse(stringValue).getTime();
                }
            }
            catch (ParseException e) {
                exception = e;
            }
        }
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateOrTimestampMillis(long millis, SimpleDateFormat format) {
        if (format.toPattern().endsWith("'Z'")) {
            SimpleDateFormat formatInUtc;
            SimpleDateFormat simpleDateFormat = formatInUtc = JsonDateTimeSerializers.createSimpleDateFormatInUtc(format.toPattern());
            synchronized (simpleDateFormat) {
                return formatInUtc.format(new Timestamp(millis));
            }
        }
        SimpleDateFormat simpleDateFormat = format;
        synchronized (simpleDateFormat) {
            return format.format(new Timestamp(millis));
        }
    }

    public static void validJavaDateFormatOrThrowException(String format) {
        if (format == null) {
            throw new IllegalArgumentException("Format is null");
        }
        if (format.toLowerCase().indexOf("mi") >= 0) {
            throw new IllegalArgumentException("Invalid mask MI specified in Java Datetime format " + format);
        }
    }

    public static class OldFabricStyleDateDeserializer
    extends AbstractOldFabricStyleDeserializer<java.util.Date> {
        OldFabricStyleDateDeserializer() {
            super(java.util.Date.class);
        }

        @Override
        public java.util.Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return new java.util.Date(super.deserializeToMilliseconds(jp, ctxt));
        }

        @Override
        protected long doDeserializeToMilliseconds(String value, String timezone) throws ParseException {
            return DataspaceDateTime.getJavaDateMilliseconds(value, timezone);
        }
    }

    public static class OldFabricStyleDateSerializer
    extends AbstractOldFabricStyleSerializer<java.util.Date> {
        OldFabricStyleDateSerializer() {
            super(java.util.Date.class);
        }

        @Override
        public void serialize(java.util.Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(DataspaceDateTime.getJavaDateTimeString(value));
        }

        @Override
        public void serializeWithType(java.util.Date value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
            this.doSerializeWithType(DataspaceDateTime.getJavaDateTimeString(value), this.getTimeZoneOf(value), value, jgen, provider, typeSer);
        }
    }

    public static class OldFabricStyleSqlTimestampDeserializer
    extends AbstractOldFabricStyleDeserializer<Timestamp> {
        public OldFabricStyleSqlTimestampDeserializer() {
            super(Timestamp.class);
        }

        @Override
        public Timestamp deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return new Timestamp(this.deserializeToMilliseconds(jp, ctxt));
        }

        @Override
        protected long doDeserializeToMilliseconds(String value, String timezone) {
            return DataspaceDateTime.getSqlTimestampMilliseconds(value, timezone);
        }
    }

    public static class OldFabricStyleSqlTimestampSerializer
    extends AbstractOldFabricStyleSerializer<Timestamp> {
        public OldFabricStyleSqlTimestampSerializer() {
            super(Timestamp.class);
        }

        @Override
        public void serialize(Timestamp value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(DataspaceDateTime.getSqlTimestampString(value));
        }

        @Override
        public void serializeWithType(Timestamp value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
            this.doSerializeWithType(DataspaceDateTime.getSqlTimestampString(value), this.getTimeZoneOf(value), value, jgen, provider, typeSer);
        }
    }

    public static abstract class AbstractOldFabricStyleSerializer<T>
    extends StdScalarSerializer<T> {
        static final String timezonePattern = "Z";
        static final SimpleDateFormat timezoneFormat = new SimpleDateFormat("Z");

        protected AbstractOldFabricStyleSerializer(Class<T> t) {
            super(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String getTimeZoneOf(java.util.Date value) {
            SimpleDateFormat simpleDateFormat = timezoneFormat;
            synchronized (simpleDateFormat) {
                return timezoneFormat.format(value);
            }
        }

        protected void doSerializeWithType(String value, String timezone, Object object, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
            WritableTypeId typeId = typeSer.typeId(object, JsonToken.START_OBJECT);
            jgen.writeStartObject();
            jgen.writeFieldName(typeId.asProperty);
            jgen.writeString(typeSer.getTypeIdResolver().idFromValue(object));
            jgen.writeFieldName("value");
            jgen.writeString(value);
            jgen.writeFieldName("tz");
            jgen.writeString(timezone);
            jgen.writeEndObject();
        }
    }

    public static abstract class AbstractOldFabricStyleDeserializer<T>
    extends StdScalarDeserializer<T> {
        protected AbstractOldFabricStyleDeserializer(Class<?> vc) {
            super(vc);
        }

        protected long deserializeToMilliseconds(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonToken token;
            String value = null;
            String timezone = null;
            while ((token = jp.getCurrentToken()) == JsonToken.FIELD_NAME) {
                if ("value".equals(jp.getCurrentName())) {
                    token = jp.nextToken();
                    if (token != JsonToken.VALUE_STRING) {
                        throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "value");
                    }
                    value = jp.getValueAsString();
                    jp.nextToken();
                    continue;
                }
                if (!"tz".equals(jp.getCurrentName())) continue;
                token = jp.nextToken();
                if (token != JsonToken.VALUE_STRING) {
                    throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "tz");
                }
                timezone = jp.getValueAsString();
                jp.nextToken();
            }
            if (token == JsonToken.VALUE_STRING) {
                value = jp.getValueAsString();
            } else if (token != JsonToken.END_OBJECT) {
                throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "value or tz or end object expected");
            }
            if (value == null) {
                throw ctxt.mappingException("Value is no specified.");
            }
            try {
                return this.doDeserializeToMilliseconds(value, timezone != null ? "GMT" + timezone : null);
            }
            catch (Exception e) {
                throw ctxt.mappingException(e.getMessage());
            }
        }

        protected abstract long doDeserializeToMilliseconds(String var1, String var2) throws ParseException;
    }

    public static class DateDeserializer
    extends StdScalarDeserializer<java.util.Date> {
        private SimpleDateFormat format;

        public DateDeserializer(SimpleDateFormat format) {
            super(java.util.Date.class);
            this.format = format;
        }

        @Override
        public java.util.Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            SimpleDateFormat simpleDateFormat = this.format;
            synchronized (simpleDateFormat) {
                try {
                    return new java.util.Date(JsonDateTimeSerializers.parseDateOrTimestampToMillis(jp, this.format));
                }
                catch (ParseException exception) {
                    throw ctxt.mappingException("Cannot parse value '" + jp.getValueAsString() + "' to java.util.Date in format '" + this.format.toPattern() + "'");
                }
            }
        }
    }

    public static class DateSerializer
    extends StdScalarSerializer<java.util.Date> {
        private SimpleDateFormat format;

        public DateSerializer(SimpleDateFormat format) {
            super(java.util.Date.class);
            this.format = format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serialize(java.util.Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            SimpleDateFormat simpleDateFormat = this.format;
            synchronized (simpleDateFormat) {
                jgen.writeString(JsonDateTimeSerializers.formatDateOrTimestampMillis(value.getTime(), this.format));
            }
        }
    }

    public static class SqlTimestampDeserializer
    extends StdScalarDeserializer<Timestamp> {
        private SimpleDateFormat format;

        public SqlTimestampDeserializer(SimpleDateFormat format) {
            super(Timestamp.class);
            this.format = format;
        }

        @Override
        public Timestamp deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            SimpleDateFormat simpleDateFormat = this.format;
            synchronized (simpleDateFormat) {
                try {
                    return new Timestamp(JsonDateTimeSerializers.parseDateOrTimestampToMillis(jp, this.format));
                }
                catch (ParseException exception) {
                    throw ctxt.mappingException("Cannot parse value '" + jp.getValueAsString() + "' to java.sql.Timestamp in format '" + this.format.toPattern() + "'");
                }
            }
        }
    }

    public static class SqlTimestampSerializer
    extends StdScalarSerializer<Timestamp> {
        private SimpleDateFormat format;

        public SqlTimestampSerializer(SimpleDateFormat format) {
            super(Timestamp.class);
            this.format = format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serialize(Timestamp value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            SimpleDateFormat simpleDateFormat = this.format;
            synchronized (simpleDateFormat) {
                jgen.writeString(JsonDateTimeSerializers.formatDateOrTimestampMillis(value.getTime(), this.format));
            }
        }
    }

    public static class SqlDateDeserializer
    extends StdScalarDeserializer<Date> {
        private SimpleDateFormat format;

        public SqlDateDeserializer(SimpleDateFormat format) {
            super(Time.class);
            this.format = format;
        }

        @Override
        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            SimpleDateFormat simpleDateFormat = this.format;
            synchronized (simpleDateFormat) {
                try {
                    return new Date(this.format.parse(jp.getValueAsString()).getTime());
                }
                catch (ParseException exception) {
                    throw ctxt.mappingException("Cannot parse value '" + jp.getValueAsString() + "' to java.sql.Date in format '" + this.format.toPattern() + "'");
                }
            }
        }
    }

    public static class SqlDateSerializer
    extends StdScalarSerializer<Date> {
        private SimpleDateFormat format;

        public SqlDateSerializer(SimpleDateFormat format) {
            super(Date.class);
            this.format = format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            SimpleDateFormat simpleDateFormat = this.format;
            synchronized (simpleDateFormat) {
                jgen.writeString(this.format.format(value));
            }
        }
    }

    public static class SqlTimeDeserializer
    extends StdScalarDeserializer<Time> {
        private SimpleDateFormat format;

        public SqlTimeDeserializer(SimpleDateFormat format) {
            super(Time.class);
            this.format = format;
        }

        @Override
        public Time deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            SimpleDateFormat simpleDateFormat = this.format;
            synchronized (simpleDateFormat) {
                try {
                    return new Time(this.format.parse(jp.getValueAsString()).getTime());
                }
                catch (ParseException exception) {
                    throw ctxt.mappingException("Cannot parse value '" + jp.getValueAsString() + "' to Time in format '" + this.format.toPattern() + "'.");
                }
            }
        }
    }

    public static class SqlTimeSerializer
    extends StdScalarSerializer<Time> {
        private SimpleDateFormat format;

        public SqlTimeSerializer(SimpleDateFormat format) {
            super(Time.class);
            this.format = format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serialize(Time value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            SimpleDateFormat simpleDateFormat = this.format;
            synchronized (simpleDateFormat) {
                jgen.writeString(this.format.format(value));
            }
        }
    }

    public static class DefaultDateDeserializer
    extends StdScalarDeserializer<java.util.Date> {
        public DefaultDateDeserializer() {
            super(java.util.Date.class);
        }

        @Override
        public java.util.Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            try {
                return new java.util.Date(JsonDateTimeSerializers.parseDateOrTimestampToMillis(jp, null));
            }
            catch (ParseException exception) {
                throw ctxt.mappingException("Cannot parse value '" + jp.getValueAsString() + "' to Date. " + exception.toString());
            }
        }
    }

    public static class DefaultDateSerializer
    extends StdScalarSerializer<java.util.Date> {
        protected DefaultDateSerializer() {
            super(java.util.Date.class);
        }

        @Override
        public void serialize(java.util.Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeNumber(value.getTime());
        }
    }

    public static class DefaultSqlTimestampDeserializer
    extends StdScalarDeserializer<Timestamp> {
        public DefaultSqlTimestampDeserializer() {
            super(Timestamp.class);
        }

        @Override
        public Timestamp deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            try {
                return new Timestamp(JsonDateTimeSerializers.parseDateOrTimestampToMillis(jp, null));
            }
            catch (ParseException exception) {
                throw ctxt.mappingException("Cannot parse value '" + jp.getValueAsString() + "' to Timestamp. " + exception.toString());
            }
        }
    }

    public static class DefaultSqlTimestampSerializer
    extends StdScalarSerializer<Timestamp> {
        public DefaultSqlTimestampSerializer() {
            super(Timestamp.class);
        }

        @Override
        public void serialize(Timestamp value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeNumber(value.getTime());
        }
    }

    public static class DefaultSqlDateDeserializer
    extends StdScalarDeserializer<Date> {
        public DefaultSqlDateDeserializer() {
            super(Time.class);
        }

        @Override
        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return Date.valueOf(jp.getValueAsString());
        }
    }

    public static class DefaultSqlDateSerializer
    extends StdScalarSerializer<Date> {
        public DefaultSqlDateSerializer() {
            super(Date.class);
        }

        @Override
        public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }

    public static class DefaultSqlTimeDeserializer
    extends StdScalarDeserializer<Time> {
        public DefaultSqlTimeDeserializer() {
            super(Time.class);
        }

        @Override
        public Time deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return Time.valueOf(jp.getValueAsString());
        }
    }

    public static class DefaultSqlTimeSerializer
    extends StdScalarSerializer<Time> {
        public DefaultSqlTimeSerializer() {
            super(Time.class);
        }

        @Override
        public void serialize(Time value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }
}

