/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.sef.network.http.server.servlet.FormatAndMimeTypes;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class JsonCustomization {
    public static final String JSON_DATE_FORMAT_NAME = "json.date_format";
    public static final String JSON_SQL_DATE_FORMAT_NAME = "json.sqldate_format";
    public static final String JSON_SQL_TIME_FORMAT_NAME = "json.sqltime_format";
    public static final String JSON_SQL_TIMESTAMP_FORMAT_NAME = "json.sqltimestamp_format";
    private JsonNotation notation;
    private EnumSet<JsonNotationLevel> notationLevels;
    private Boolean prettyPrint;
    private Boolean skipnulls;
    private Boolean escapeHtmlCharacters;
    private Map<String, String> parameters;

    private JsonCustomization() {
    }

    private JsonCustomization(JsonCustomization customization) {
        this.notation = customization.notation;
        this.notationLevels = customization.notationLevels != null ? customization.notationLevels.clone() : null;
        this.prettyPrint = customization.prettyPrint;
        this.skipnulls = customization.skipnulls;
        if (customization.parameters != null) {
            this.parameters = new HashMap<String, String>(customization.parameters);
        }
    }

    public JsonNotation getNotation() {
        return this.notation;
    }

    public EnumSet<JsonNotationLevel> getNotationLevels() {
        return this.notationLevels;
    }

    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public Boolean getSkipnulls() {
        return this.skipnulls;
    }

    public Boolean getEscapeHtmlCharacters() {
        return this.escapeHtmlCharacters;
    }

    public boolean containsParameter(String name) {
        return this.parameters != null && this.parameters.containsKey(name);
    }

    public String getParameter(String name) {
        return this.parameters != null ? this.parameters.get(name) : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String formatName(String name) {
        if (this.notation != null) {
            name = (String)name + "$Notation$" + this.notation.toString();
        }
        if (this.notationLevels != null) {
            name = (String)name + "$Level$" + this.notationLevels.toString();
        }
        if (this.skipnulls != null && this.skipnulls.booleanValue()) {
            name = (String)name + "$skipnulls";
        }
        if (this.parameters != null) {
            if (this.parameters.containsKey(JSON_DATE_FORMAT_NAME)) {
                name = (String)name + "$json.date_format$" + this.parameters.get(JSON_DATE_FORMAT_NAME);
            }
            if (this.parameters.containsKey(JSON_SQL_DATE_FORMAT_NAME)) {
                name = (String)name + "$json.sqldate_format$" + this.parameters.get(JSON_SQL_DATE_FORMAT_NAME);
            }
            if (this.parameters.containsKey(JSON_SQL_TIME_FORMAT_NAME)) {
                name = (String)name + "$json.sqltime_format$" + this.parameters.get(JSON_SQL_TIME_FORMAT_NAME);
            }
            if (this.parameters.containsKey(JSON_SQL_TIMESTAMP_FORMAT_NAME)) {
                name = (String)name + "$json.sqltimestamp_format$" + this.parameters.get(JSON_SQL_TIMESTAMP_FORMAT_NAME);
            }
        }
        return name;
    }

    public static class Builder {
        private JsonCustomization customization = new JsonCustomization();

        private Builder() {
        }

        public Builder setNotation(JsonNotation notation) {
            this.customization.notation = notation;
            return this;
        }

        public Builder setNotationLevels(EnumSet<JsonNotationLevel> notationLevels) {
            this.customization.notationLevels = notationLevels;
            return this;
        }

        public Builder addNotationLevel(JsonNotationLevel notationLevel) {
            if (this.customization.notationLevels == null) {
                this.customization.notationLevels = EnumSet.of(notationLevel);
            } else {
                this.customization.notationLevels.add(notationLevel);
            }
            return this;
        }

        public Builder removeNotationLevel(JsonNotationLevel notationLevel) {
            if (this.customization.notationLevels != null) {
                this.customization.notationLevels.remove((Object)notationLevel);
            }
            return this;
        }

        public Builder setPrettyPrint(Boolean prettyPrint) {
            this.customization.prettyPrint = prettyPrint;
            return this;
        }

        public Builder setSkipnulls(Boolean skipnulls) {
            this.customization.skipnulls = skipnulls;
            return this;
        }

        public Builder setEscapeHtmlCharacters(Boolean escapeHtmlCharacters) {
            this.customization.escapeHtmlCharacters = escapeHtmlCharacters;
            return this;
        }

        public Builder setParameter(String name, String value) {
            if (this.customization.parameters == null) {
                this.customization.parameters = new HashMap<String, String>();
            }
            this.customization.parameters.put(name, value);
            return this;
        }

        public Builder from(JsonCustomization customization) {
            customization = new JsonCustomization(customization);
            return this;
        }

        public Builder fromString(String customization) {
            return this.fromMap(FormatAndMimeTypes.splitParameters(customization));
        }

        public Builder fromMap(Map<String, String> parameters) {
            String notationLevelsString;
            this.customization = new JsonCustomization(this.customization);
            if (parameters == null) {
                return this;
            }
            String notationString = parameters.get("notation");
            if (notationString != null) {
                try {
                    this.customization.notation = JsonNotation.valueOf(notationString.toUpperCase());
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Invalid json notation '" + notationString + "' specified.");
                }
            }
            if ((notationLevelsString = parameters.get("level")) != null) {
                this.customization.notationLevels = EnumSet.noneOf(JsonNotationLevel.class);
                StringTokenizer tokenizer = new StringTokenizer(notationLevelsString, ",");
                while (tokenizer.hasMoreTokens()) {
                    String notationLevelString = tokenizer.nextToken().trim();
                    if (notationLevelString.length() <= 0) continue;
                    try {
                        JsonNotationLevel notationLevel = JsonNotationLevel.valueOf(notationLevelString.toUpperCase());
                        if (this.customization.notationLevels == null) {
                            this.customization.notationLevels = EnumSet.of(notationLevel);
                            continue;
                        }
                        this.customization.notationLevels.add(notationLevel);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Invalid json notation level '" + notationLevelString + "' specified.");
                    }
                }
            }
            if (parameters.containsKey("prettyprint")) {
                String prettyprintString = parameters.get("prettyprint");
                this.customization.prettyPrint = prettyprintString != null && prettyprintString.trim().equalsIgnoreCase("false") ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
            if (parameters.containsKey("skipnulls")) {
                String skipnullsString = parameters.get("skipnulls");
                this.customization.skipnulls = skipnullsString != null && skipnullsString.trim().equalsIgnoreCase("false") ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
            this.customization.parameters = new HashMap<String, String>(parameters);
            return this;
        }

        public JsonCustomization build() {
            return this.customization;
        }

        public EnumSet<JsonNotationLevel> getNotationLevels() {
            return this.customization.getNotationLevels();
        }

        public JsonNotation getNotation() {
            return this.customization.getNotation();
        }

        public Boolean getPrettyPrint() {
            return this.customization.getPrettyPrint();
        }
    }
}

