/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.CollectionSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.omf.json.jackson.JacksonBoxerDefaultNullSerializers;
import com.streamscape.omf.json.jackson.StreamscapeCollectionDeserializerResolver;
import com.streamscape.omf.json.jackson.StreamscapeCollectionSerializerResolver;
import com.streamscape.omf.json.jackson.StreamscapeMapDeserializerResolver;
import com.streamscape.omf.json.jackson.StreamscapeMapSerializerResolver;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType1;
import com.streamscape.sdo.rowset.DataRow;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.Address;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import sun.reflect.ReflectionFactory;

public class JacksonUtils {
    private static HashSet<Class<?>> primitives = new HashSet();

    public static boolean isPrimitive(Class<?> clazz) {
        return primitives.contains(clazz);
    }

    public static boolean isEnum(Class<?> clazz) {
        return clazz.isEnum() || clazz == Enum.class;
    }

    public static boolean isScalar(Object value) {
        return value != null && (JacksonUtils.isEnum(value.getClass()) || JacksonUtils.isPrimitive(value.getClass()));
    }

    private static void readParserToValueField(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken token = jp.getCurrentToken();
        if (token == JsonToken.START_OBJECT) {
            token = jp.nextToken();
        }
        if (token == JsonToken.FIELD_NAME) {
            if (!"value".equals(jp.getCurrentName())) {
                throw ctxt.wrongTokenException(jp, JsonToken.FIELD_NAME, "value");
            }
            token = jp.nextToken();
        }
    }

    static {
        primitives.add(Boolean.TYPE);
        primitives.add(Boolean.class);
        primitives.add(Byte.TYPE);
        primitives.add(Byte.class);
        primitives.add(Short.TYPE);
        primitives.add(Short.class);
        primitives.add(Integer.TYPE);
        primitives.add(Integer.class);
        primitives.add(Long.TYPE);
        primitives.add(Long.class);
        primitives.add(Float.TYPE);
        primitives.add(Float.class);
        primitives.add(Double.TYPE);
        primitives.add(Double.class);
        primitives.add(BigInteger.class);
        primitives.add(BigDecimal.class);
        primitives.add(Character.TYPE);
        primitives.add(Character.class);
        primitives.add(String.class);
        primitives.add(Date.class);
        primitives.add(java.sql.Date.class);
        primitives.add(Time.class);
        primitives.add(Timestamp.class);
    }

    public static class HtmlCharacterEscapes
    extends CharacterEscapes {
        private final int[] _asciiEscapes = HtmlCharacterEscapes.standardAsciiEscapesForJSON();

        public HtmlCharacterEscapes() {
            this._asciiEscapes[47] = 47;
            this._asciiEscapes[60] = -1;
            this._asciiEscapes[62] = -1;
            this._asciiEscapes[38] = -1;
            this._asciiEscapes[61] = -1;
        }

        @Override
        public int[] getEscapeCodesForAscii() {
            return this._asciiEscapes;
        }

        @Override
        public SerializableString getEscapeSequence(int i) {
            return null;
        }
    }

    public abstract class RowArrayMixIn {
        public RowArrayMixIn(JacksonUtils this$0) {
        }

        @JsonSetter(value="rowArray")
        public abstract void setRowArray(LinkedHashMap<Object, DataRow> var1);
    }

    public abstract class RowSetMixIn {
        public RowSetMixIn(JacksonUtils this$0) {
        }

        @JsonSetter(value="rows")
        public abstract void setRows(List<Row> var1);
    }

    public abstract class ThrowableMixIn {
        @JsonIgnore
        private Throwable cause;
        @JsonIgnore
        private List<Throwable> suppressedExceptions;
        @JsonIgnore
        private StackTraceElement[] stackTrace;

        public ThrowableMixIn(JacksonUtils this$0) {
        }

        @JsonGetter(value="cause")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public abstract Throwable getCause();

        @JsonGetter(value="stackTrace")
        public abstract StackTraceElement[] getStackTrace();
    }

    public abstract class DataEventMixIn {
        @JsonIgnore
        protected Object data;

        public DataEventMixIn(JacksonUtils this$0) {
        }

        @JsonGetter(value="data")
        protected abstract Object getData();

        @JsonSetter(value="data")
        protected abstract void setDataFromJackson(Object var1);
    }

    public abstract class IAbstractDataEventMixIn {
        @JsonIgnore
        protected HashMap<String, Object> eventProperties;

        public IAbstractDataEventMixIn(JacksonUtils this$0) {
        }

        @JsonGetter(value="eventProperties")
        protected abstract HashMap<String, Object> getEventProperties();

        @JsonSetter(value="eventProperties")
        protected abstract void setEventProperties(HashMap<String, Object> var1);
    }

    public static class URLDeserializer
    extends StdScalarDeserializer<URL> {
        public URLDeserializer() {
            super(URL.class);
        }

        @Override
        public URL deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JacksonUtils.readParserToValueField(jp, ctxt);
            if (jp.getCurrentToken() != JsonToken.VALUE_STRING) {
                throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "value");
            }
            try {
                URL url = new URL(jp.getValueAsString());
                jp.nextToken();
                return url;
            }
            catch (Exception exception) {
                throw ctxt.mappingException(exception.getMessage());
            }
        }
    }

    public static class Inet6AddressDeserializer
    extends InetAddressDeserializer<Inet6Address> {
        public Inet6AddressDeserializer() {
            super((Class<? extends InetAddress>)Inet6Address.class);
        }
    }

    public static class Inet4AddressDeserializer
    extends InetAddressDeserializer<Inet4Address> {
        public Inet4AddressDeserializer() {
            super((Class<? extends InetAddress>)Inet4Address.class);
        }
    }

    public static class InetAddressDeserializer<T extends InetAddress>
    extends StdScalarDeserializer<T> {
        public InetAddressDeserializer(Class<? extends InetAddress> address) {
            super(address);
        }

        public InetAddressDeserializer() {
            this(InetAddress.class);
        }

        @Override
        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JacksonUtils.readParserToValueField(jp, ctxt);
            if (jp.getCurrentToken() != JsonToken.VALUE_STRING) {
                throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "value");
            }
            try {
                return (T)InetAddress.getByName(jp.getValueAsString());
            }
            catch (UnknownHostException exception) {
                throw ctxt.mappingException(exception.getMessage());
            }
        }
    }

    public static class AddressDeserializer
    extends StdScalarDeserializer<Address> {
        public AddressDeserializer() {
            super(Address.class);
        }

        @Override
        public Address deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                if (jp.currentToken() == JsonToken.VALUE_STRING) {
                    return new Address(jp.getValueAsString());
                }
                if (jp.currentToken() == JsonToken.FIELD_NAME) {
                    if ("value".equals(jp.getCurrentName())) {
                        if (jp.nextToken() != JsonToken.VALUE_STRING) {
                            throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "value");
                        }
                        return new Address(jp.getValueAsString());
                    }
                } else if (jp.currentToken() == JsonToken.START_OBJECT) {
                    int closes = 1;
                    if (jp.nextToken() == JsonToken.FIELD_NAME) {
                        if (!"value".equals(jp.getCurrentName())) {
                            if (jp.nextToken() == JsonToken.START_OBJECT) {
                                ++closes;
                            }
                            jp.nextToken();
                        }
                        if ("value".equals(jp.getCurrentName())) {
                            if (jp.nextToken() != JsonToken.VALUE_STRING) {
                                throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "value");
                            }
                            Address address = new Address(jp.getValueAsString());
                            while (closes-- > 0) {
                                jp.nextToken();
                            }
                            return address;
                        }
                    }
                }
                throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "value");
            }
            catch (FabricException exception) {
                throw ctxt.mappingException(exception.getMessage());
            }
        }

        @Override
        public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            return super.deserializeWithType(p, ctxt, typeDeserializer);
        }
    }

    public static class AddressSerializer
    extends StdScalarSerializer<Address> {
        public AddressSerializer() {
            super(Address.class);
        }

        @Override
        public void serialize(Address value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString(value.toString());
        }

        @Override
        public void serializeWithType(Address value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
            WritableTypeId typeId = typeSer.typeId(value, JsonToken.VALUE_STRING);
            typeId = typeSer.writeTypePrefix(jgen, typeId);
            this.serialize(value, jgen, provider);
            typeSer.writeTypeSuffix(jgen, typeId);
        }
    }

    public static class ToStringSerializer<T>
    extends StdScalarSerializer<T> {
        public ToStringSerializer(Class<T> clazz) {
            super(clazz);
        }

        @Override
        public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }

    public static class StreamscapeAnnotationInterceptor
    extends AnnotationIntrospector {
        private ClassLoader classLoader;
        private boolean skipNulls;
        private TypeFactory typeFactory;
        private static final Field CAUSE_FILED;
        private static final Field STACK_TRACE_FIELD;

        public StreamscapeAnnotationInterceptor(ClassLoader classLoader, boolean skipNulls, TypeFactory typeFactory) {
            this.classLoader = classLoader;
            this.skipNulls = skipNulls;
            this.typeFactory = typeFactory;
        }

        @Override
        public Object findValueInstantiator(final AnnotatedClass ac) {
            if (ac.getDefaultConstructor() == null) {
                return new ValueInstantiator(this){

                    @Override
                    public String getValueTypeDesc() {
                        return ac.getRawType().getName();
                    }

                    @Override
                    public boolean canInstantiate() {
                        return true;
                    }

                    @Override
                    public boolean canCreateUsingDefault() {
                        return true;
                    }

                    @Override
                    public Object createUsingDefault(DeserializationContext ctxt) throws IOException {
                        try {
                            Class<?> aClass = ac.getRawType();
                            ReflectionFactory factory = ReflectionFactory.getReflectionFactory();
                            Constructor objectConstructor = Object.class.getDeclaredConstructor(new Class[0]);
                            Constructor<?> constructor = factory.newConstructorForSerialization(aClass, objectConstructor);
                            Object object = aClass.cast(constructor.newInstance(new Object[0]));
                            this.pathThrowable(object);
                            return object;
                        }
                        catch (Exception e) {
                            throw new IOException("Failed to instantiate object of " + String.valueOf(ac.getRawType()));
                        }
                    }

                    private void pathThrowable(Object object) {
                        if (object instanceof Throwable) {
                            try {
                                Object stackTrace;
                                Object cause = CAUSE_FILED.get(object);
                                if (cause == null) {
                                    CAUSE_FILED.set(object, object);
                                }
                                if ((stackTrace = STACK_TRACE_FIELD.get(object)) == null) {
                                    STACK_TRACE_FIELD.set(object, new StackTraceElement[0]);
                                }
                            }
                            catch (IllegalAccessException exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                };
            }
            return null;
        }

        @Override
        public Class<?> findDeserializationKeyType(Annotated am, JavaType baseKeyType) {
            return this.findSerializationKeyType(am, baseKeyType);
        }

        @Override
        public Class<?> findDeserializationContentType(Annotated am, JavaType baseContentType) {
            return this.findSerializationContentType(am, baseContentType);
        }

        @Override
        public Class<?> findSerializationContentType(Annotated am, JavaType baseType) {
            if (Collection.class.isAssignableFrom(am.getRawType())) {
                return this.findSemanticTypeTypeType(am);
            }
            return this.findSemanticTypeTypeType1(am);
        }

        @Override
        public Class<?> findSerializationKeyType(Annotated am, JavaType baseType) {
            if (Map.class.isAssignableFrom(am.getRawType())) {
                return this.findSemanticTypeTypeType(am);
            }
            return null;
        }

        @Override
        public Object findNullSerializer(Annotated am) {
            if (this.skipNulls) {
                return null;
            }
            return JacksonBoxerDefaultNullSerializers.lookup(am.getRawType());
        }

        private Class<?> findSemanticTypeTypeType(Annotated am) {
            SemanticType semType = am.getAnnotation(SemanticType.class);
            if (semType != null && !Object.class.getName().equals(semType.type())) {
                return this.loadClass(semType.type());
            }
            return null;
        }

        private Class<?> findSemanticTypeTypeType1(Annotated am) {
            SemanticType semType = am.getAnnotation(SemanticType.class);
            if (semType != null && semType.type1() != null && !Object.class.getName().equals(semType.type1())) {
                return this.loadClass(semType.type1());
            }
            return null;
        }

        private JavaType buildTypeForField(Annotated am) {
            SemanticType semType = am.getAnnotation(SemanticType.class);
            if (semType != null) {
                return this.buildTypeLevel1ForField(semType.type(), am);
            }
            return null;
        }

        private JavaType buildType1ForField(Annotated am) {
            SemanticType semType = am.getAnnotation(SemanticType.class);
            if (semType != null) {
                return this.buildTypeLevel1ForField(semType.type1(), am);
            }
            return null;
        }

        private JavaType buildTypeLevel1ForField(String semanticTypeName, Annotated am) {
            if (semanticTypeName == null) {
                return null;
            }
            Class<?> typeClass = this.loadClass(semanticTypeName);
            if (typeClass != null && typeClass != Object.class) {
                SemanticType1 semType1;
                JavaType typeType = this.typeFactory.constructType(typeClass);
                if (typeType.isCollectionLikeType()) {
                    Class<?> contentTypeClass1;
                    SemanticType1 semType12 = am.getAnnotation(SemanticType1.class);
                    if (semType12 != null && (contentTypeClass1 = this.loadClass(semType12.type())) != null && contentTypeClass1 != typeType.getContentType().getRawClass()) {
                        typeType = typeType.withContentType(typeType.getContentType().forcedNarrowBy(contentTypeClass1));
                    }
                } else if (typeType.isMapLikeType() && (semType1 = am.getAnnotation(SemanticType1.class)) != null) {
                    Class<Object> keyClass = this.loadClass(semType1.type());
                    Class<Object> contentClass = this.loadClass(semType1.type1());
                    if (keyClass == null) {
                        keyClass = Object.class;
                    }
                    if (contentClass == null) {
                        contentClass = Object.class;
                    }
                    if (keyClass != Object.class || contentClass != Object.class) {
                        if (keyClass != ((MapType)typeType).getKeyType().getRawClass()) {
                            typeType = ((MapType)typeType).withKeyType(((MapType)typeType).getKeyType().forcedNarrowBy(keyClass));
                        }
                        if (contentClass != ((MapType)typeType).getContentType().getRawClass()) {
                            typeType = ((MapType)typeType).withContentType(((MapType)typeType).getContentType().forcedNarrowBy(contentClass));
                        }
                    }
                }
                return typeType;
            }
            return null;
        }

        @Override
        public Object findSerializer(Annotated am) {
            if (Collection.class.isAssignableFrom(am.getRawType())) {
                JavaType contentType = this.buildTypeForField(am);
                if (contentType != null) {
                    return new StreamscapeCollectionSerializerResolver(contentType);
                }
            } else if (Map.class.isAssignableFrom(am.getRawType())) {
                JavaType keyType = this.buildTypeForField(am);
                JavaType valueType = this.buildType1ForField(am);
                if (keyType != null || valueType != null) {
                    MapType mapType = this.typeFactory.constructMapType(Map.class, keyType, valueType == null ? this.typeFactory.constructType((Type)((Object)Object.class)) : valueType);
                    return new StreamscapeMapSerializerResolver(mapType);
                }
            }
            return null;
        }

        @Override
        public Object findDeserializer(Annotated am) {
            if (Collection.class.isAssignableFrom(am.getRawType())) {
                JavaType contentType = this.buildTypeForField(am);
                if (contentType != null) {
                    CollectionType collectionType = this.typeFactory.constructCollectionType(List.class, contentType);
                    return new StreamscapeCollectionDeserializerResolver(collectionType);
                }
            } else if (Map.class.isAssignableFrom(am.getRawType())) {
                JavaType keyType = this.buildTypeForField(am);
                JavaType contentType = this.buildType1ForField(am);
                if (keyType != null || contentType != null) {
                    MapType mapType = this.typeFactory.constructMapType(Map.class, keyType, contentType == null ? this.typeFactory.constructType((Type)((Object)Object.class)) : contentType);
                    return new StreamscapeMapDeserializerResolver(mapType, null, null, null, null);
                }
                if (am.getType() instanceof MapType) {
                    return new StreamscapeMapDeserializerResolver((MapType)am.getType(), null, null, null, null);
                }
            }
            return super.findDeserializer(am);
        }

        private Class<?> loadClass(String name) {
            try {
                return ClassUtils.loadClass(name, this.classLoader);
            }
            catch (Exception e) {
                Trace.logError(StreamscapeAnnotationInterceptor.class, "Failed to load semantic type class: " + e.toString());
                return null;
            }
        }

        @Override
        public Version version() {
            return PackageVersion.VERSION;
        }

        static {
            try {
                CAUSE_FILED = Throwable.class.getDeclaredField("cause");
                CAUSE_FILED.setAccessible(true);
                STACK_TRACE_FIELD = Throwable.class.getDeclaredField("stackTrace");
                STACK_TRACE_FIELD.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ContainerAdditionalDeserializers
    extends Deserializers.Base {
        @Override
        public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
            return new StreamscapeMapDeserializerResolver(type, beanDesc, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
    }

    public static class ContainerAdditionalSerializers
    extends Serializers.Base {
        @Override
        public JsonSerializer<?> findCollectionSerializer(SerializationConfig config, CollectionType type, BeanDescription beanDesc, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
            return new CollectionSerializer(type.getContentType(), false, elementTypeSerializer, elementValueSerializer){

                @Override
                public CollectionSerializer withResolved(BeanProperty property, TypeSerializer vts, JsonSerializer<?> elementSerializer, Boolean unwrapSingle) {
                    if (!(elementSerializer == null || this._elementType.isCollectionLikeType() || this._elementType.isMapLikeType() || this._elementType.isFinal())) {
                        elementSerializer = null;
                    }
                    return new CollectionSerializer(this, property, vts, elementSerializer, null);
                }
            };
        }

        @Override
        public JsonSerializer<?> findMapSerializer(SerializationConfig config, MapType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
            return new StreamscapeMapSerializerResolver(type);
        }
    }
}

