/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

class JacksonBoxerDefaultNullSerializers {
    private static final Map<Class<?>, Supplier<JsonSerializer>> nullBoxerDefaults = new HashMap();

    JacksonBoxerDefaultNullSerializers() {
    }

    public static JsonSerializer lookup(Class<?> clazz) {
        return nullBoxerDefaults.getOrDefault(clazz, () -> null).get();
    }

    static {
        nullBoxerDefaults.put(Byte.class, () -> new ByteBoxerDefaultSerializer());
        nullBoxerDefaults.put(Short.class, () -> new ShortBoxerDefaultSerializer());
        nullBoxerDefaults.put(Integer.class, () -> IntegerBoxerDefaultSerializer.instance);
        nullBoxerDefaults.put(Long.class, () -> new LongBoxerDefaultSerializer());
        nullBoxerDefaults.put(Float.class, () -> new FloatBoxerDefaultSerializer());
        nullBoxerDefaults.put(Double.class, () -> DoubleBoxerDefaultSerializer.instance);
    }

    static class DoubleBoxerDefaultSerializer
    extends StdScalarSerializer {
        static final DoubleBoxerDefaultSerializer instance = new DoubleBoxerDefaultSerializer();

        protected DoubleBoxerDefaultSerializer() {
            super(Double.class);
        }

        @Override
        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeNumber(0.0);
        }
    }

    static class FloatBoxerDefaultSerializer
    extends AbstractBoxerDefaultSerializer {
        static final FloatBoxerDefaultSerializer instance = new FloatBoxerDefaultSerializer();

        protected FloatBoxerDefaultSerializer() {
            super(Float.class);
        }

        protected Object getDefaultValue() {
            return Float.valueOf(0.0f);
        }

        @Override
        protected void writeDefaultValue(JsonGenerator jgen) throws IOException {
            jgen.writeNumber(0.0f);
        }
    }

    static class LongBoxerDefaultSerializer
    extends AbstractBoxerDefaultSerializer {
        static final LongBoxerDefaultSerializer instance = new LongBoxerDefaultSerializer();

        protected LongBoxerDefaultSerializer() {
            super(Long.class);
        }

        protected Object getDefaultValue() {
            return 0L;
        }

        @Override
        protected void writeDefaultValue(JsonGenerator jgen) throws IOException {
            jgen.writeNumber(0L);
        }
    }

    static class IntegerBoxerDefaultSerializer
    extends StdScalarSerializer {
        static final IntegerBoxerDefaultSerializer instance = new IntegerBoxerDefaultSerializer();

        protected IntegerBoxerDefaultSerializer() {
            super(Integer.class);
        }

        @Override
        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeNumber(0);
        }
    }

    static class ShortBoxerDefaultSerializer
    extends AbstractBoxerDefaultSerializer {
        static final ShortBoxerDefaultSerializer instance = new ShortBoxerDefaultSerializer();

        protected ShortBoxerDefaultSerializer() {
            super(Short.class);
        }

        protected Object getDefaultValue() {
            return (short)0;
        }

        @Override
        protected void writeDefaultValue(JsonGenerator jgen) throws IOException {
            jgen.writeNumber((short)0);
        }
    }

    static class ByteBoxerDefaultSerializer
    extends AbstractBoxerDefaultSerializer {
        static final ByteBoxerDefaultSerializer instance = new ByteBoxerDefaultSerializer();

        protected ByteBoxerDefaultSerializer() {
            super(Byte.class);
        }

        protected Object getDefaultValue() {
            return (byte)0;
        }

        @Override
        protected void writeDefaultValue(JsonGenerator jgen) throws IOException {
            jgen.writeNumber(0);
        }
    }

    static abstract class AbstractBoxerDefaultSerializer<T>
    extends StdScalarSerializer
    implements ResolvableSerializer {
        private TypeSerializer typeSerializer = null;
        private SimpleType type;

        protected AbstractBoxerDefaultSerializer(Class<T> clazz) {
            super(clazz);
            this.type = SimpleType.construct(clazz);
        }

        @Override
        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (this.typeSerializer != null) {
                T defaultValue = this.getDefaultValue();
                WritableTypeId typeId = this.typeSerializer.typeId(defaultValue, JsonToken.START_OBJECT);
                this.typeSerializer.writeTypePrefix(jgen, typeId);
                this.writeDefaultValue(jgen);
                this.typeSerializer.writeTypeSuffix(jgen, typeId);
            } else {
                this.writeDefaultValue(jgen);
            }
        }

        @Override
        public void resolve(SerializerProvider provider) throws JsonMappingException {
            TypeResolverBuilder<?> builder = provider.getConfig().getDefaultTyper(this.type);
            if (builder != null) {
                this.typeSerializer = builder.buildTypeSerializer(provider.getConfig(), this.type, null);
            }
        }

        protected abstract T getDefaultValue();

        protected abstract void writeDefaultValue(JsonGenerator var1) throws IOException;
    }
}

