/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.streamscape.lib.loader.ClassLoaderReference;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.omf.json.JSONSerializerException;
import com.streamscape.omf.json.jackson.JacksonUtils;
import com.streamscape.omf.json.jackson.JsonDateTimeSerializers;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.json.jackson.StackTraceElementDeserializer;
import com.streamscape.omf.json.jackson.StreamscapeResolverBuilder;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.serializer.AbstractSerializer;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.omf.serializer.TextSerializer;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.mf.operation.edl.annotations.Implicit;
import com.streamscape.sdo.IAbstractDataEvent;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.rowset.RowArray;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.Address;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;

public class JSONSerializer
extends AbstractSerializer
implements TextSerializer {
    private final String name;
    private final ObjectMapper mapper;
    private final JsonNotation jsonNotation;
    private final EnumSet<JsonNotationLevel> jsonNotationLevel;
    private final boolean prettyPrint;
    private final ClassLoaderReference classLoaderReference;
    private final ObjectWriter writer;
    private final DefaultPrettyPrinter prettyPrinter;
    private static final ThreadLocal<JSONSerializer> contextJsonSerializer = new ThreadLocal();

    private JSONSerializer(String name, ObjectMediationAliasManager aliasManager, ClassLoaderReference classLoaderReference, ObjectMapper mapper, JsonNotation jsonNotation, EnumSet<JsonNotationLevel> jsonNotationLevel, boolean prettyPrint, boolean classLoaderReferenceSet) {
        super(aliasManager);
        super.setClassLoader(classLoaderReferenceSet ? classLoaderReference.getReference() : null);
        this.name = name;
        this.mapper = mapper;
        this.jsonNotation = jsonNotation;
        this.jsonNotationLevel = jsonNotationLevel;
        this.prettyPrint = prettyPrint;
        this.classLoaderReference = classLoaderReference;
        classLoaderReference.setReference(this.getClassLoader());
        if (prettyPrint) {
            this.prettyPrinter = new DefaultPrettyPrinter();
            this.writer = mapper.writer().with(this.prettyPrinter);
        } else {
            this.prettyPrinter = null;
            this.writer = mapper.writer();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JsonNotation getJsonNotation() {
        return this.jsonNotation;
    }

    public EnumSet<JsonNotationLevel> getJsonNotationLevel() {
        return EnumSet.copyOf(this.jsonNotationLevel);
    }

    public boolean isSkipNulls() {
        return this.mapper.getSerializationConfig().getSerializationInclusion() == JsonInclude.Include.NON_NULL;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        this.classLoaderReference.setReference(super.getClassLoader());
    }

    public JSONSerializer withPrettyPrint(boolean prettyPrintEnabled) {
        return new JSONSerializer(this.getName(), this.aliasManager, this.classLoader, this.mapper, this.jsonNotation, this.jsonNotationLevel, prettyPrintEnabled, true);
    }

    public boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    @Override
    public String serialize(Object obj) throws SerializerException {
        try {
            obj = this.extractArrayFromWrapper(obj);
            return this.writer().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void serialize(Object obj, Writer writer) throws SerializerException {
        try {
            obj = this.extractArrayFromWrapper(obj);
            this.writer().writeValue(writer, obj);
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    public void serialize(Object obj, JsonGenerator generator) throws JSONSerializerException {
        try {
            obj = this.extractArrayFromWrapper(obj);
            this.writer().writeValue(generator, obj);
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public String serialize(String semanticType, Object obj) throws SerializerException {
        this.checkSemanticTypeMatch(this.getSemanticType(semanticType), obj, "serializing");
        return this.serialize(obj);
    }

    @Override
    public void serialize(String semanticType, Object obj, Writer writer) throws SerializerException {
        this.checkSemanticTypeMatch(this.getSemanticType(semanticType), obj, "serializing");
        this.serialize(obj, writer);
    }

    @Override
    public void serialize(Object obj, DataOutputStream stream) throws SerializerException {
        try {
            obj = this.extractArrayFromWrapper(obj);
            this.writer().writeValue(stream, obj);
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void serialize(String semanticType, Object obj, DataOutputStream stream) throws SerializerException {
        this.checkSemanticTypeMatch(this.getSemanticType(semanticType), obj, "serializing");
        this.serialize(obj, stream);
    }

    @Override
    public Object deserialize(String buffer) throws SerializerException {
        return this.deserialize(Object.class, buffer);
    }

    @Override
    public Object deserialize(Reader reader) throws SerializerException {
        return this.deserialize(Object.class, reader);
    }

    @Override
    public Object deserialize(byte[] buffer) throws SerializerException {
        return this.deserialize(Object.class, buffer);
    }

    @Override
    public Object deserialize(DataInputStream stream) throws SerializerException {
        return this.deserialize(Object.class, stream);
    }

    public Object deserialize(JsonParser parser) throws SerializerException {
        return this.deserialize(Object.class, parser);
    }

    @Override
    public Object deserialize(String semanticType, String buffer) throws SerializerException {
        return this.deserialize(this.resolveSemanticClass(semanticType), buffer);
    }

    @Override
    public Object deserialize(String semanticType, Reader reader) throws SerializerException {
        return this.deserialize(this.resolveSemanticClass(semanticType), reader);
    }

    @Override
    public Object deserialize(String semanticType, byte[] buffer) throws SerializerException {
        return this.deserialize(this.resolveSemanticClass(semanticType), buffer);
    }

    @Override
    public Object deserialize(String semanticType, DataInputStream stream) throws SerializerException {
        return this.deserialize(this.resolveSemanticClass(semanticType), stream);
    }

    public Object deserialize(String semanticType, JsonParser parser) throws SerializerException {
        return this.deserialize(this.resolveSemanticClass(semanticType), parser);
    }

    public <T> T deserialize(Class<T> objectClass, JsonParser parser) throws SerializerException {
        return (T)this.deserialize(objectClass, () -> this.mapper.readValue(parser, objectClass), () -> parser);
    }

    @Override
    public <T> T deserialize(Class<T> objectClass, String buffer) throws SerializerException {
        return (T)this.deserialize(objectClass, () -> this.mapper.readValue(buffer, objectClass), () -> this.mapper.getFactory().createParser(buffer));
    }

    public <T> T deserialize(Class<T> objectClass, byte[] buffer) throws SerializerException {
        return (T)this.deserialize(objectClass, () -> this.mapper.readValue(buffer, objectClass), () -> this.mapper.getFactory().createParser(buffer));
    }

    public <T> T deserialize(Class<T> objectClass, Reader reader) throws SerializerException {
        return (T)this.deserialize(objectClass, () -> this.mapper.readValue(reader, objectClass), () -> this.mapper.getFactory().createParser(reader));
    }

    public <T> T deserialize(Class<T> objectClass, DataInputStream stream) throws SerializerException {
        return (T)this.deserialize(objectClass, () -> this.mapper.readValue((InputStream)stream, objectClass), () -> this.mapper.getFactory().createParser(stream));
    }

    private <T> T deserialize(Class<T> objectClass, JsonRunnableWithException<T> readValue, JsonRunnableWithException<JsonParser> createParser) throws SerializerException {
        JSONSerializer currentJsonSerializer = contextJsonSerializer.get();
        try {
            Object fields;
            contextJsonSerializer.set(this);
            if (objectClass != null && ((Field[])(fields = objectClass.getDeclaredFields())).length == 1 && fields[0].isAnnotationPresent(Implicit.class)) {
                JsonParser jp = createParser.apply();
                TokenBuffer tb = new TokenBuffer(null, false);
                tb.writeFieldName(fields[0].getName());
                jp = JsonParserSequence.createFlattened(tb.asParser(jp), jp);
                T t = this.mapper.readValue(jp, objectClass);
                return t;
            }
            fields = readValue.apply();
            return (T)fields;
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
        finally {
            contextJsonSerializer.set(currentJsonSerializer);
        }
    }

    private Object extractArrayFromWrapper(Object object) {
        Field[] fields;
        if (object != null && (fields = object.getClass().getDeclaredFields()).length == 1 && fields[0].isAnnotationPresent(Implicit.class)) {
            fields[0].setAccessible(true);
            try {
                return fields[0].get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return object;
    }

    public JsonParser createParser(String content) throws IOException {
        return this.mapper.getFactory().createParser(content);
    }

    public JsonParser createParser(byte[] content) throws IOException {
        return this.mapper.getFactory().createParser(content);
    }

    public JsonGenerator createGenerator(OutputStream output, JsonEncoding encoding) throws IOException {
        return this.createGenerator(output, encoding, false);
    }

    public JsonGenerator createGenerator(OutputStream output, JsonEncoding encoding, boolean useSamePrettyPrinter) throws IOException {
        JsonGenerator generator = this.mapper.getFactory().createGenerator(output, encoding);
        generator.setPrettyPrinter(this.prettyPrinter);
        return generator;
    }

    @Override
    protected SerializerException createException(int errorCode, String message) {
        return new JSONSerializerException(errorCode, message);
    }

    @Override
    protected SerializerException createException(int errorCode, Throwable cause) {
        return new JSONSerializerException(errorCode, cause);
    }

    @Override
    protected SerializerException createException(int errorCode, String message, Throwable cause) {
        return new JSONSerializerException(errorCode, message, cause);
    }

    public Class<?> resolveSemanticClass(String semanticType) throws SerializerException {
        boolean array = false;
        if (semanticType != null && semanticType.trim().endsWith("[]")) {
            semanticType = semanticType.trim();
            semanticType = semanticType.substring(0, semanticType.length() - 2);
            array = true;
        }
        SemanticType type = this.getSemanticType(semanticType);
        try {
            Class<?> clazz = ClassUtils.loadClass(type.getClassName(), this.classLoader);
            if (array) {
                clazz = Array.newInstance(clazz, 0).getClass();
            }
            return clazz;
        }
        catch (ClassNotFoundException exception) {
            throw new JSONSerializerException(3025, (Throwable)exception);
        }
    }

    protected JSONSerializerException convertException(IOException exception) {
        return new JSONSerializerException(3014, (Throwable)exception);
    }

    private ObjectWriter writer() {
        return this.writer;
    }

    public static boolean isUnquotedString(String buffer) {
        int startPos;
        int endPos = buffer.length();
        for (startPos = 0; startPos < buffer.length() && buffer.charAt(startPos) <= ' '; ++startPos) {
        }
        while (endPos > startPos && buffer.charAt(endPos - 1) <= ' ') {
            --endPos;
        }
        if (startPos == endPos) {
            return true;
        }
        switch (buffer.charAt(startPos)) {
            case '\"': 
            case '\'': 
            case '[': 
            case '{': {
                return false;
            }
            case 't': {
                return endPos - startPos != "true".length() || !"true".equalsIgnoreCase(buffer.substring(startPos, endPos));
            }
            case 'f': {
                return endPos - startPos != "false".length() || !"false".equalsIgnoreCase(buffer.substring(startPos, endPos));
            }
            case 'n': {
                return endPos - startPos != "null".length() || !"null".equalsIgnoreCase(buffer.substring(startPos, endPos));
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return !buffer.substring(startPos).matches("[+-]?\\d*\\.?\\d+\\s*");
            }
        }
        return true;
    }

    public static JsonSerializerBuilderImpl builder() {
        return new JsonSerializerBuilderImpl();
    }

    public static JsonSerializerBuilderImpl builder(JSONSerializer template) {
        JsonSerializerBuilderImpl result = new JsonSerializerBuilderImpl();
        result.setAliasManager(template.aliasManager);
        result.setJsonNotation(template.getJsonNotation());
        result.setJsonNotationLevel(template.getJsonNotationLevel());
        result.setPrettyPrint(template.getPrettyPrint());
        result.setSkipNulls(template.isSkipNulls());
        return result;
    }

    public void failOnUnknownElements(boolean flag) {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, flag);
    }

    public static JSONSerializer getContextJsonSerializer() {
        return contextJsonSerializer.get();
    }

    static interface JsonRunnableWithException<T> {
        public T apply() throws IOException;
    }

    public static class JsonSerializerBuilderImpl
    extends AbstractJsonSerializerBuilder<JsonSerializerBuilderImpl> {
        private JsonSerializerBuilderImpl() {
        }
    }

    public static abstract class AbstractJsonSerializerBuilder<T>
    implements JsonSerializerBuilder<T> {
        private String name;
        private ObjectMediationAliasManager aliasManager;
        private JsonNotation jsonNotation;
        private EnumSet<JsonNotationLevel> jsonNotationLevel;
        private boolean prettyPrint = false;
        private boolean skipNulls = false;
        private boolean escapeHtmlCharacters = true;
        private List<SimpleModule> modules = new ArrayList<SimpleModule>();
        private ClassLoaderReference classLoaderReference = new ClassLoaderReference(null);
        private boolean classLoaderReferenceSet = false;
        private List<Consumer<ObjectMapper>> mapperConfigurations = new ArrayList<Consumer<ObjectMapper>>();
        private StdScalarSerializer<Date> dateSerializer = new JsonDateTimeSerializers.DefaultDateSerializer();
        private StdScalarDeserializer<Date> dateDeserializer = new JsonDateTimeSerializers.DefaultDateDeserializer();
        private StdScalarSerializer<java.sql.Date> sqlDateSerializer = new JsonDateTimeSerializers.DefaultSqlDateSerializer();
        private StdScalarDeserializer<java.sql.Date> sqlDateDeserializer = new JsonDateTimeSerializers.DefaultSqlDateDeserializer();
        private StdScalarSerializer<Time> sqlTimeSerializer = new JsonDateTimeSerializers.DefaultSqlTimeSerializer();
        private StdScalarDeserializer<Time> sqlTimeDeserializer = new JsonDateTimeSerializers.DefaultSqlTimeDeserializer();
        private StdScalarSerializer<Timestamp> sqlTimestampSerializer = new JsonDateTimeSerializers.DefaultSqlTimestampSerializer();
        private StdScalarDeserializer<Timestamp> sqlTimestampDeserializer = new JsonDateTimeSerializers.DefaultSqlTimestampDeserializer();

        protected AbstractJsonSerializerBuilder() {
        }

        @Override
        public T setName(String name) {
            this.name = name;
            return (T)this;
        }

        @Override
        public T setAliasManager(ObjectMediationAliasManager aliasManager) {
            this.aliasManager = aliasManager;
            return (T)this;
        }

        @Override
        public T setClassLoader(ClassLoader classLoader) {
            this.classLoaderReference.setReference(classLoader);
            this.classLoaderReferenceSet = true;
            return (T)this;
        }

        @Override
        public T setJsonNotation(JsonNotation jsonNotation) {
            this.jsonNotation = jsonNotation;
            return (T)this;
        }

        @Override
        public T setJsonNotationLevel(EnumSet<JsonNotationLevel> jsonNotationLevel) {
            this.jsonNotationLevel = jsonNotationLevel;
            return (T)this;
        }

        @Override
        public T setJsonNotationLevel(JsonNotationLevel ... jsonNotationLevel) {
            this.jsonNotationLevel = EnumSet.copyOf(Arrays.asList(jsonNotationLevel));
            return (T)this;
        }

        @Override
        public T addJsonNotationLevel(JsonNotationLevel ... jsonNotationLevel) {
            if (this.jsonNotationLevel == null) {
                this.jsonNotationLevel = EnumSet.copyOf(Arrays.asList(jsonNotationLevel));
            } else {
                this.jsonNotationLevel.addAll(Arrays.asList(jsonNotationLevel));
            }
            return (T)this;
        }

        @Override
        public T removeJsonNotationLevel(JsonNotationLevel ... jsonNotationLevel) {
            if (this.jsonNotationLevel != null) {
                this.jsonNotationLevel.removeAll(Arrays.asList(jsonNotationLevel));
            }
            return (T)this;
        }

        @Override
        public T setPrettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            return (T)this;
        }

        @Override
        public T setSkipNulls(boolean skipNulls) {
            this.skipNulls = skipNulls;
            return (T)this;
        }

        @Override
        public T setEscapeHtmlCharacters(boolean escapeHtmlCharacters) {
            this.escapeHtmlCharacters = escapeHtmlCharacters;
            return (T)this;
        }

        @Override
        public T addModule(SimpleModule module) {
            this.modules.add(module);
            return (T)this;
        }

        @Override
        public T mapperConfiguration(Consumer<ObjectMapper> consumer) {
            this.mapperConfigurations.add(consumer);
            return (T)this;
        }

        @Override
        public T setDateFormat(String format) {
            this.setDateFormat(JsonDateTimeSerializers.createSimpleDateFormat(format));
            return (T)this;
        }

        @Override
        public T setDateFormat(SimpleDateFormat format) {
            this.setDateSerializer(new JsonDateTimeSerializers.DateSerializer(format));
            this.setDateDeserializer(new JsonDateTimeSerializers.DateDeserializer(format));
            return (T)this;
        }

        @Override
        public T setDateSerializer(StdScalarSerializer<Date> serializer) {
            this.dateSerializer = serializer;
            return (T)this;
        }

        @Override
        public T setDateDeserializer(StdScalarDeserializer<Date> deserializer) {
            this.dateDeserializer = deserializer;
            return (T)this;
        }

        @Override
        public T setSqlDateFormat(String format) {
            this.setSqlDateFormat(JsonDateTimeSerializers.createSimpleDateFormat(format));
            return (T)this;
        }

        @Override
        public T setSqlDateFormat(SimpleDateFormat format) {
            this.setSqlDateSerializer(new JsonDateTimeSerializers.SqlDateSerializer(format));
            this.setSqlDateDeserializer(new JsonDateTimeSerializers.SqlDateDeserializer(format));
            return (T)this;
        }

        @Override
        public T setSqlDateSerializer(StdScalarSerializer<java.sql.Date> serializer) {
            this.sqlDateSerializer = serializer;
            return (T)this;
        }

        @Override
        public T setSqlDateDeserializer(StdScalarDeserializer<java.sql.Date> deserializer) {
            this.sqlDateDeserializer = deserializer;
            return (T)this;
        }

        @Override
        public T setSqlTimeFormat(String format) {
            this.setSqlTimeFormat(JsonDateTimeSerializers.createSimpleDateFormat(format));
            return (T)this;
        }

        @Override
        public T setSqlTimeFormat(SimpleDateFormat format) {
            this.setSqlTimeSerializer(new JsonDateTimeSerializers.SqlTimeSerializer(format));
            this.setSqlTimeDeserializer(new JsonDateTimeSerializers.SqlTimeDeserializer(format));
            return (T)this;
        }

        @Override
        public T setSqlTimeSerializer(StdScalarSerializer<Time> serializer) {
            this.sqlTimeSerializer = serializer;
            return (T)this;
        }

        @Override
        public T setSqlTimeDeserializer(StdScalarDeserializer<Time> deserializer) {
            this.sqlTimeDeserializer = deserializer;
            return (T)this;
        }

        @Override
        public T setSqlTimestampFormat(String format) {
            this.setSqlTimestampFormat(JsonDateTimeSerializers.createSimpleDateFormat(format));
            return (T)this;
        }

        @Override
        public T setSqlTimestampFormat(SimpleDateFormat format) {
            this.setSqlTimestampSerializer(new JsonDateTimeSerializers.SqlTimestampSerializer(format));
            this.setSqlTimestampDeserializer(new JsonDateTimeSerializers.SqlTimestampDeserializer(format));
            return (T)this;
        }

        @Override
        public T setSqlTimestampSerializer(StdScalarSerializer<Timestamp> serializer) {
            this.sqlTimestampSerializer = serializer;
            return (T)this;
        }

        @Override
        public T setSqlTimestampDeserializer(StdScalarDeserializer<Timestamp> deserializer) {
            this.sqlTimestampDeserializer = deserializer;
            return (T)this;
        }

        @Override
        public JSONSerializer build() {
            if (this.name == null) {
                throw new IllegalArgumentException("Name is not set.");
            }
            if (this.aliasManager == null) {
                throw new IllegalArgumentException("Alias manager is not set.");
            }
            if (this.jsonNotation == null) {
                throw new IllegalArgumentException("Json notation is not set.");
            }
            if (this.jsonNotationLevel == null || this.jsonNotationLevel.size() == 0) {
                throw new IllegalArgumentException("Json notation level is not set.");
            }
            this.jsonNotationLevel = EnumSet.copyOf(this.jsonNotationLevel);
            class MyModule
            extends SimpleModule {
                public MyModule() {
                    super("Enhanced Streamscape Jackson serializer.");
                }

                @Override
                public void setupModule(Module.SetupContext context) {
                    super.setupModule(context);
                    context.addDeserializers(new JacksonUtils.ContainerAdditionalDeserializers());
                    context.addSerializers(new JacksonUtils.ContainerAdditionalSerializers());
                    context.insertAnnotationIntrospector(new JacksonUtils.StreamscapeAnnotationInterceptor(AbstractJsonSerializerBuilder.this.classLoaderReference, AbstractJsonSerializerBuilder.this.skipNulls, context.getTypeFactory()));
                    context.setMixInAnnotations(Throwable.class, JacksonUtils.ThrowableMixIn.class);
                    context.setMixInAnnotations(IAbstractDataEvent.class, JacksonUtils.IAbstractDataEventMixIn.class);
                    context.setMixInAnnotations(DataEvent.class, JacksonUtils.DataEventMixIn.class);
                    context.setMixInAnnotations(RowSet.class, JacksonUtils.RowSetMixIn.class);
                    context.setMixInAnnotations(RowArray.class, JacksonUtils.RowArrayMixIn.class);
                }
            }
            MyModule module = new MyModule();
            module.addSerializer(Time.class, this.sqlTimeSerializer);
            module.addDeserializer(Time.class, this.sqlTimeDeserializer);
            module.addSerializer(java.sql.Date.class, this.sqlDateSerializer);
            module.addDeserializer(java.sql.Date.class, this.sqlDateDeserializer);
            module.addDeserializer(StackTraceElement.class, new StackTraceElementDeserializer());
            module.addSerializer(Address.class, new JacksonUtils.AddressSerializer());
            module.addDeserializer(Address.class, new JacksonUtils.AddressDeserializer());
            module.addDeserializer(InetAddress.class, new JacksonUtils.InetAddressDeserializer((Class<? extends InetAddress>)((Class<InetAddress>)Inet4Address.class)));
            module.addDeserializer(Inet4Address.class, new JacksonUtils.Inet4AddressDeserializer());
            module.addDeserializer(Inet6Address.class, new JacksonUtils.Inet6AddressDeserializer());
            module.addDeserializer(URL.class, new JacksonUtils.URLDeserializer());
            if (this.jsonNotationLevel.contains((Object)JsonNotationLevel.OLD_FABRIC_STYLE_DATE_AND_SQLTIMESTAMP)) {
                module.addSerializer(Timestamp.class, new JsonDateTimeSerializers.OldFabricStyleSqlTimestampSerializer());
                module.addDeserializer(Timestamp.class, new JsonDateTimeSerializers.OldFabricStyleSqlTimestampDeserializer());
                module.addSerializer(Date.class, new JsonDateTimeSerializers.OldFabricStyleDateSerializer());
                module.addDeserializer(Date.class, new JsonDateTimeSerializers.OldFabricStyleDateDeserializer());
            } else {
                module.addSerializer(Timestamp.class, this.sqlTimestampSerializer);
                module.addDeserializer(Timestamp.class, this.sqlTimestampDeserializer);
                module.addSerializer(Date.class, this.dateSerializer);
                module.addDeserializer(Date.class, this.dateDeserializer);
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule(module);
            mapper.setDefaultTyping(new StreamscapeResolverBuilder(this.aliasManager, this.classLoaderReference, this.jsonNotation, this.jsonNotationLevel));
            mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
            if (this.skipNulls) {
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            }
            if (this.escapeHtmlCharacters) {
                mapper.getFactory().setCharacterEscapes(new JacksonUtils.HtmlCharacterEscapes());
            }
            mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            mapper.getFactory().enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
            mapper.getFactory().enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES);
            mapper.getFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            mapper.getFactory().enable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
            mapper.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
            this.modules.forEach(mapper::registerModule);
            this.mapperConfigurations.forEach(c -> c.accept(mapper));
            return new JSONSerializer(this.name, this.aliasManager, this.classLoaderReference, mapper, this.jsonNotation, this.jsonNotationLevel, this.prettyPrint, this.classLoaderReferenceSet);
        }

        public String getName() {
            return this.name;
        }
    }

    public static interface JsonSerializerBuilder<T> {
        public T setName(String var1);

        public T setAliasManager(ObjectMediationAliasManager var1);

        public T setClassLoader(ClassLoader var1);

        public T setJsonNotation(JsonNotation var1);

        public T setJsonNotationLevel(EnumSet<JsonNotationLevel> var1);

        public T setJsonNotationLevel(JsonNotationLevel ... var1);

        public T addJsonNotationLevel(JsonNotationLevel ... var1);

        public T removeJsonNotationLevel(JsonNotationLevel ... var1);

        public T setPrettyPrint(boolean var1);

        public T setSkipNulls(boolean var1);

        public T setEscapeHtmlCharacters(boolean var1);

        public T addModule(SimpleModule var1);

        public T mapperConfiguration(Consumer<ObjectMapper> var1);

        public T setDateFormat(String var1);

        public T setDateFormat(SimpleDateFormat var1);

        public T setSqlDateFormat(String var1);

        public T setSqlDateFormat(SimpleDateFormat var1);

        public T setSqlTimeFormat(String var1);

        public T setSqlTimeFormat(SimpleDateFormat var1);

        public T setSqlTimestampFormat(String var1);

        public T setSqlTimestampFormat(SimpleDateFormat var1);

        public T setDateSerializer(StdScalarSerializer<Date> var1);

        public T setDateDeserializer(StdScalarDeserializer<Date> var1);

        public T setSqlDateSerializer(StdScalarSerializer<java.sql.Date> var1);

        public T setSqlDateDeserializer(StdScalarDeserializer<java.sql.Date> var1);

        public T setSqlTimeSerializer(StdScalarSerializer<Time> var1);

        public T setSqlTimeDeserializer(StdScalarDeserializer<Time> var1);

        public T setSqlTimestampSerializer(StdScalarSerializer<Timestamp> var1);

        public T setSqlTimestampDeserializer(StdScalarDeserializer<Timestamp> var1);

        public JSONSerializer build();
    }
}

