/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeSerializerBase;
import com.streamscape.omf.json.jackson.AsSemanticTypeSerializer;
import com.streamscape.omf.json.jackson.JacksonUtils;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import java.io.IOException;
import java.util.EnumSet;

class AsTopElementSerializer
extends TypeSerializerBase {
    private final EnumSet<JsonNotationLevel> jsonNotationLevel;

    public AsTopElementSerializer(TypeIdResolver idRes, BeanProperty property, EnumSet<JsonNotationLevel> jsonNotationLevel) {
        super(idRes, property);
        this.jsonNotationLevel = jsonNotationLevel;
    }

    @Override
    public AsTopElementSerializer forProperty(BeanProperty prop) {
        return this._property == prop ? this : new AsTopElementSerializer(this._idResolver, prop, this.jsonNotationLevel);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_OBJECT;
    }

    private boolean needToWriteTypeId(Object value, JsonGenerator jgen, boolean open) {
        return AsSemanticTypeSerializer.needToWriteTypeId(value, jgen, this._idResolver, this.jsonNotationLevel, JsonTypeInfo.As.WRAPPER_OBJECT, open);
    }

    private boolean needToWriteTypeIdForScalar(Object value, JsonGenerator jgen, boolean open) {
        boolean isEnum = value != null && (JacksonUtils.isEnum(value.getClass()) || value.getClass().isAnonymousClass() && value.getClass().getEnclosingClass().isEnum());
        boolean isPrimitive = value != null && JacksonUtils.isPrimitive(value.getClass());
        return isEnum && (!jgen.getOutputContext().inRoot() && this.jsonNotationLevel.contains((Object)JsonNotationLevel.ENUMS) || jgen.getOutputContext().inRoot() && this.jsonNotationLevel.contains((Object)JsonNotationLevel.ROOT_ENUM)) || !isEnum && isPrimitive && this.jsonNotationLevel.contains((Object)JsonNotationLevel.PRIMITIVE_OBJECTS) || (isEnum || isPrimitive) && this.getBaseType().getRawClass() == Object.class && this.jsonNotationLevel.contains((Object)JsonNotationLevel.POLYMORPHIC_PRIMITIVE_OBJECTS) || !isEnum && !isPrimitive && this.needToWriteTypeId(value, jgen, open);
    }

    private JavaType getBaseType() {
        return AsSemanticTypeSerializer.getBaseType(this._idResolver);
    }

    @Override
    public WritableTypeId writeTypePrefix(JsonGenerator g, WritableTypeId typeId) throws IOException {
        Object value = typeId.forValue;
        if (JacksonUtils.isScalar(value) || value != null && value.getClass() == byte[].class || typeId.valueShape == JsonToken.VALUE_STRING) {
            if (this.needToWriteTypeIdForScalar(value, g, true)) {
                typeId.extra = 201;
                typeId.valueShape = JsonToken.START_OBJECT;
                typeId = super.writeTypePrefix(g, typeId);
                g.writeFieldName("value");
            }
        } else if (typeId.valueShape == JsonToken.START_ARRAY) {
            g.writeStartArray();
        } else if (this.needToWriteTypeIdForScalar(value, g, true)) {
            typeId = super.writeTypePrefix(g, typeId);
        } else if (typeId.valueShape == JsonToken.START_OBJECT) {
            g.writeStartObject();
        }
        return typeId;
    }

    @Override
    public WritableTypeId writeTypeSuffix(JsonGenerator g, WritableTypeId typeId) throws IOException {
        Object value = typeId.forValue;
        if (JacksonUtils.isScalar(value)) {
            if (typeId.extra instanceof Integer && (Integer)typeId.extra == 201) {
                g.writeEndObject();
                g.writeEndObject();
            }
        } else if (typeId.valueShape == JsonToken.START_ARRAY) {
            g.writeEndArray();
        } else if (this.needToWriteTypeIdForScalar(value, g, false)) {
            typeId = super.writeTypeSuffix(g, typeId);
        } else if (typeId.valueShape == JsonToken.START_OBJECT) {
            g.writeEndObject();
            if (typeId.wrapperWritten) {
                g.writeEndObject();
            }
        }
        return typeId;
    }
}

