/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserDelegate;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeDeserializerBase;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.streamscape.omf.json.jackson.JacksonUtils;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.json.jackson.SemanticTypeIdResolver;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;

class AsTopElementDeserializer
extends TypeDeserializerBase {
    private final EnumSet<JsonNotationLevel> jsonNotationLevel;

    public AsTopElementDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, Class<?> defaultImpl, EnumSet<JsonNotationLevel> jsonNotationLevel) {
        super(bt, idRes, typePropertyName, typeIdVisible, null);
        this.jsonNotationLevel = jsonNotationLevel;
    }

    protected AsTopElementDeserializer(AsTopElementDeserializer src, BeanProperty property, EnumSet<JsonNotationLevel> jsonNotationLevel) {
        super(src, property);
        this.jsonNotationLevel = jsonNotationLevel;
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty prop) {
        return prop == this._property ? this : new AsTopElementDeserializer(this, prop, this.jsonNotationLevel);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_OBJECT;
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (!(jp instanceof JsonParserDelegate) && !jp.getParsingContext().inArray() && (jp.getParsingContext().inRoot() || jp.getParsingContext().getParent() != null && jp.getParsingContext().getParent().inRoot())) {
            return this.deserializeTypedFromAny(jp, ctxt);
        }
        if (jp.getCurrentToken() == JsonToken.START_OBJECT && (this.jsonNotationLevel.contains((Object)JsonNotationLevel.COMPLEX_OBJECTS) || this.jsonNotationLevel.contains((Object)JsonNotationLevel.POLYMORPHIC_OBJECTS) || this.jsonNotationLevel.contains((Object)JsonNotationLevel.ENUMS) || this.jsonNotationLevel.contains((Object)JsonNotationLevel.POLYMORPHIC_MAPS_AND_COLLECTIONS))) {
            JsonToken token = jp.nextToken();
            if (token != JsonToken.FIELD_NAME && token != JsonToken.END_OBJECT) {
                throw ctxt.wrongTokenException(jp, JsonToken.FIELD_NAME, "need filed name or object end after object start");
            }
            TokenBuffer tb = null;
            if (token == JsonToken.FIELD_NAME) {
                String fieldName = jp.getCurrentName();
                if (jp.nextToken() == JsonToken.START_OBJECT) {
                    try {
                        JsonDeserializer<Object> deser = this.findDeserializerInternal(ctxt, fieldName);
                        jp.nextToken();
                        Object object = null;
                        if ((deser.handledType() == byte[].class || JacksonUtils.isPrimitive(deser.handledType()) || JacksonUtils.isEnum(deser.handledType())) && jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                            jp.nextToken();
                        }
                        object = jp.getCurrentToken() == JsonToken.END_OBJECT && "object".equals(fieldName) ? new Object() : deser.deserialize(jp, ctxt);
                        if (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                            jp.nextToken();
                        }
                        jp.nextToken();
                        return object;
                    }
                    catch (Exception exception) {
                        tb = new TokenBuffer(null, false);
                        tb.writeFieldName(fieldName);
                    }
                } else {
                    tb = new TokenBuffer(null, false);
                    tb.writeFieldName(fieldName);
                }
            } else {
                tb = new TokenBuffer(null, false);
            }
            if (tb != null) {
                tb.copyCurrentEvent(jp);
                jp = JsonParserSequence.createFlattened(tb.asParser(jp), jp);
                jp.nextToken();
            }
        }
        return this.deserializeWithTypeId(jp, ctxt, null);
    }

    @Override
    public Object deserializeTypedFromArray(JsonParser jp, DeserializationContext ctxt) throws IOException {
        boolean hadStartArray = jp.isExpectedStartArrayToken();
        Object value = this.deserializeWithTypeId(jp, ctxt, null);
        if (hadStartArray && jp.getCurrentToken() != JsonToken.END_ARRAY) {
            throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "expected closing END_ARRAY after type information and deserialized value");
        }
        return value;
    }

    @Override
    public Object deserializeTypedFromScalar(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Class clazz = Object.class;
        if (this._baseType != null) {
            clazz = this._baseType.getRawClass();
        }
        if (this.jsonNotationLevel.contains((Object)JsonNotationLevel.PRIMITIVE_OBJECTS) && (JacksonUtils.isPrimitive(clazz) || clazz == Object.class) || (this.jsonNotationLevel.contains((Object)JsonNotationLevel.ENUMS) && !ctxt.getParser().getParsingContext().inRoot() || this.jsonNotationLevel.contains((Object)JsonNotationLevel.ROOT_ENUM) && (ctxt.getParser().getParsingContext().inRoot() || ctxt.getParser().getParsingContext().getParent() != null && ctxt.getParser().currentToken() == JsonToken.START_OBJECT && ctxt.getParser().getParsingContext().getParent().inRoot())) && (JacksonUtils.isEnum(clazz) || clazz == Object.class)) {
            if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
                throw ctxt.wrongTokenException(jp, JsonToken.START_OBJECT, "need JSON Object to contain As.WRAPPER_OBJECT type information for class " + this.baseTypeName());
            }
            if (jp.nextToken() != JsonToken.FIELD_NAME) {
                throw ctxt.wrongTokenException(jp, JsonToken.FIELD_NAME, "need JSON String that contains type id (for subtype of " + this.baseTypeName() + ")");
            }
            String typeId = jp.getText();
            if (jp.nextToken() != JsonToken.START_OBJECT) {
                throw ctxt.wrongTokenException(jp, JsonToken.START_OBJECT, "need start object for primitive value");
            }
            if (jp.nextToken() != JsonToken.FIELD_NAME) {
                throw ctxt.wrongTokenException(jp, JsonToken.START_OBJECT, "need value field for primitive value");
            }
            jp.nextToken();
            JsonDeserializer<Object> deser = this.findDeserializerInternal(ctxt, typeId);
            Object object = deser.deserialize(jp, ctxt);
            jp.nextToken();
            jp.nextToken();
            return object;
        }
        return this.findDeserializerInternal(ctxt, this._idResolver.idFromBaseType()).deserialize(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromAny(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (!(jp instanceof JsonParserDelegate) && !jp.getParsingContext().inArray() && (jp.getParsingContext().inRoot() || jp.getParsingContext().getParent() != null && jp.getParsingContext().getParent().inRoot())) {
            String typeId = null;
            if (this.jsonNotationLevel.contains((Object)JsonNotationLevel.ROOT_ELEMENT) || this.jsonNotationLevel.contains((Object)JsonNotationLevel.ROOT_ENUM)) {
                if (jp.nextToken() != JsonToken.FIELD_NAME) {
                    throw ctxt.wrongTokenException(jp, JsonToken.FIELD_NAME, "need JSON String that contains type id (for subtype of " + this.baseTypeName() + ")");
                }
                typeId = jp.getText();
                jp.nextToken();
            }
            Object object = this.deserializeWithTypeId(jp, ctxt, typeId);
            jp.nextToken();
            return object;
        }
        return this.deserializeTypedFromObject(jp, ctxt);
    }

    private Object deserializeWithTypeId(JsonParser jp, DeserializationContext ctxt, String typeId) throws IOException {
        JsonDeserializer<Object> deser;
        if (typeId == null) {
            typeId = this._idResolver.idFromBaseType();
        }
        if ((deser = this.findDeserializerInternal(ctxt, typeId)) instanceof EnumDeserializer && this.jsonNotationLevel.contains((Object)JsonNotationLevel.ROOT_ENUM)) {
            return this.deserializerEnum(jp, deser, ctxt);
        }
        if (jp.getCurrentToken() == JsonToken.END_OBJECT && "object".equals(typeId)) {
            return new Object();
        }
        return deser.deserialize(jp, ctxt);
    }

    private Object deserializerEnum(JsonParser jp, JsonDeserializer deser, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            jp.nextToken();
        }
        if (jp.getCurrentToken() != JsonToken.FIELD_NAME || !"value".equals(jp.getText())) {
            throw ctxt.wrongTokenException(jp, JsonToken.FIELD_NAME, "expected value field for wrapped enum");
        }
        jp.nextToken();
        if (jp.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "expected enum string value");
        }
        Object object = deser.deserialize(jp, ctxt);
        jp.nextToken();
        return object;
    }

    private JsonDeserializer<Object> findDeserializerInternal(DeserializationContext ctxt, String typeId) throws IOException {
        JsonDeserializer<Object> deserializer = AsTopElementDeserializer.findDeserializerInternalHelper(ctxt, typeId, this._deserializers, this._idResolver);
        if (deserializer == null) {
            deserializer = super._findDeserializer(ctxt, typeId);
        }
        return deserializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JsonDeserializer<Object> findDeserializerInternalHelper(DeserializationContext ctxt, String typeId, Map<String, JsonDeserializer<Object>> deserializers, TypeIdResolver idResolver) throws IOException {
        Map<String, JsonDeserializer<Object>> map = deserializers;
        synchronized (map) {
            JavaType valueType;
            JsonDeserializer<Object> deserializer = deserializers.get(typeId);
            if (deserializer instanceof BeanDeserializerBase && (valueType = ((BeanDeserializerBase)deserializer).getValueType()) != null && valueType.getRawClass() != null) {
                Class<?> clazz = null;
                try {
                    clazz = ((SemanticTypeIdResolver)idResolver).getClassLoader().loadClass(valueType.getRawClass().getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz != valueType.getRawClass()) {
                    deserializers.remove(typeId);
                    deserializer = null;
                }
            }
            return deserializer;
        }
    }
}

