/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeSerializerBase;
import com.streamscape.omf.json.jackson.JacksonUtils;
import com.streamscape.omf.json.jackson.JsonGeneratorRootWrapper;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.json.jackson.SemanticTypeIdResolver;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.EnumSet;

class AsSemanticTypeSerializer
extends TypeSerializerBase {
    private final String typePropertyName;
    private final EnumSet<JsonNotationLevel> jsonNotationLevel;

    public AsSemanticTypeSerializer(TypeIdResolver idResolver, BeanProperty property, String typePropertyName, EnumSet<JsonNotationLevel> jsonNotationLevel) {
        super(idResolver, property);
        this.typePropertyName = typePropertyName;
        this.jsonNotationLevel = jsonNotationLevel;
    }

    @Override
    public AsSemanticTypeSerializer forProperty(BeanProperty prop) {
        return this._property == prop ? this : new AsSemanticTypeSerializer(this._idResolver, prop, this.typePropertyName, this.jsonNotationLevel);
    }

    @Override
    public String getPropertyName() {
        return this.typePropertyName;
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.PROPERTY;
    }

    private boolean needToWriteTypeIdForScalar(Object value, JsonGenerator jgen) {
        boolean isEnum = value != null && JacksonUtils.isEnum(value.getClass());
        boolean isPrimitive = value != null && JacksonUtils.isPrimitive(value.getClass());
        return isEnum && (!jgen.getOutputContext().inRoot() && this.jsonNotationLevel.contains((Object)JsonNotationLevel.ENUMS) || jgen.getOutputContext().inRoot() && this.jsonNotationLevel.contains((Object)JsonNotationLevel.ROOT_ENUM)) || !isEnum && isPrimitive && this.jsonNotationLevel.contains((Object)JsonNotationLevel.PRIMITIVE_OBJECTS) || (isEnum || isPrimitive) && this.jsonNotationLevel.contains((Object)JsonNotationLevel.POLYMORPHIC_PRIMITIVE_OBJECTS) && this.getBaseType().getRawClass() == Object.class || !isEnum && !isPrimitive && this.needToWriteTypeId(value, jgen);
    }

    private boolean needToWriteTypeId(Object value, JsonGenerator jgen) {
        return AsSemanticTypeSerializer.needToWriteTypeId(value, jgen, this._idResolver, this.jsonNotationLevel, JsonTypeInfo.As.PROPERTY, true);
    }

    static boolean needToWriteTypeId(Object value, JsonGenerator jgen, TypeIdResolver idResolver, EnumSet<JsonNotationLevel> jsonNotationLevel, JsonTypeInfo.As as, boolean open) {
        if (value == null) {
            return false;
        }
        if (jsonNotationLevel.contains((Object)JsonNotationLevel.OLD_FABRIC_STYLE_DATE_AND_SQLTIMESTAMP) && as == JsonTypeInfo.As.PROPERTY && (value.getClass() == Date.class || value.getClass() == Timestamp.class)) {
            return true;
        }
        if (JacksonUtils.isPrimitive(value.getClass()) || value.getClass() == byte[].class) {
            if (jsonNotationLevel.contains((Object)JsonNotationLevel.PRIMITIVE_OBJECTS)) {
                return true;
            }
            if (AsSemanticTypeSerializer.getBaseType(idResolver).getRawClass() == Object.class) {
                return jsonNotationLevel.contains((Object)JsonNotationLevel.POLYMORPHIC_PRIMITIVE_OBJECTS);
            }
        }
        if (JacksonUtils.isEnum(value.getClass())) {
            if ((as == JsonTypeInfo.As.PROPERTY || as == JsonTypeInfo.As.WRAPPER_OBJECT && open) && jgen.getOutputContext().getParent() != null && jgen.getOutputContext().getParent().inRoot() || as == JsonTypeInfo.As.WRAPPER_OBJECT && !open && jgen.getOutputContext().getParent() != null && jgen.getOutputContext().getParent().getParent() != null && jgen.getOutputContext().getParent().getParent().inRoot()) {
                return jsonNotationLevel.contains((Object)JsonNotationLevel.ROOT_ENUM);
            }
            return AsSemanticTypeSerializer.getBaseType(idResolver).getRawClass() == Object.class && jsonNotationLevel.contains((Object)JsonNotationLevel.POLYMORPHIC_PRIMITIVE_OBJECTS) || jsonNotationLevel.contains((Object)JsonNotationLevel.ENUMS);
        }
        if (jgen instanceof JsonGeneratorRootWrapper && (((JsonGeneratorRootWrapper)jgen).getRootContext() == jgen.getOutputContext() || ((JsonGeneratorRootWrapper)jgen).getRootContext() == jgen.getOutputContext().getParent())) {
            return jsonNotationLevel.contains((Object)JsonNotationLevel.ROOT_ELEMENT);
        }
        if (as == JsonTypeInfo.As.WRAPPER_OBJECT && !jgen.getOutputContext().inArray() && (jgen.getOutputContext() == null || jgen.getOutputContext().inRoot())) {
            return jsonNotationLevel.contains((Object)JsonNotationLevel.ROOT_ELEMENT);
        }
        if (as == JsonTypeInfo.As.PROPERTY && jgen.getOutputContext().inRoot()) {
            return jsonNotationLevel.contains((Object)JsonNotationLevel.ROOT_ELEMENT);
        }
        if (jsonNotationLevel.contains((Object)JsonNotationLevel.COMPLEX_OBJECTS)) {
            return true;
        }
        return jsonNotationLevel.contains((Object)JsonNotationLevel.POLYMORPHIC_OBJECTS) && ((SemanticTypeIdResolver)idResolver).getBaseType().getRawClass() != value.getClass();
    }

    private JavaType getBaseType() {
        return AsSemanticTypeSerializer.getBaseType(this._idResolver);
    }

    static JavaType getBaseType(TypeIdResolver idResolver) {
        return ((SemanticTypeIdResolver)idResolver).getBaseType();
    }

    @Override
    public WritableTypeId writeTypePrefix(JsonGenerator g, WritableTypeId typeId) throws IOException {
        Object value = typeId.forValue;
        if (JacksonUtils.isScalar(value) || value != null && value.getClass() == byte[].class || typeId.valueShape == JsonToken.VALUE_STRING) {
            if (this.needToWriteTypeIdForScalar(value, g)) {
                typeId.extra = 201;
                typeId.valueShape = JsonToken.START_OBJECT;
                typeId = super.writeTypePrefix(g, typeId);
                g.writeFieldName("value");
            }
        } else if (typeId.valueShape == JsonToken.START_ARRAY) {
            g.writeStartArray();
        } else if (this.needToWriteTypeIdForScalar(value, g)) {
            typeId.extra = 201;
            typeId = super.writeTypePrefix(g, typeId);
        } else if (typeId.valueShape == JsonToken.START_OBJECT) {
            g.writeStartObject();
        }
        return typeId;
    }

    @Override
    public WritableTypeId writeTypeSuffix(JsonGenerator g, WritableTypeId typeId) throws IOException {
        Object value = typeId.forValue;
        if (JacksonUtils.isScalar(value)) {
            if (typeId.extra instanceof Integer && (Integer)typeId.extra == 201) {
                g.writeEndObject();
            }
        } else if (typeId.valueShape == JsonToken.START_ARRAY) {
            g.writeEndArray();
        } else if (typeId.extra instanceof Integer && (Integer)typeId.extra == 201) {
            typeId = super.writeTypeSuffix(g, typeId);
        } else if (typeId.valueShape == JsonToken.START_OBJECT) {
            g.writeEndObject();
        }
        return typeId;
    }
}

