/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.streamscape.omf.json.jackson.AsTopElementDeserializer;
import com.streamscape.omf.json.jackson.JacksonUtils;
import com.streamscape.omf.json.jackson.JsonDateTimeSerializers;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.json.jackson.SemanticTypeIdResolver;
import java.io.IOException;
import java.util.EnumSet;

class AsSemanticTypeDeserializer
extends AsArrayTypeDeserializer {
    private static final long serialVersionUID = 1L;
    private EnumSet<JsonNotationLevel> jsonNotationLevel;

    public AsSemanticTypeDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl, EnumSet<JsonNotationLevel> jsonNotationLevel) {
        super(bt, idRes, typePropertyName, typeIdVisible, defaultImpl);
        this.jsonNotationLevel = jsonNotationLevel;
    }

    public AsSemanticTypeDeserializer(AsSemanticTypeDeserializer src, BeanProperty property) {
        super(src, property);
        this.jsonNotationLevel = src.jsonNotationLevel;
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty prop) {
        return prop == this._property ? this : new AsSemanticTypeDeserializer(this, prop);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.PROPERTY;
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Object typeId;
        if (jp.canReadTypeId() && (typeId = jp.getTypeId()) != null) {
            return this._deserializeWithNativeTypeId(jp, ctxt, typeId);
        }
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        } else {
            if (t == JsonToken.START_ARRAY) {
                return this._deserializeTypedUsingDefaultImpl(jp, ctxt, null);
            }
            if (t != JsonToken.FIELD_NAME) {
                return this._deserializeTypedUsingDefaultImpl(jp, ctxt, null);
            }
        }
        if (t == JsonToken.FIELD_NAME) {
            String name = jp.getCurrentName();
            if (this._typePropertyName.equals(name)) {
                jp.nextToken();
                return this._deserializeTypedForId(jp, ctxt, null);
            }
            TokenBuffer tb = new TokenBuffer(null, false);
            tb.writeFieldName(name);
            jp = JsonParserSequence.createFlattened(tb.asParser(jp), jp);
            jp.nextToken();
        }
        return this._deserializeTypedUsingDefaultImpl(jp, ctxt, null);
    }

    protected final Object _deserializeTypedForId(JsonParser jp, DeserializationContext ctxt, TokenBuffer tb) throws IOException {
        String typeId = jp.getText();
        JsonDeserializer<Object> deser = this.findDeserializerInternal(ctxt, typeId);
        if (this._typeIdVisible) {
            if (tb == null) {
                tb = new TokenBuffer(null, false);
            }
            tb.writeFieldName(jp.getCurrentName());
            tb.writeString(typeId);
        }
        if (tb != null) {
            jp = JsonParserSequence.createFlattened(tb.asParser(jp), jp);
        }
        jp.nextToken();
        if ((JacksonUtils.isPrimitive(deser.handledType()) && !(deser instanceof JsonDateTimeSerializers.AbstractOldFabricStyleDeserializer) || deser.handledType() == byte[].class || JacksonUtils.isEnum(deser.handledType())) && jp.getCurrentName().equals("value")) {
            jp.nextToken();
            Object result = deser.deserialize(jp, ctxt);
            jp.nextToken();
            return result;
        }
        if (jp.getCurrentToken() == JsonToken.END_OBJECT && "object".equals(typeId)) {
            return new Object();
        }
        return deser.deserialize(jp, ctxt);
    }

    protected Object _deserializeTypedUsingDefaultImpl(JsonParser jp, DeserializationContext ctxt, TokenBuffer tb) throws IOException {
        JsonDeserializer<Object> deser = this._findDefaultImplDeserializer(ctxt);
        if (deser != null) {
            if (tb != null) {
                tb.writeEndObject();
                jp = tb.asParser(jp);
                jp.nextToken();
            }
            if (((SemanticTypeIdResolver)this._idResolver).getBaseType().getRawClass() == Object.class && jp.getCurrentToken() == JsonToken.END_OBJECT) {
                return new Object();
            }
            return deser.deserialize(jp, ctxt);
        }
        Object result = TypeDeserializer.deserializeIfNatural(jp, ctxt, this._baseType);
        if (result != null) {
            return result;
        }
        if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
            return super.deserializeTypedFromAny(jp, ctxt);
        }
        throw ctxt.wrongTokenException(jp, JsonToken.FIELD_NAME, "missing property '" + this._typePropertyName + "' that is to contain type id  (for class " + this.baseTypeName() + ")");
    }

    @Override
    public Object deserializeTypedFromAny(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
            return this.deserializeTypedFromArray(jp, ctxt);
        }
        return this.deserializeTypedFromObject(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromArray(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Object typeId;
        if (jp.canReadTypeId() && (typeId = jp.getTypeId()) != null) {
            return this._deserializeWithNativeTypeId(jp, ctxt, typeId);
        }
        boolean hadStartArray = jp.isExpectedStartArrayToken();
        if (!hadStartArray) {
            return super.deserializeTypedFromArray(jp, ctxt);
        }
        if (this._defaultImpl == null) {
            throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "need JSON Array to contain As.WRAPPER_ARRAY type information for class " + this.baseTypeName());
        }
        String typeId2 = this._idResolver.idFromBaseType();
        if (typeId2 != null && typeId2.equals("object")) {
            typeId2 = Object[].class.getName();
        }
        JsonDeserializer<Object> deser = this.findDeserializerInternal(ctxt, typeId2);
        if (this._typeIdVisible && jp.getCurrentToken() == JsonToken.START_OBJECT) {
            TokenBuffer tb = new TokenBuffer(null, false);
            tb.writeStartObject();
            tb.writeFieldName(this._typePropertyName);
            tb.writeString(typeId2);
            jp = JsonParserSequence.createFlattened(tb.asParser(jp), jp);
            jp.nextToken();
        }
        Object value = deser.deserialize(jp, ctxt);
        if (hadStartArray && jp.getCurrentToken() != JsonToken.END_ARRAY) {
            throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "expected closing END_ARRAY after type information and deserialized value");
        }
        return value;
    }

    @Override
    public Object deserializeTypedFromScalar(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            return this.deserializeTypedFromObject(jp, ctxt);
        }
        return super.deserializeTypedFromScalar(jp, ctxt);
    }

    private JsonDeserializer<Object> findDeserializerInternal(DeserializationContext ctxt, String typeId) throws IOException {
        JsonDeserializer<Object> deserializer = AsTopElementDeserializer.findDeserializerInternalHelper(ctxt, typeId, this._deserializers, this._idResolver);
        if (deserializer == null) {
            deserializer = super._findDeserializer(ctxt, typeId);
        }
        return deserializer;
    }
}

