/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.streamscape.Trace;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.serializer.AbstractSerializerFactory;
import com.streamscape.omf.serializer.Serializer;
import com.streamscape.omf.serializer.SerializerFactory;
import com.streamscape.omf.serializer.SerializerUtils;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sef.dispatcher.AbstractOMFManager;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class JSONSerializerFactory
extends AbstractSerializerFactory
implements SerializerFactory {
    private static final String FACTORY_NAME = "JSONSerializer";
    private static JSONSerializerFactory instance = null;
    private static ObjectMapper defaultEmptyMapper = null;
    private transient Map<String, JSONSerializer> serializers = new ConcurrentHashMap<String, JSONSerializer>();

    public static JSONSerializerFactory getInstance() {
        JSONSerializerFactory.init(null, null);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void init(AbstractOMFManager omfManager, ObjectMediationAliasManager manager) {
        if (instance != null) return;
        Class<JSONSerializerFactory> clazz = JSONSerializerFactory.class;
        synchronized (JSONSerializerFactory.class) {
            if (instance == null) {
                instance = new JSONSerializerFactory(omfManager, manager);
            }
            if (defaultEmptyMapper != null) return;
            defaultEmptyMapper = JSONSerializerFactory.createDefaultEmptyMapper();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private JSONSerializerFactory(AbstractOMFManager omfManager, ObjectMediationAliasManager manager) {
        super(omfManager, manager);
        try {
            SerializerUtils.addSysAliases(this.aliasManager);
            SerializerUtils.addSysTypeAliases(this.aliasManager);
        }
        catch (Throwable exception) {
            throw new RuntimeException("Initialization of JSONSerializerFactory failed.", exception);
        }
        try {
            this.createSerializerDefaultBuilderLazy("sys$serializer").apply(builder -> builder.setAliasManager(this.aliasManager)).getOrBuild();
        }
        catch (Exception exception) {
            throw new RuntimeException("Initialization of JSONSerializerFactory failed.", exception);
        }
        Trace.logInfo(JSONSerializerFactory.class, "JSONSerializer Factory initialized.");
    }

    public ObjectMapper getDefaultEmptyMapper() {
        return defaultEmptyMapper;
    }

    public static ObjectMapper createDefaultEmptyMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.getFactory().enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
        mapper.getFactory().enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES);
        return mapper;
    }

    public JsonSerializerFactoryBuilderLazy createSerializerDefaultBuilderLazy(String name) {
        return new JsonSerializerFactoryBuilderLazyImpl(name, () -> (JsonSerializerFactoryBuilder)((JsonSerializerFactoryBuilder)((JsonSerializerFactoryBuilder)((JsonSerializerFactoryBuilder)new JsonSerializerFactoryBuilderImpl().setName(name)).setAliasManager(instance != null ? JSONSerializerFactory.instance.aliasManager : null)).setJsonNotation(JsonNotation.TOP_ELEMENT)).setJsonNotationLevel(EnumSet.of(JsonNotationLevel.ROOT_ELEMENT, JsonNotationLevel.ROOT_ENUM, JsonNotationLevel.POLYMORPHIC_OBJECTS, JsonNotationLevel.POLYMORPHIC_MAPS_AND_COLLECTIONS)));
    }

    @Override
    public JSONSerializer createSerializer(String name) {
        return this.createSerializerDefaultBuilderLazy(name).getOrBuild();
    }

    @Override
    public Serializer createSerializer(String name, ObjectMediationAliasManager aliasMgr) {
        return this.createSerializerDefaultBuilderLazy(name).apply(builder -> builder.setAliasManager(aliasMgr)).getOrBuild();
    }

    @Override
    public JSONSerializer getDefaultSerializer() {
        return this.lookupSerializer("sys$serializer");
    }

    @Override
    public JSONSerializer lookupSerializer(String name) {
        if (this.serializers != null) {
            return this.serializers.get(name);
        }
        return null;
    }

    @Override
    public List<String> listSerializers() {
        return new ArrayList<String>(this.serializers.keySet());
    }

    @Override
    public void discardSerializer(String name) throws FactoryManagerException {
        JSONSerializer serializer = this.serializers.remove(name);
        if (serializer == null) {
            throw new FactoryManagerException(3040, "JSON serializer '" + name + "' does not exist.");
        }
        serializer.destroy();
    }

    @Override
    public synchronized void destroy() {
        for (String serializer : new ArrayList<String>(this.serializers.keySet())) {
            try {
                this.discardSerializer(serializer);
            }
            catch (FactoryManagerException exception) {
                Trace.logException(this, exception, true);
            }
        }
        this.serializers = null;
        instance = null;
    }

    @Override
    public void alias(SemanticType stype) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.alias(stype);
        }
    }

    @Override
    public void alias(String alias, Class type) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.alias(alias, type);
        }
    }

    @Override
    public void aliasImmutableType(SemanticType stype) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.aliasImmutableType(stype);
        }
    }

    @Override
    public void aliasImmutableType(Class type) {
        if (this.aliasManager != null) {
            this.aliasManager.aliasImmutableType(type);
        }
    }

    @Override
    public boolean isImmutableTypeAliased(Class type) {
        return this.aliasManager != null && this.aliasManager.isImmutableTypeAliased(type);
    }

    @Override
    public void unalias(SemanticType type) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.unalias(type);
        }
    }

    @Override
    public void unalias(String alias) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.unalias(alias);
        }
    }

    @Override
    public List<String> listAliases() {
        if (this.aliasManager != null) {
            return this.aliasManager.listAliases();
        }
        return new ArrayList<String>();
    }

    @Override
    public String lookup(Class clazz) {
        if (this.aliasManager != null) {
            return this.aliasManager.lookup(clazz);
        }
        return null;
    }

    @Override
    public String lookup(String typeName) {
        if (this.aliasManager != null) {
            return this.aliasManager.lookup(typeName);
        }
        return null;
    }

    @Override
    public SemanticType lookupSemanticType(String aliasName) {
        if (this.aliasManager != null) {
            return this.aliasManager.lookupSemanticType(aliasName);
        }
        return null;
    }

    @Override
    public String resolveClass(String className) {
        if (this.aliasManager != null) {
            return this.aliasManager.resolveClass(className);
        }
        return null;
    }

    @Override
    public String getName() {
        return FACTORY_NAME;
    }

    @Override
    public boolean isAliased(String alias) {
        return this.aliasManager != null && this.aliasManager.isAliased(alias);
    }

    @Override
    public boolean isAliased(Class type) {
        return this.aliasManager != null && this.aliasManager.isAliased(type);
    }

    public static interface JsonSerializerFactoryBuilderLazy {
        public JsonSerializerFactoryBuilderLazy apply(Consumer<JsonSerializerFactoryBuilder> var1);

        public JsonSerializerFactoryBuilderLazy postApply(Function<JSONSerializer, JSONSerializer> var1);

        public JSONSerializer build();

        public JSONSerializer getOrBuild();

        public JSONSerializer buildAndReplace();

        public JsonSerializerFactoryBuilder builder();
    }

    private class JsonSerializerFactoryBuilderLazyImpl
    implements JsonSerializerFactoryBuilderLazy {
        private Supplier<JsonSerializerFactoryBuilder> supplier;
        private List<Consumer<JsonSerializerFactoryBuilder>> consumers;
        private List<Function<JSONSerializer, JSONSerializer>> postFunctions;

        JsonSerializerFactoryBuilderLazyImpl(String name, Supplier<JsonSerializerFactoryBuilder> supplier) {
            this.supplier = supplier;
        }

        @Override
        public JsonSerializerFactoryBuilderLazy apply(Consumer<JsonSerializerFactoryBuilder> consumer) {
            if (consumer == null) {
                return this;
            }
            if (this.consumers == null) {
                this.consumers = new ArrayList<Consumer<JsonSerializerFactoryBuilder>>();
            }
            this.consumers.add(consumer);
            return this;
        }

        @Override
        public JsonSerializerFactoryBuilderLazyImpl postApply(Function<JSONSerializer, JSONSerializer> function) {
            if (this.postFunctions == null) {
                this.postFunctions = new ArrayList<Function<JSONSerializer, JSONSerializer>>();
            }
            this.postFunctions.add(function);
            return this;
        }

        @Override
        public JSONSerializer build() {
            return this.postApply(this.builder().build());
        }

        @Override
        public JSONSerializer getOrBuild() {
            JSONSerializer serializer = JSONSerializerFactory.this.serializers.get(JSONSerializerFactory.this.getName());
            if (serializer == null) {
                serializer = this.builder().getOrBuild();
            }
            return this.postApply(serializer);
        }

        @Override
        public JSONSerializer buildAndReplace() {
            return this.postApply(this.builder().buildAndReplace());
        }

        @Override
        public JsonSerializerFactoryBuilder builder() {
            JsonSerializerFactoryBuilder builder = this.supplier.get();
            if (this.consumers != null) {
                this.consumers.forEach(c -> c.accept(builder));
            }
            return builder;
        }

        private JSONSerializer postApply(JSONSerializer serializer) {
            if (serializer != null && this.postFunctions != null) {
                for (Function<JSONSerializer, JSONSerializer> postFunction : this.postFunctions) {
                    serializer = postFunction.apply(serializer);
                }
            }
            return serializer;
        }
    }

    public static interface JsonSerializerFactoryBuilder
    extends JSONSerializer.JsonSerializerBuilder<JsonSerializerFactoryBuilder> {
        public JSONSerializer getOrBuild();

        public JSONSerializer buildAndReplace();
    }

    private class JsonSerializerFactoryBuilderImpl
    extends JSONSerializer.AbstractJsonSerializerBuilder<JsonSerializerFactoryBuilder>
    implements JsonSerializerFactoryBuilder {
        private JsonSerializerFactoryBuilderImpl() {
        }

        @Override
        public JSONSerializer build() {
            return super.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JSONSerializer getOrBuild() {
            JSONSerializer serializer = JSONSerializerFactory.this.serializers.get(this.getName());
            if (serializer != null) {
                return serializer;
            }
            Map<String, JSONSerializer> map = JSONSerializerFactory.this.serializers;
            synchronized (map) {
                serializer = JSONSerializerFactory.this.serializers.get(this.getName());
                if (serializer != null) {
                    return serializer;
                }
                serializer = super.build();
                JSONSerializerFactory.this.serializers.put(serializer.getName(), serializer);
                return serializer;
            }
        }

        @Override
        public JSONSerializer buildAndReplace() {
            JSONSerializer serializer = super.build();
            JSONSerializerFactory.this.serializers.put(serializer.getName(), serializer);
            return serializer;
        }
    }
}

