/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.java.defaults;

import com.streamscape.omf.java.AbstractSerialSupport;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class ThrowableSerialSupport
extends AbstractSerialSupport {
    @Override
    public void serialize(Object obj, DataOutputStream output, JSerializer serializer) throws JSerializerException {
        Throwable exception = (Throwable)obj;
        Utils.serialize(exception.getMessage(), output);
        this.serialize(serializer, exception.getStackTrace(), output);
        this.serialize(serializer, exception.getCause(), output);
    }

    @Override
    public Object instantiate(DataInputStream input, JSerializer serializer) throws JSerializerException {
        Throwable result = this.createInstance(Utils.deserialize(input));
        result.setStackTrace((StackTraceElement[])this.deserialize(serializer, input));
        Throwable cause = (Throwable)this.deserialize(serializer, input);
        if (cause != null) {
            result.initCause(cause);
        }
        return result;
    }

    @Override
    public void deserialize(Object obj, DataInputStream input, JSerializer serializer) throws JSerializerException {
    }

    protected Throwable createInstance(String message) {
        return new Throwable(message);
    }
}

