/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.java.defaults;

import com.streamscape.omf.java.AbstractSerialSupport;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class StackTraceElementSerialSupport
extends AbstractSerialSupport {
    @Override
    public void serialize(Object obj, DataOutputStream output, JSerializer serializer) throws JSerializerException {
        StackTraceElement element = (StackTraceElement)obj;
        Utils.serialize(element.getClassLoaderName(), output);
        Utils.serialize(element.getModuleName(), output);
        Utils.serialize(element.getModuleVersion(), output);
        Utils.serialize(element.getClassName(), output);
        Utils.serialize(element.getMethodName(), output);
        Utils.serialize(element.getFileName(), output);
        try {
            output.writeInt(element.getLineNumber());
        }
        catch (IOException exception) {
            throw new JSerializerException(3014, (Throwable)exception);
        }
    }

    @Override
    public Object instantiate(DataInputStream input, JSerializer factory) throws JSerializerException {
        try {
            String classLoaderName = Utils.deserialize(input);
            String moduleName = Utils.deserialize(input);
            String moduleVersion = Utils.deserialize(input);
            String declaringClass = Utils.deserialize(input);
            String methodName = Utils.deserialize(input);
            String fileName = Utils.deserialize(input);
            int lineNumber = input.readInt();
            return new StackTraceElement(classLoaderName, moduleName, moduleVersion, declaringClass, methodName, fileName, lineNumber);
        }
        catch (IOException exception) {
            throw new JSerializerException(3015, (Throwable)exception);
        }
    }

    @Override
    public void deserialize(Object obj, DataInputStream input, JSerializer serializer) throws JSerializerException {
    }
}

