/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.java.defaults;

import com.streamscape.lib.utils.SQLType;
import com.streamscape.omf.java.AbstractSerialSupport;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.Utils;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;

public class RowSetSerialSupport
extends AbstractSerialSupport {
    @Override
    public void deserialize(Object obj, DataInputStream input, JSerializer serializer) throws JSerializerException {
    }

    @Override
    public Object instantiate(DataInputStream input, JSerializer serializer) throws JSerializerException {
        RowSet result = new RowSet(this.instantiateRowMetaData(input));
        this.instantiateRows(result, input, serializer);
        return result;
    }

    @Override
    public void serialize(Object obj, DataOutputStream output, JSerializer serializer) throws JSerializerException {
        try {
            RowSet rowSet = (RowSet)obj;
            this.serializeRowMetaData(rowSet, output);
            this.serializeRows(rowSet, output, serializer);
        }
        catch (MetaDataException | RowException | IOException | SQLException exception) {
            throw new JSerializerException(3014, (Throwable)exception);
        }
    }

    protected void serializeRowMetaData(RowSet rowSet, DataOutputStream output) throws JSerializerException, IOException, MetaDataException {
        RowMetaData meta = rowSet.getMeta();
        output.writeInt(meta.getCapacity());
        output.writeBoolean(meta.isRowIdEnabled());
        output.writeInt(meta.getColumnCount());
        Iterator<ColumnDescriptor> iter = meta.iterator();
        while (iter.hasNext()) {
            ColumnDescriptor descriptor = iter.next();
            Utils.serialize(descriptor.getName(), output);
            Utils.serialize(descriptor.getType().name(), output);
            output.writeBoolean(descriptor.isNullable());
        }
    }

    protected RowMetaData instantiateRowMetaData(DataInputStream input) throws JSerializerException {
        try {
            int capacity = input.readInt();
            boolean rowIdEnabled = input.readBoolean();
            int columnCount = input.readInt();
            RowMetaData meta = new RowMetaData(capacity);
            meta.enableRowId(rowIdEnabled);
            for (int i = 0; i < columnCount; ++i) {
                String name = Utils.deserialize(input);
                SQLType type = SQLType.valueOf(Utils.deserialize(input));
                boolean nullable = input.readBoolean();
                meta.addColumn(name, type, nullable);
            }
            return meta;
        }
        catch (MetaDataException | IOException exception) {
            throw new JSerializerException(3015, (Throwable)exception);
        }
    }

    protected void serializeRows(RowSet rowSet, DataOutputStream output, JSerializer serializer) throws JSerializerException, SQLException, IOException, RowException {
        output.writeInt(rowSet.getRowCount());
        for (int i = 0; i < rowSet.getRowCount(); ++i) {
            Row row = rowSet.getRowAt(i + 1);
            for (int j = 1; j <= rowSet.getMeta().getColumnCount(); ++j) {
                this.serialize(serializer, row.getColumn(j), output);
            }
        }
    }

    protected void instantiateRows(RowSet rowSet, DataInputStream input, JSerializer serializer) throws JSerializerException {
        try {
            int columnCount = rowSet.getMeta().getColumnCount();
            int rowCount = input.readInt();
            for (int i = 0; i < rowCount; ++i) {
                Object[] rowData = new Object[columnCount];
                for (int j = 0; j < columnCount; ++j) {
                    rowData[j] = this.deserialize(serializer, input);
                }
                Row row = rowSet.newRow();
                row.setRawData(rowData);
                rowSet.addToRowSet(row);
            }
        }
        catch (RowException | IOException | SQLException exception) {
            throw new JSerializerException(3015, (Throwable)exception);
        }
    }
}

