/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.java.defaults;

import com.streamscape.lib.utils.SQLType;
import com.streamscape.omf.java.AbstractSerialSupport;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.Utils;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.DataRow;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.RowArray;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowMetaData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;

public class RowArraySerialSupport
extends AbstractSerialSupport {
    @Override
    public void deserialize(Object obj, DataInputStream input, JSerializer serializer) throws JSerializerException {
    }

    @Override
    public Object instantiate(DataInputStream input, JSerializer serializer) throws JSerializerException {
        try {
            int capacity = input.readInt();
            boolean rowIdEnabled = input.readBoolean();
            int columnCount = input.readInt();
            int[] keyIndices = (int[])this.deserialize(serializer, input);
            RowMetaData meta = new RowMetaData(capacity);
            meta.enableRowId(rowIdEnabled);
            meta.setKeyColumnsIndices(keyIndices);
            for (int i = 0; i < columnCount; ++i) {
                String name = Utils.deserialize(input);
                SQLType type = SQLType.valueOf(Utils.deserialize(input));
                boolean nullable = input.readBoolean();
                meta.addColumn(name, type, nullable);
            }
            RowArray result = new RowArray(meta);
            int rowCount = input.readInt();
            for (int i = 0; i < rowCount; ++i) {
                Object[] rawData = new Object[columnCount];
                for (int j = 0; j < columnCount; ++j) {
                    rawData[j] = this.deserialize(serializer, input);
                }
                DataRow row = result.newRow();
                row.setRawData(rawData);
                result.addRow(row);
            }
            return result;
        }
        catch (RowException exception) {
            throw new JSerializerException(3015, (Throwable)exception);
        }
        catch (MetaDataException exception) {
            throw new JSerializerException(3015, (Throwable)exception);
        }
        catch (IOException exception) {
            throw new JSerializerException(3015, (Throwable)exception);
        }
    }

    @Override
    public void serialize(Object obj, DataOutputStream output, JSerializer serializer) throws JSerializerException {
        try {
            RowArray rowArray = (RowArray)obj;
            RowMetaData meta = rowArray.getMetaData();
            output.writeInt(meta.getCapacity());
            output.writeBoolean(meta.isRowIdEnabled());
            int columnCount = meta.getColumnCount();
            output.writeInt(columnCount);
            this.serialize(serializer, meta.getKeyColumnsIndices(), output);
            Iterator<ColumnDescriptor> iter = meta.iterator();
            while (iter.hasNext()) {
                ColumnDescriptor descriptor = iter.next();
                Utils.serialize(descriptor.getName(), output);
                Utils.serialize(descriptor.getType().name(), output);
                output.writeBoolean(descriptor.isNullable());
            }
            output.writeInt(rowArray.size());
            Iterator<DataRow> rowIter = rowArray.iteratorByEntry();
            while (rowIter.hasNext()) {
                DataRow row = rowIter.next();
                for (int i = 1; i <= columnCount; ++i) {
                    this.serialize(serializer, row.getColumn(i), output);
                }
            }
        }
        catch (RowException exception) {
            throw new JSerializerException(3014, (Throwable)exception);
        }
        catch (MetaDataException exception) {
            throw new JSerializerException(3014, (Throwable)exception);
        }
        catch (IOException exception) {
            throw new JSerializerException(3014, (Throwable)exception);
        }
    }
}

