/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.java.defaults;

import com.streamscape.omf.java.AbstractSerialSupport;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InetAddressSerialSupport
extends AbstractSerialSupport {
    @Override
    public void serialize(Object obj, DataOutputStream output, JSerializer serializer) throws JSerializerException {
        InetAddress address = (InetAddress)obj;
        Utils.serialize(address.getHostName(), output);
        this.serialize(serializer, address.getAddress(), output);
    }

    @Override
    public Object instantiate(DataInputStream input, JSerializer serializer) throws JSerializerException {
        String hostName = Utils.deserialize(input);
        byte[] address = (byte[])this.deserialize(serializer, input);
        try {
            return InetAddress.getByAddress(hostName, address);
        }
        catch (UnknownHostException exception) {
            throw new JSerializerException(3015, "Unknown host '" + hostName + "'.");
        }
    }

    @Override
    public void deserialize(Object obj, DataInputStream input, JSerializer serializer) throws JSerializerException {
    }
}

