/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.java.defaults;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.omf.java.AbstractSerialSupport;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ClassSerialSupport
extends AbstractSerialSupport {
    private static final Map<String, Class> PRIMITIVES = new HashMap<String, Class>();

    @Override
    public void serialize(Object obj, DataOutputStream output, JSerializer serializer) throws JSerializerException {
        try {
            output.writeUTF(((Class)obj).getName());
        }
        catch (IOException exception) {
            throw new JSerializerException(3014, (Throwable)exception);
        }
    }

    @Override
    public Object instantiate(DataInputStream input, JSerializer serializer) throws JSerializerException {
        String className;
        try {
            className = input.readUTF();
        }
        catch (IOException exception) {
            throw new JSerializerException(3015, (Throwable)exception);
        }
        Class result = PRIMITIVES.get(className);
        if (result != null) {
            return result;
        }
        try {
            return ClassUtils.loadClass(className, serializer.getClassLoader());
        }
        catch (ClassNotFoundException exception) {
            throw new JSerializerException(3015, "Class '" + className + "' not found.");
        }
    }

    @Override
    public void deserialize(Object obj, DataInputStream input, JSerializer serializer) throws JSerializerException {
    }

    static {
        PRIMITIVES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        PRIMITIVES.put(Byte.TYPE.getName(), Byte.TYPE);
        PRIMITIVES.put(Short.TYPE.getName(), Short.TYPE);
        PRIMITIVES.put(Integer.TYPE.getName(), Integer.TYPE);
        PRIMITIVES.put(Long.TYPE.getName(), Long.TYPE);
        PRIMITIVES.put(Float.TYPE.getName(), Float.TYPE);
        PRIMITIVES.put(Double.TYPE.getName(), Double.TYPE);
        PRIMITIVES.put(Character.TYPE.getName(), Double.TYPE);
    }
}

