/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.java;

import com.streamscape.lib.utils.Pair;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.repository.types.SemanticType;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;

public class Utils
extends com.streamscape.lib.utils.Utils {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public static void serialize(String str, DataOutputStream output) throws JSerializerException {
        try {
            if (str == null) {
                output.writeInt(-1);
                return;
            }
            byte[] bytes = str.getBytes(CHARSET);
            output.writeInt(bytes.length);
            output.write(bytes);
        }
        catch (IOException exception) {
            throw new JSerializerException(3014, (Throwable)exception);
        }
    }

    public static String deserialize(DataInputStream input) throws JSerializerException {
        try {
            int length = input.readInt();
            if (length < 0) {
                return null;
            }
            byte[] byteBuffer = new byte[length];
            input.readFully(byteBuffer, 0, length);
            return new String(byteBuffer, CHARSET);
        }
        catch (IOException exception) {
            throw new JSerializerException(3015, (Throwable)exception);
        }
    }

    public static List<Pair<SemanticType, Long>> analyze(byte[] buffer) throws JSerializerException {
        return Utils.analyze(new DataInputStream(new ByteArrayInputStream(buffer)));
    }

    public static synchronized List<Pair<SemanticType, Long>> analyze(DataInputStream stream) throws JSerializerException {
        JSerializer serializer = JSerializerFactory.getInstance().lookupSerializer("sys$analyze");
        if (serializer == null) {
            serializer = JSerializerFactory.getInstance().createSerializer("sys$analyze");
            serializer.forAnalyze = true;
            serializer.analyzeVisitors = new HashMap<Long, JSerializer.AnalyzeVisitor>();
        }
        return serializer.analyze(stream);
    }

    public static boolean isObsolete(byte[] buffer) throws FactoryManagerException, JSerializerException {
        return Utils.isObsolete(new DataInputStream(new ByteArrayInputStream(buffer)));
    }

    public static boolean isObsolete(DataInputStream stream) throws JSerializerException {
        for (Pair<SemanticType, Long> entry : Utils.analyze(stream)) {
            if (JSerializer.isActualClass((SemanticType)entry.first, (Long)entry.second)) continue;
            return true;
        }
        return false;
    }
}

