/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.java;

import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.CloneableDataObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SerialSchema
extends CloneableDataObject {
    public static final String TABLE_PATH_IN_CACHE = "objects/sys/serializer/SerialSchemas.sdo".replace('/', File.separatorChar);
    List<Field> fields = new ArrayList<Field>();

    public Field addField(String name, String type, boolean isPublic, boolean isInner) {
        Field field = new Field(name, type, isPublic, isInner);
        this.fields.add(field);
        return field;
    }

    public List<Field> getFields() {
        return new ArrayList<Field>(this.fields);
    }

    public boolean equals(Object object) {
        return this == null || object instanceof SerialSchema && Utils.equals(this.fields, ((SerialSchema)object).fields);
    }

    public String toString() {
        return this.fields.stream().map(field -> field.name + ", " + field.type + ", " + field.isPublic + ", " + field.isInner + "\n").collect(Collectors.joining());
    }

    @Override
    public SerialSchema clone() {
        SerialSchema result = (SerialSchema)super.clone();
        result.fields = new ArrayList<Field>();
        for (Field field : this.fields) {
            result.fields.add((Field)field.clone());
        }
        return result;
    }

    public static class Field
    extends CloneableDataObject {
        String name;
        String type;
        boolean isPublic;
        boolean isInner;
        transient boolean isRemoved;

        Field(String name, String type, boolean isPublic, boolean isInner) {
            this.name = name;
            this.type = type;
            this.isPublic = isPublic;
            this.isInner = isInner;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isPublic() {
            return this.isPublic;
        }

        public boolean isInner() {
            return this.isInner;
        }

        public boolean isRemoved() {
            return this.isRemoved;
        }

        public Field removed() {
            this.isRemoved = true;
            return this;
        }

        public boolean equals(Object object) {
            return this == null || object instanceof Field && this.name.equals(((Field)object).name) && this.type.equals(((Field)object).type);
        }
    }
}

