/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.java;

import com.streamscape.Trace;
import com.streamscape.cli.ds.collection.Aspects;
import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.cli.ds.collection.FacetsKeys;
import com.streamscape.cli.ds.collection.FacetsValues;
import com.streamscape.ds.replication.ReplicationException;
import com.streamscape.lib.loader.FabricClassLoader;
import com.streamscape.lib.utils.ArraySet;
import com.streamscape.lib.utils.CIString;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.OrderedMap;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.java.Generator;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.SerialSchema;
import com.streamscape.omf.java.SerialSupport;
import com.streamscape.omf.java.defaults.ArrayIndexOutOfBoundsExceptionSerialSupport;
import com.streamscape.omf.java.defaults.ArrayListSerialSupport;
import com.streamscape.omf.java.defaults.ArraySetSerialSupport;
import com.streamscape.omf.java.defaults.AspectsSerialSupport;
import com.streamscape.omf.java.defaults.BigDecimalSerialSupport;
import com.streamscape.omf.java.defaults.BigIntegerSerialSupport;
import com.streamscape.omf.java.defaults.BindExceptionSerialSupport;
import com.streamscape.omf.java.defaults.BooleanSerialSupport;
import com.streamscape.omf.java.defaults.ByteArraySerialSupport;
import com.streamscape.omf.java.defaults.ByteSerialSupport;
import com.streamscape.omf.java.defaults.CIStringSerialSupport;
import com.streamscape.omf.java.defaults.CannotCompileExceptionSerialSupport;
import com.streamscape.omf.java.defaults.CharacterSerialSupport;
import com.streamscape.omf.java.defaults.ClassCastExceptionSerialSupport;
import com.streamscape.omf.java.defaults.ClassNotFoundExceptionSerialSupport;
import com.streamscape.omf.java.defaults.ClassSerialSupport;
import com.streamscape.omf.java.defaults.CollectionTupleSetSerialSupport;
import com.streamscape.omf.java.defaults.ConcurrentHashMapSerialSupport;
import com.streamscape.omf.java.defaults.ConnectExceptionSerialSupport;
import com.streamscape.omf.java.defaults.ConversionExceptionSerialSupport;
import com.streamscape.omf.java.defaults.DateSerialSupport;
import com.streamscape.omf.java.defaults.DictionarySerialSupport;
import com.streamscape.omf.java.defaults.DoubleSerialSupport;
import com.streamscape.omf.java.defaults.EOFExceptionSerialSupport;
import com.streamscape.omf.java.defaults.EnumSerialSupport;
import com.streamscape.omf.java.defaults.ErrorSerialSupport;
import com.streamscape.omf.java.defaults.ExceptionSerialSupport;
import com.streamscape.omf.java.defaults.FacetsKeysSerialSupport;
import com.streamscape.omf.java.defaults.FacetsSerialSupport;
import com.streamscape.omf.java.defaults.FacetsValuesSerialSupport;
import com.streamscape.omf.java.defaults.FileNotFoundExceptionSerialSupport;
import com.streamscape.omf.java.defaults.FloatSerialSupport;
import com.streamscape.omf.java.defaults.HashMapSerialSupport;
import com.streamscape.omf.java.defaults.HashSetSerialSupport;
import com.streamscape.omf.java.defaults.HashtableSerialSupport;
import com.streamscape.omf.java.defaults.IOExceptionSerialSupport;
import com.streamscape.omf.java.defaults.IllegalAccessErrorSerialSupport;
import com.streamscape.omf.java.defaults.IllegalAccessExceptionSerialSupport;
import com.streamscape.omf.java.defaults.IllegalArgumentExceptionSerialSupport;
import com.streamscape.omf.java.defaults.IllegalStateExceptionSerialSupport;
import com.streamscape.omf.java.defaults.IncompatibleClassChangeErrorSerialSupport;
import com.streamscape.omf.java.defaults.IndexOutOfBoundsExceptionSerialSupport;
import com.streamscape.omf.java.defaults.InetAddressSerialSupport;
import com.streamscape.omf.java.defaults.InputStreamProxySerialSupport;
import com.streamscape.omf.java.defaults.InstantiationExceptionSerialSupport;
import com.streamscape.omf.java.defaults.IntegerSerialSupport;
import com.streamscape.omf.java.defaults.InterruptedExceptionSerialSupport;
import com.streamscape.omf.java.defaults.LinkageErrorSerialSupport;
import com.streamscape.omf.java.defaults.LinkedHashMapSerialSupport;
import com.streamscape.omf.java.defaults.LinkedHashSetSerialSupport;
import com.streamscape.omf.java.defaults.LinkedListSerialSupport;
import com.streamscape.omf.java.defaults.LongSerialSupport;
import com.streamscape.omf.java.defaults.NamingExceptionSerialSupport;
import com.streamscape.omf.java.defaults.NegativeArraySizeExceptionSerialSupport;
import com.streamscape.omf.java.defaults.NoClassDefFoundErrorSerialSupport;
import com.streamscape.omf.java.defaults.NoSuchElementExceptionSerialSupport;
import com.streamscape.omf.java.defaults.NoSuchMethodExceptionSerialSupport;
import com.streamscape.omf.java.defaults.NotFoundExceptionSerialSupport;
import com.streamscape.omf.java.defaults.NullPointerExceptionSerialSupport;
import com.streamscape.omf.java.defaults.NumberFormatExceptionSerialSupport;
import com.streamscape.omf.java.defaults.ObjectSerialSupport;
import com.streamscape.omf.java.defaults.OrderedMapSerialSupport;
import com.streamscape.omf.java.defaults.OutOfMemoryErrorSerialSupport;
import com.streamscape.omf.java.defaults.OutputStreamProxySerialSupport;
import com.streamscape.omf.java.defaults.PropertiesSerialSupport;
import com.streamscape.omf.java.defaults.ReplicationExceptionSerialSupport;
import com.streamscape.omf.java.defaults.RowArraySerialSupport;
import com.streamscape.omf.java.defaults.RowSetProxySerialSupport;
import com.streamscape.omf.java.defaults.RowSetSerialSupport;
import com.streamscape.omf.java.defaults.RuntimeExceptionSerialSupport;
import com.streamscape.omf.java.defaults.SQLDataExceptionSerialSupport;
import com.streamscape.omf.java.defaults.SQLExceptionSerialSupport;
import com.streamscape.omf.java.defaults.SQLFeatureNotSupportedExceptionSerialSupport;
import com.streamscape.omf.java.defaults.SQLIntegrityConstraintViolationExceptionSerialSupport;
import com.streamscape.omf.java.defaults.SQLInvalidAuthorizationSpecExceptionSerialSupport;
import com.streamscape.omf.java.defaults.SQLNonTransientConnectionExceptionSerialSupport;
import com.streamscape.omf.java.defaults.SQLNonTransientExceptionSerialSupport;
import com.streamscape.omf.java.defaults.SQLSyntaxErrorExceptionSerialSupport;
import com.streamscape.omf.java.defaults.SQLTransactionRollbackExceptionSerialSupport;
import com.streamscape.omf.java.defaults.SQLTransientExceptionSerialSupport;
import com.streamscape.omf.java.defaults.SecurityExceptionSerialSupport;
import com.streamscape.omf.java.defaults.ShortSerialSupport;
import com.streamscape.omf.java.defaults.SocketExceptionSerialSupport;
import com.streamscape.omf.java.defaults.SqlDateSerialSupport;
import com.streamscape.omf.java.defaults.SqlTimeSerialSupport;
import com.streamscape.omf.java.defaults.SqlTimestampSerialSupport;
import com.streamscape.omf.java.defaults.StackOverflowErrorSerialSupport;
import com.streamscape.omf.java.defaults.StackTraceElementSerialSupport;
import com.streamscape.omf.java.defaults.StringIndexOutOfBoundsExceptionSerialSupport;
import com.streamscape.omf.java.defaults.StringSerialSupport;
import com.streamscape.omf.java.defaults.ThrowableSerialSupport;
import com.streamscape.omf.java.defaults.TimeoutExceptionSerialSupport;
import com.streamscape.omf.java.defaults.TokenizedJsonSerialSupport;
import com.streamscape.omf.java.defaults.TreeMapSerialSupport;
import com.streamscape.omf.java.defaults.TreeSetSerialSupport;
import com.streamscape.omf.java.defaults.TripleSetSerialSupport;
import com.streamscape.omf.java.defaults.TupleSetSerialSupport;
import com.streamscape.omf.java.defaults.UUIDSerialSupport;
import com.streamscape.omf.java.defaults.VectorSerialSupport;
import com.streamscape.omf.java.defaults.ZipExceptionSerialSupport;
import com.streamscape.omf.json.utils.TokenizedJson;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.serializer.SerializerFactory;
import com.streamscape.omf.serializer.SerializerUtils;
import com.streamscape.omf.serializer.SizeUnitHelper;
import com.streamscape.omf.serializer.TimeUnitHelper;
import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.rowset.RowArray;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetProxy;
import com.streamscape.sdo.tuple.CollectionTupleSet;
import com.streamscape.sdo.tuple.TripleSet;
import com.streamscape.sdo.tuple.TupleSet;
import com.streamscape.sef.dispatcher.AbstractJSerializerFactory;
import com.streamscape.sef.dispatcher.AbstractOMFManager;
import com.streamscape.sef.dropbox.InputStreamProxy;
import com.streamscape.sef.dropbox.OutputStreamProxy;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.BindException;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.SocketException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipException;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import javax.naming.NamingException;

public class JSerializerFactory
extends AbstractJSerializerFactory
implements SerializerFactory {
    private static final String FACTORY_NAME = "JSerializer";
    private static JSerializerFactory instance = null;
    private Map<String, JSerializer> serializers = new ConcurrentHashMap<String, JSerializer>();
    private Generator generator = new Generator(this);
    private Map<Class, SerialSupport> storageByClass = new ConcurrentHashMap<Class, SerialSupport>();
    private Map<String, SerialSupport> storageByName = new ConcurrentHashMap<String, SerialSupport>();
    private Map<String, Map<Long, SerialSupport>> storageOldByName = new ConcurrentHashMap<String, Map<Long, SerialSupport>>();
    private final Object storageMutex = new Object();
    private Map<ClassLoader, Set<ClassLoader>> oldLoaders = new ConcurrentHashMap<ClassLoader, Set<ClassLoader>>();
    private Map<String, Map<FabricClassLoader, Long>> oldVersionsByLoader = new ConcurrentHashMap<String, Map<FabricClassLoader, Long>>();
    private Map<String, Map<Long, FabricClassLoader>> oldLoadersByVersion = new ConcurrentHashMap<String, Map<Long, FabricClassLoader>>();
    ByteArraySerialSupport byteArraySupport = new ByteArraySerialSupport();

    public static JSerializerFactory getInstance() {
        JSerializerFactory.init(null, null);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void init(AbstractOMFManager omfManager, ObjectMediationAliasManager manager) {
        if (instance != null) return;
        Class<JSerializerFactory> clazz = JSerializerFactory.class;
        synchronized (JSerializerFactory.class) {
            if (instance != null) return;
            instance = new JSerializerFactory(omfManager, manager);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private JSerializerFactory(AbstractOMFManager omfManager, ObjectMediationAliasManager manager) {
        super(omfManager, manager);
        try {
            SerializerUtils.addSysAliases(this.aliasManager);
            SerializerUtils.addSysTypeAliases(this.aliasManager);
            JSerializer jserializer = new JSerializer(this, this.aliasManager);
            jserializer.setName("sys$serializer");
            this.serializers.put("sys$serializer", jserializer);
            this.addDefaultSerialSupports();
        }
        catch (Throwable exception) {
            throw new RuntimeException("Initialization of JSerializerFactory failed.", exception);
        }
        Trace.logInfo(JSerializerFactory.class, "JSerializer Factory initialized.");
    }

    private void addDefaultSerialSupports() throws FactoryManagerException {
        this.addSystemSerialSupport(Object.class, new ObjectSerialSupport());
        this.addSystemSerialSupport(Date.class, new DateSerialSupport());
        this.addSystemSerialSupport(String.class, new StringSerialSupport());
        this.addSystemSerialSupport(Byte.class, new ByteSerialSupport());
        this.addSystemSerialSupport(Short.class, new ShortSerialSupport());
        this.addSystemSerialSupport(Integer.class, new IntegerSerialSupport());
        this.addSystemSerialSupport(Long.class, new LongSerialSupport());
        this.addSystemSerialSupport(Boolean.class, new BooleanSerialSupport());
        this.addSystemSerialSupport(Character.class, new CharacterSerialSupport());
        this.addSystemSerialSupport(Float.class, new FloatSerialSupport());
        this.addSystemSerialSupport(Double.class, new DoubleSerialSupport());
        this.addSystemSerialSupport(ArrayList.class, new ArrayListSerialSupport());
        this.addSystemSerialSupport(LinkedList.class, new LinkedListSerialSupport());
        this.addSystemSerialSupport(LinkedHashSet.class, new LinkedHashSetSerialSupport());
        this.addSystemSerialSupport(HashMap.class, new HashMapSerialSupport());
        this.addSystemSerialSupport(TreeMap.class, new TreeMapSerialSupport());
        this.addSystemSerialSupport(HashSet.class, new HashSetSerialSupport());
        this.addSystemSerialSupport(TreeSet.class, new TreeSetSerialSupport());
        this.addSystemSerialSupport(BigInteger.class, new BigIntegerSerialSupport());
        this.addSystemSerialSupport(BigDecimal.class, new BigDecimalSerialSupport());
        this.addSystemSerialSupport(Hashtable.class, new HashtableSerialSupport());
        this.addSystemSerialSupport(Enum.class, new EnumSerialSupport());
        this.addSystemSerialSupport(Vector.class, new VectorSerialSupport());
        this.addSystemSerialSupport(ConcurrentHashMap.class, new ConcurrentHashMapSerialSupport());
        this.addSystemSerialSupport(Inet4Address.class, new InetAddressSerialSupport());
        this.addSystemSerialSupport(Inet6Address.class, new InetAddressSerialSupport());
        this.addSystemSerialSupport(StackTraceElement.class, new StackTraceElementSerialSupport());
        this.addSystemSerialSupport(Timestamp.class, new SqlTimestampSerialSupport());
        this.addSystemSerialSupport(Time.class, new SqlTimeSerialSupport());
        this.addSystemSerialSupport(java.sql.Date.class, new SqlDateSerialSupport());
        this.addSystemSerialSupport(CIString.class, new CIStringSerialSupport());
        this.addSystemSerialSupport(Class.class, new ClassSerialSupport());
        this.addSystemSerialSupport(Properties.class, new PropertiesSerialSupport());
        this.addSystemSerialSupport(ArraySet.class, new ArraySetSerialSupport());
        this.addSystemSerialSupport(OrderedMap.class, new OrderedMapSerialSupport());
        this.addSystemSerialSupport(LinkedHashMap.class, new LinkedHashMapSerialSupport());
        this.addSystemSerialSupport(RowSet.class, new RowSetSerialSupport());
        this.addSystemSerialSupport(RowSetProxy.class, new RowSetProxySerialSupport());
        this.addSystemSerialSupport(RowArray.class, new RowArraySerialSupport());
        this.addSystemSerialSupport(UUID.class, new UUIDSerialSupport());
        this.addSystemSerialSupport(Dictionary.class, new DictionarySerialSupport());
        this.addSystemSerialSupport(TupleSet.class, new TupleSetSerialSupport());
        this.addSystemSerialSupport(TripleSet.class, new TripleSetSerialSupport());
        this.addSystemSerialSupport(CollectionTupleSet.class, new CollectionTupleSetSerialSupport());
        this.addSystemSerialSupport(Facets.class, new FacetsSerialSupport());
        this.addSystemSerialSupport(FacetsKeys.class, new FacetsKeysSerialSupport());
        this.addSystemSerialSupport(FacetsValues.class, new FacetsValuesSerialSupport());
        this.addSystemSerialSupport(Aspects.class, new AspectsSerialSupport());
        this.addSystemSerialSupport(Throwable.class, new ThrowableSerialSupport());
        this.addSystemSerialSupport(Exception.class, new ExceptionSerialSupport());
        this.addSystemSerialSupport(RuntimeException.class, new RuntimeExceptionSerialSupport());
        this.addSystemSerialSupport(NullPointerException.class, new NullPointerExceptionSerialSupport());
        this.addSystemSerialSupport(IllegalAccessException.class, new IllegalAccessExceptionSerialSupport());
        this.addSystemSerialSupport(IllegalStateException.class, new IllegalStateExceptionSerialSupport());
        this.addSystemSerialSupport(InstantiationException.class, new InstantiationExceptionSerialSupport());
        this.addSystemSerialSupport(IndexOutOfBoundsException.class, new IndexOutOfBoundsExceptionSerialSupport());
        this.addSystemSerialSupport(SecurityException.class, new SecurityExceptionSerialSupport());
        this.addSystemSerialSupport(IOException.class, new IOExceptionSerialSupport());
        this.addSystemSerialSupport(CannotCompileException.class, new CannotCompileExceptionSerialSupport());
        this.addSystemSerialSupport(NotFoundException.class, new NotFoundExceptionSerialSupport());
        this.addSystemSerialSupport(ConversionException.class, new ConversionExceptionSerialSupport());
        this.addSystemSerialSupport(NoSuchMethodException.class, new NoSuchMethodExceptionSerialSupport());
        this.addSystemSerialSupport(OutOfMemoryError.class, new OutOfMemoryErrorSerialSupport());
        this.addSystemSerialSupport(IllegalArgumentException.class, new IllegalArgumentExceptionSerialSupport());
        this.addSystemSerialSupport(NamingException.class, new NamingExceptionSerialSupport());
        this.addSystemSerialSupport(ClassCastException.class, new ClassCastExceptionSerialSupport());
        this.addSystemSerialSupport(EOFException.class, new EOFExceptionSerialSupport());
        this.addSystemSerialSupport(FileNotFoundException.class, new FileNotFoundExceptionSerialSupport());
        this.addSystemSerialSupport(NumberFormatException.class, new NumberFormatExceptionSerialSupport());
        this.addSystemSerialSupport(SQLException.class, new SQLExceptionSerialSupport());
        this.addSystemSerialSupport(NoClassDefFoundError.class, new NoClassDefFoundErrorSerialSupport());
        this.addSystemSerialSupport(ClassNotFoundException.class, new ClassNotFoundExceptionSerialSupport());
        this.addSystemSerialSupport(NoSuchElementException.class, new NoSuchElementExceptionSerialSupport());
        this.addSystemSerialSupport(TimeoutException.class, new TimeoutExceptionSerialSupport());
        this.addSystemSerialSupport(InterruptedException.class, new InterruptedExceptionSerialSupport());
        this.addSystemSerialSupport(SocketException.class, new SocketExceptionSerialSupport());
        this.addSystemSerialSupport(BindException.class, new BindExceptionSerialSupport());
        this.addSystemSerialSupport(StringIndexOutOfBoundsException.class, new StringIndexOutOfBoundsExceptionSerialSupport());
        this.addSystemSerialSupport(ArrayIndexOutOfBoundsException.class, new ArrayIndexOutOfBoundsExceptionSerialSupport());
        this.addSystemSerialSupport(Error.class, new ErrorSerialSupport());
        this.addSystemSerialSupport(StackOverflowError.class, new StackOverflowErrorSerialSupport());
        this.addSystemSerialSupport(LinkageError.class, new LinkageErrorSerialSupport());
        this.addSystemSerialSupport(ConnectException.class, new ConnectExceptionSerialSupport());
        this.addSystemSerialSupport(NegativeArraySizeException.class, new NegativeArraySizeExceptionSerialSupport());
        this.addSystemSerialSupport(ReplicationException.class, new ReplicationExceptionSerialSupport());
        this.addSystemSerialSupport(ZipException.class, new ZipExceptionSerialSupport());
        this.addSystemSerialSupport(SQLTransientException.class, new SQLTransientExceptionSerialSupport());
        this.addSystemSerialSupport(SQLNonTransientException.class, new SQLNonTransientExceptionSerialSupport());
        this.addSystemSerialSupport(SQLDataException.class, new SQLDataExceptionSerialSupport());
        this.addSystemSerialSupport(SQLFeatureNotSupportedException.class, new SQLFeatureNotSupportedExceptionSerialSupport());
        this.addSystemSerialSupport(SQLIntegrityConstraintViolationException.class, new SQLIntegrityConstraintViolationExceptionSerialSupport());
        this.addSystemSerialSupport(SQLInvalidAuthorizationSpecException.class, new SQLInvalidAuthorizationSpecExceptionSerialSupport());
        this.addSystemSerialSupport(SQLNonTransientConnectionException.class, new SQLNonTransientConnectionExceptionSerialSupport());
        this.addSystemSerialSupport(SQLSyntaxErrorException.class, new SQLSyntaxErrorExceptionSerialSupport());
        this.addSystemSerialSupport(SQLTransactionRollbackException.class, new SQLTransactionRollbackExceptionSerialSupport());
        this.addSystemSerialSupport(IncompatibleClassChangeError.class, new IncompatibleClassChangeErrorSerialSupport());
        this.addSystemSerialSupport(IllegalAccessError.class, new IllegalAccessErrorSerialSupport());
        this.addSystemSerialSupport(OutputStreamProxy.class, new OutputStreamProxySerialSupport());
        this.addSystemSerialSupport(InputStreamProxy.class, new InputStreamProxySerialSupport());
        this.addSystemSerialSupport(TokenizedJson.class, new TokenizedJsonSerialSupport());
        TimeUnitHelper.addSerialSupport(this);
        SizeUnitHelper.addSerialSupport(this);
    }

    @Override
    protected void addSystemSerialSupport(Class objectClass, SerialSupport serialSupport) throws FactoryManagerException {
        if (objectClass != null && serialSupport != null) {
            SemanticType type = this.lookupSemanticClassFull(objectClass);
            if (type != null) {
                JSerializerFactory.setSerialSupport(type, serialSupport);
            } else {
                throw new FactoryManagerException(3025, "Semantic type for class '" + objectClass.getName() + "' not found.");
            }
        }
    }

    @Override
    public JSerializer createSerializer(String name) {
        JSerializer jserializer = new JSerializer(this, this.aliasManager);
        jserializer.setName(name);
        this.serializers.put(name, jserializer);
        return jserializer;
    }

    @Override
    public JSerializer createSerializer(String name, ObjectMediationAliasManager aliasManager) {
        JSerializer jserializer = new JSerializer(this, aliasManager);
        jserializer.setName(name);
        this.serializers.put(name, jserializer);
        return jserializer;
    }

    @Override
    public JSerializer getDefaultSerializer() {
        return this.lookupSerializer("sys$serializer");
    }

    @Override
    public String getName() {
        return FACTORY_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSerialSupport(Class objectClass, SerialSupport serialSupport) throws FactoryManagerException {
        if (objectClass != null && serialSupport != null) {
            Object object = this.storageMutex;
            synchronized (object) {
                this.putToStorage(new ClassData(objectClass, -1L), serialSupport);
            }
        }
    }

    @Override
    public void discardSerializer(String name) throws FactoryManagerException {
        JSerializer serializer = this.serializers.remove(name);
        if (serializer == null) {
            throw new FactoryManagerException(3040, "Java serializer '" + name + "' does not exist.");
        }
        serializer.destroy();
    }

    @Override
    public void alias(SemanticType type) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.alias(type);
        }
    }

    @Override
    public void alias(String alias, Class type) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.alias(alias, type);
        }
    }

    @Override
    public void unalias(SemanticType type) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.unalias(type);
        }
    }

    @Override
    public void unalias(String alias) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.unalias(alias);
        }
    }

    @Override
    public List<String> listAliases() {
        return this.aliasManager != null ? this.aliasManager.listAliases() : new ArrayList();
    }

    @Override
    public String lookup(Class clazz) {
        return this.aliasManager != null ? this.aliasManager.lookup(clazz) : null;
    }

    @Override
    public String lookup(String typeName) {
        return this.aliasManager != null ? this.aliasManager.lookup(typeName) : null;
    }

    @Override
    public JSerializer lookupSerializer(String name) {
        return this.serializers != null ? this.serializers.get(name) : null;
    }

    @Override
    public SemanticType lookupSemanticType(String aliasName) {
        return this.aliasManager != null ? this.aliasManager.lookupSemanticType(aliasName) : null;
    }

    public SemanticType lookupSemanticType(Class objectClass) {
        return this.aliasManager != null ? this.aliasManager.lookupSemanticClass(objectClass) : null;
    }

    @Override
    public String resolveClass(String className) {
        return this.aliasManager != null ? this.aliasManager.resolveClass(className) : null;
    }

    @Override
    protected SemanticType lookupSemanticClassFull(Class objectClass) {
        return super.lookupSemanticClassFull(objectClass);
    }

    @Override
    public synchronized void destroy() {
        for (String serializer : new ArrayList<String>(this.serializers.keySet())) {
            try {
                this.discardSerializer(serializer);
            }
            catch (FactoryManagerException exception) {
                Trace.logException(this, exception, true);
            }
        }
        this.serializers = null;
        instance = null;
    }

    @Override
    public List<String> listSerializers() {
        return new ArrayList<String>(this.serializers.keySet());
    }

    @Override
    public boolean isAliased(String alias) {
        return this.aliasManager != null && this.aliasManager.isAliased(alias);
    }

    @Override
    public boolean isAliased(Class type) {
        return this.aliasManager != null && this.aliasManager.isAliased(type);
    }

    @Override
    public void aliasImmutableType(SemanticType type) throws FactoryManagerException {
        if (this.aliasManager != null) {
            this.aliasManager.aliasImmutableType(type);
        }
    }

    @Override
    public void aliasImmutableType(Class type) {
        if (this.aliasManager != null) {
            this.aliasManager.aliasImmutableType(type);
        }
    }

    @Override
    public boolean isImmutableTypeAliased(Class type) {
        return this.aliasManager != null && this.aliasManager.isImmutableTypeAliased(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SerialSupport getSerialSupport(Class objectClass, SemanticType type, ClassLoader systemLoader) throws JSerializerException {
        SerialSupport result = JSerializerFactory.getSerialSupport(type);
        if (result == null) {
            Object object = this.storageMutex;
            synchronized (object) {
                result = JSerializerFactory.getSerialSupport(type);
                if (result == null) {
                    result = this.generateSerialSupport(objectClass, -1L, systemLoader, type);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SerialSupport getSerialSupport(Class objectClass, long serialVersion, ClassLoader systemLoader) throws JSerializerException {
        SerialSupport result = this.storageByClass.get(objectClass);
        if (result == null) {
            Object object = this.storageMutex;
            synchronized (object) {
                result = this.storageByClass.get(objectClass);
                if (result == null) {
                    result = this.generateSerialSupport(objectClass, serialVersion, systemLoader);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SerialSupport getSerialSupport(Class objectClass, ClassLoader loader) throws JSerializerException {
        SerialSupport result = this.storageByClass.get(objectClass);
        if (result == null) {
            Object object = this.storageMutex;
            synchronized (object) {
                result = this.storageByClass.get(objectClass);
                if (result == null) {
                    SemanticType type = this.lookupSemanticClassFull(objectClass);
                    result = type != null && type.isSystem() ? this.getSerialSupport(objectClass, type, loader) : this.generateSerialSupport(objectClass, type != null ? type.getSerialVersionUID() : -1L, loader);
                }
            }
        }
        return result;
    }

    private SerialSupport generateSerialSupport(Class objectClass, long serialVersion, ClassLoader classLoader) throws JSerializerException {
        return this.generateSerialSupport(objectClass, serialVersion, classLoader, null);
    }

    private SerialSupport generateSerialSupport(Class objectClass, long serialVersion, ClassLoader classLoader, SemanticType type) throws JSerializerException {
        return this.generate(this.resolveClass(objectClass, serialVersion, classLoader), type);
    }

    private ClassData resolveClass(Class objectClass, long serialVersion, ClassLoader systemLoader) throws JSerializerException {
        FabricClassLoader fabricLoader;
        ClassData result = new ClassData(objectClass, serialVersion);
        result.loader = objectClass.getClassLoader();
        if (result.loader instanceof FabricClassLoader && !(fabricLoader = (FabricClassLoader)result.loader).isLoaded()) {
            result.serialVersion = this.getSerialVersionUID(objectClass.getName(), fabricLoader);
            result.isActual = false;
            this.addOldClassLoader(JSerializerFactory.loadClass(objectClass.getName(), systemLoader, true).getClassLoader(), result.loader);
            fabricLoader.setWorking(true);
        }
        return result;
    }

    private long getSerialVersionUID(String className, FabricClassLoader loader) throws JSerializerException {
        Long result;
        Map<FabricClassLoader, Long> serialVersions = this.oldVersionsByLoader.get(className);
        if (serialVersions != null && (result = serialVersions.get(loader)) != null) {
            return result;
        }
        throw new JSerializerException(3029, "Serial version not found for class '" + className + "'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SerialSupport getSerialSupport(SemanticType type, ClassLoader systemLoader) throws JSerializerException {
        SerialSupport result = JSerializerFactory.getSerialSupport(type);
        if (result == null) {
            Object object = this.storageMutex;
            synchronized (object) {
                result = JSerializerFactory.getSerialSupport(type);
                if (result == null) {
                    result = this.generateSerialSupport(type.getClassName(), systemLoader, type);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SerialSupport getSerialSupport(String className, ClassLoader systemLoader) throws JSerializerException {
        SerialSupport result = this.storageByName.get(className);
        if (result == null) {
            Object object = this.storageMutex;
            synchronized (object) {
                result = this.storageByName.get(className);
                if (result == null) {
                    result = this.generateSerialSupport(className, systemLoader, null);
                }
            }
        }
        return result;
    }

    private SerialSupport generateSerialSupport(String className, ClassLoader systemLoader, SemanticType type) throws JSerializerException {
        return this.generate(JSerializerFactory.resolveActualClass(className, -1L, systemLoader), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SerialSupport getSerialSupport(SemanticType type, boolean isActual, long serialVersion, ClassLoader systemLoader) throws JSerializerException {
        SerialSupport result = this.doGetSerialSupport(type.getClassName(), isActual, serialVersion);
        if (result == null) {
            Object object = this.storageMutex;
            synchronized (object) {
                result = this.doGetSerialSupport(type.getClassName(), isActual, serialVersion);
                if (result == null) {
                    ClassData classData = this.resolveClass(type.getClassName(), isActual, serialVersion, systemLoader);
                    if (classData == null) {
                        Trace.logInfo(this, "WARNING: Class loader or serial schema not found for class '" + type.getClassName() + "' (serial version = " + serialVersion + "). Trying to use latest version of the class for deserialization...");
                        result = this.getSerialSupport(type, true, type.getSerialVersionUID(), systemLoader);
                    } else {
                        result = this.generate(classData, null);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerialSupport doGetSerialSupport(String className, boolean isActual, long serialVersion) {
        if (isActual) {
            return this.storageByName.get(className);
        }
        Object object = this.storageMutex;
        synchronized (object) {
            Map<Long, SerialSupport> contexts = this.storageOldByName.get(className);
            if (contexts != null) {
                return contexts.get(serialVersion);
            }
        }
        return null;
    }

    private SerialSupport generateSerialSupport(String className, boolean isActual, long serialVersion, ClassLoader systemLoader, SemanticType type) throws JSerializerException {
        return this.generate(this.resolveClass(className, isActual, serialVersion, systemLoader), type);
    }

    private ClassData resolveClass(String className, boolean isActualClass, long serialVersion, ClassLoader systemLoader) throws JSerializerException {
        if (isActualClass) {
            return JSerializerFactory.resolveActualClass(className, serialVersion, systemLoader);
        }
        FabricClassLoader oldLoader = this.getOldLoader(className, serialVersion);
        if (oldLoader != null) {
            oldLoader.setWorking(true);
            Class objectClass = JSerializerFactory.loadClass(className, oldLoader, false);
            this.addOldClassLoader(JSerializerFactory.loadClass(className, systemLoader, false).getClassLoader(), oldLoader);
            return new ClassData(objectClass, (ClassLoader)oldLoader, serialVersion, null);
        }
        SerialSchema schema = this.getSerialSchema(className, serialVersion);
        if (schema != null) {
            Class actualClass = JSerializerFactory.loadClass(className, systemLoader, false);
            return new ClassData(actualClass, actualClass.getClassLoader(), serialVersion, schema);
        }
        return null;
    }

    private FabricClassLoader getOldLoader(String className, long serialVersion) {
        Map<Long, FabricClassLoader> loaders = this.oldLoadersByVersion.get(className);
        return loaders != null ? loaders.get(serialVersion) : null;
    }

    private static ClassData resolveActualClass(String className, long serialVersion, ClassLoader systemLoader) throws JSerializerException {
        Class objectClass = JSerializerFactory.loadClass(className, systemLoader, false);
        return new ClassData(objectClass, objectClass.getClassLoader(), true, serialVersion);
    }

    private static Class loadClass(String className, ClassLoader classLoader, boolean isLoaderUnloaded) throws JSerializerException {
        try {
            return ClassUtils.loadClass(className, classLoader);
        }
        catch (ClassNotFoundException exception) {
            throw new JSerializerException(3029, "Class '" + className + "' not found." + (isLoaderUnloaded ? " Its class loader has been unloaded." : ""));
        }
    }

    private void addOldClassLoader(ClassLoader actualLoader, ClassLoader oldLoader) {
        if (!this.oldLoaders.containsKey(actualLoader)) {
            this.oldLoaders.put(actualLoader, new HashSet());
        }
        this.oldLoaders.get(actualLoader).add(oldLoader);
    }

    private SerialSupport generate(ClassData classData, SemanticType type) throws JSerializerException {
        try {
            SerialSupport result = this.generator.generateSerialSupport(classData.objectClass, classData.serialVersion, classData.loader, classData.schema);
            if (type != null) {
                JSerializerFactory.setSerialSupport(type, result);
            } else {
                this.putToStorage(classData, result);
            }
            return result;
        }
        catch (Throwable exception) {
            if (exception instanceof JSerializerException) {
                throw (JSerializerException)exception;
            }
            throw new JSerializerException(3029, "Generating SerialSupport for class '" + classData.objectClass.getName() + "' failed.", exception);
        }
    }

    private void putToStorage(ClassData classData, SerialSupport serialSupport) {
        if (classData.schema == null) {
            this.storageByClass.put(classData.objectClass, serialSupport);
        }
        if (classData.isActual) {
            this.storageByName.put(classData.objectClass.getName(), serialSupport);
        } else {
            String className = classData.objectClass.getName();
            if (!this.storageOldByName.containsKey(className)) {
                this.storageOldByName.put(className, new HashMap());
            }
            this.storageOldByName.get(className).put(classData.serialVersion, serialSupport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeClassLoader(FabricClassLoader actualLoader, List<SemanticType> types) {
        Object object = this.storageMutex;
        synchronized (object) {
            if (types != null) {
                for (SemanticType type : types) {
                    if (!this.oldVersionsByLoader.containsKey(type.getClassName())) {
                        this.oldVersionsByLoader.put(type.getClassName(), new HashMap());
                    }
                    this.oldVersionsByLoader.get(type.getClassName()).put(actualLoader, type.getSerialVersionUID());
                    if (!this.oldLoadersByVersion.containsKey(type.getClassName())) {
                        this.oldLoadersByVersion.put(type.getClassName(), new HashMap());
                    }
                    this.oldLoadersByVersion.get(type.getClassName()).put(type.getSerialVersionUID(), actualLoader);
                    this.generateSerialSchema(type, actualLoader);
                }
            }
            ArrayList<ClassLoader> removedLoaders = new ArrayList<ClassLoader>();
            removedLoaders.add(actualLoader);
            Set<ClassLoader> removedOldLoaders = this.oldLoaders.remove(actualLoader);
            if (removedOldLoaders != null) {
                removedLoaders.addAll(removedOldLoaders);
            }
            for (ClassLoader loader : removedLoaders) {
                this.doRemoveClassLoader(loader);
                if (!(loader instanceof FabricClassLoader)) continue;
                ((FabricClassLoader)loader).setWorking(false);
            }
        }
    }

    private SerialSchema generateSerialSchema(SemanticType type, FabricClassLoader loader) {
        try {
            SerialSchema schema = new SerialSchema();
            for (Field field : Generator.getFields(JSerializerFactory.loadClass(type.getClassName(), loader, false))) {
                if (Generator.isTransient(field)) continue;
                schema.addField(field.getName(), field.getType().getName(), Generator.isPublic(field), Generator.isInner(field));
            }
            this.addSerialSchema(type.getClassName(), type.getSerialVersionUID(), schema);
            return schema;
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Generating Serial Schema for semantic type '" + type.getTypeName() + "' failed.");
            return null;
        }
    }

    private void doRemoveClassLoader(ClassLoader loader) {
        if (this.generator.removeClassLoader(loader) != null) {
            try {
                List<Class> classes = this.getClasses(loader);
                classes.stream().filter(SerialSupport.class::isAssignableFrom).forEach(ctClass -> {
                    Class objectClass = this.generator.detachCtClass(ctClass.getName());
                    if (objectClass != null) {
                        this.storageByClass.remove(objectClass);
                        this.storageByName.remove(objectClass.getName());
                        this.storageOldByName.remove(objectClass.getName());
                    }
                });
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Removing ClassLoader failed.");
            }
        }
    }

    SerialSupport generateSerialSupport(Class objectClass, ClassLoader systemLoader, SerialSchema serialSchema) throws JSerializerException {
        return this.generator.generateSerialSupport(objectClass, -1L, systemLoader, serialSchema);
    }

    @Override
    protected Map<String, Integer> getOldLoaderCount() {
        return JSerializerFactory.getCount(this.oldLoadersByVersion);
    }

    @Override
    protected Map<String, Integer> getOldSerialSupportCount() {
        return JSerializerFactory.getCount(this.storageOldByName);
    }

    private static <T1, T2> Map<String, Integer> getCount(Map<String, Map<T1, T2>> map) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, Map<T1, T2>> entry : map.entrySet()) {
            result.put(entry.getKey(), entry.getValue().size());
        }
        return result;
    }

    @Override
    protected List<Long> getOldLoaderVersions(String className) {
        return JSerializerFactory.getVersions(this.oldLoadersByVersion, className);
    }

    @Override
    protected List<Long> getOldSerialSupportVersions(String className) {
        return JSerializerFactory.getVersions(this.storageOldByName, className);
    }

    private static <T> List<Long> getVersions(Map<String, Map<Long, T>> map, String className) {
        Map<Long, T> values = map.get(className);
        return values != null ? new ArrayList<Long>(values.keySet()) : new ArrayList();
    }

    private static class ClassData {
        Class objectClass;
        ClassLoader loader;
        boolean isActual = true;
        long serialVersion = -1L;
        SerialSchema schema;

        ClassData(Class objectClass, long serialVersion) {
            this.objectClass = objectClass;
            this.serialVersion = serialVersion;
        }

        ClassData(Class objectClass, ClassLoader loader, boolean isActual, long serialVersion) {
            this(objectClass, serialVersion);
            this.loader = loader;
            this.isActual = isActual;
        }

        ClassData(Class objectClass, ClassLoader loader, long serialVersion, SerialSchema schema) {
            this(objectClass, loader, false, serialVersion);
            this.schema = schema;
        }
    }
}

