/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.java;

import com.streamscape.lib.utils.Pair;
import com.streamscape.omf.ObjectConverter;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.omf.java.SerialSchema;
import com.streamscape.omf.java.SerialSupport;
import com.streamscape.omf.java.Utils;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.repository.types.AbstractSemanticFactory;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sef.dispatcher.AbstractJSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JSerializer
extends AbstractJSerializer {
    private JSerializerFactory factory;
    private String serializerName = "jser";
    boolean forAnalyze = false;
    Map<Long, AnalyzeVisitor> analyzeVisitors = null;

    JSerializer(JSerializerFactory factory, ObjectMediationAliasManager aliasManager) {
        super(aliasManager);
        this.factory = factory;
    }

    public byte[] serialize(Object object) throws JSerializerException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.serialize(object, new DataOutputStream(buffer));
        return buffer.toByteArray();
    }

    @Override
    public void serialize(Object object, DataOutputStream buffer) throws JSerializerException {
        this.doSerialize(object, buffer);
    }

    public byte[] serialize(String semanticType, Object object) throws SerializerException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.serialize(semanticType, object, new DataOutputStream(buffer));
        return buffer.toByteArray();
    }

    @Override
    public void serialize(String semanticType, Object object, DataOutputStream buffer) throws SerializerException {
        this.checkSemanticTypeMatch(this.getSemanticType(semanticType), object, "serializing");
        this.serialize(object, buffer);
    }

    void doSerialize(Object object, DataOutputStream buffer) throws JSerializerException {
        try {
            if (object == null) {
                buffer.writeByte(1);
            } else {
                SerialSupport support;
                Class<?> objectClass = object.getClass();
                if (objectClass.equals(byte[].class)) {
                    buffer.writeByte(3);
                    buffer.writeShort(0);
                    support = this.factory.byteArraySupport;
                } else {
                    SemanticType type = this.lookupSemanticClassFull(objectClass);
                    if (type == null) {
                        buffer.writeByte(0);
                        Utils.serialize(objectClass.getName(), buffer);
                        support = this.factory.getSerialSupport(objectClass, -1L, (ClassLoader)this.classLoader);
                    } else if (type.isSystem()) {
                        buffer.writeByte(3);
                        buffer.writeShort(AbstractSemanticFactory.getSerialId(type));
                        support = this.factory.getSerialSupport(objectClass, type, (ClassLoader)this.classLoader);
                    } else {
                        buffer.writeByte(2);
                        Utils.serialize(type.getTypeName(), buffer);
                        support = this.factory.getSerialSupport(objectClass, type.getSerialVersionUID(), (ClassLoader)this.classLoader);
                    }
                }
                if (support.getSerialVersionUID() != -1L) {
                    buffer.writeLong(support.getSerialVersionUID());
                }
                support.serialize(object, buffer, this);
            }
        }
        catch (Throwable exception) {
            if (exception instanceof JSerializerException) {
                throw (JSerializerException)exception;
            }
            throw new JSerializerException(3014, exception);
        }
    }

    void serializeParent(Object object, DataOutputStream buffer, String parentClassName) throws JSerializerException {
        try {
            Class parentClass = JSerializer.getParentClass(object, parentClassName);
            SemanticType type = this.lookupSemanticClass(parentClass);
            if (type == null) {
                throw new JSerializerException(3022, "Semantic type not found for class '" + parentClass.getName() + "'.");
            }
            SerialSupport support = this.factory.getSerialSupport(parentClass, type.getSerialVersionUID(), (ClassLoader)this.classLoader);
            buffer.writeLong(support.getSerialVersionUID());
            support.serialize(object, buffer, this);
        }
        catch (Exception exception) {
            if (exception instanceof JSerializerException) {
                throw (JSerializerException)exception;
            }
            throw new JSerializerException(3014, (Throwable)exception);
        }
    }

    private static Class getParentClass(Object object, String parentClassName) throws JSerializerException {
        for (Class<?> parentClass = object.getClass().getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
            if (!parentClass.getName().endsWith(parentClassName)) continue;
            return parentClass;
        }
        throw new JSerializerException(3014, "Super class '" + parentClassName + "' not found for class '" + object.getClass().getName() + "'.");
    }

    @Override
    public Object deserialize(byte[] buffer) throws JSerializerException {
        return this.deserialize(new DataInputStream(new ByteArrayInputStream(buffer)));
    }

    @Override
    public Object deserialize(DataInputStream buffer) throws JSerializerException {
        return this.doDeserialize(buffer, null);
    }

    @Override
    public Object deserialize(String semanticType, byte[] buffer) throws SerializerException {
        return this.deserialize(semanticType, new DataInputStream(new ByteArrayInputStream(buffer)));
    }

    @Override
    public Object deserialize(String semanticType, DataInputStream buffer) throws SerializerException {
        SemanticType type = this.getSemanticType(semanticType);
        Object result = this.deserialize(buffer);
        this.checkSemanticTypeMatch(type, result, "deserialized");
        return result;
    }

    Object doDeserialize(DataInputStream buffer, Object outer) throws JSerializerException {
        try {
            byte code = buffer.readByte();
            if (code == 1) {
                return null;
            }
            boolean isActualClass = true;
            SerialSupport support = null;
            if (code == 3) {
                short serialId = buffer.readShort();
                if (serialId == 0) {
                    support = this.factory.byteArraySupport;
                } else {
                    SemanticType type = this.lookupSemanticType(serialId);
                    if (type == null) {
                        throw new JSerializerException(3022, "Semantic type not found for serial id '" + serialId + "'.");
                    }
                    support = this.factory.getSerialSupport(type, (ClassLoader)this.classLoader);
                }
            } else if (code == 2) {
                AnalyzeVisitor visitor;
                String classAlias = Utils.deserialize(buffer);
                SemanticType type = this.lookupSemanticType(classAlias);
                if (type == null) {
                    throw new JSerializerException(3022, "Semantic type not found for alias '" + classAlias + "'.");
                }
                long serialVersion = buffer.readLong();
                isActualClass = JSerializer.isActualClass(type, serialVersion);
                support = this.factory.getSerialSupport(type, isActualClass, serialVersion, this.classLoader);
                if (this.forAnalyze && (visitor = this.analyzeVisitors.get(Thread.currentThread().getId())) != null) {
                    visitor.visit(type, serialVersion);
                }
            } else if (code == 0) {
                support = this.factory.getSerialSupport(Utils.deserialize(buffer), (ClassLoader)this.classLoader);
            }
            Object result = support.instantiate(buffer, this, outer);
            support.deserialize(result, buffer, this);
            return isActualClass ? result : ObjectConverter.convert(result, this.classLoader);
        }
        catch (Throwable exception) {
            if (exception instanceof JSerializerException) {
                throw (JSerializerException)exception;
            }
            throw new JSerializerException(3015, exception);
        }
    }

    void deserializeParent(Object result, DataInputStream buffer, String parentClassName) throws JSerializerException {
        try {
            SemanticType type = this.lookupSemanticClass(parentClassName);
            if (type == null) {
                throw new JSerializerException(3022, "Semantic type not found for class '" + parentClassName + "'.");
            }
            long serialVersion = buffer.readLong();
            SerialSupport support = this.factory.getSerialSupport(type, JSerializer.isActualClass(type, serialVersion), serialVersion, this.classLoader);
            support.deserialize(result, buffer, this);
        }
        catch (Exception exception) {
            if (exception instanceof JSerializerException) {
                throw (JSerializerException)exception;
            }
            throw new JSerializerException(3015, (Throwable)exception);
        }
    }

    protected Object deserializeSpecial(DataInputStream buffer, List<SerialSupport> serialSupports) {
        return null;
    }

    static boolean isActualClass(SemanticType type, long serialVersion) {
        return type == null || serialVersion == -1L || type.getSerialVersionUID() == serialVersion;
    }

    List<Pair<SemanticType, Long>> analyze(DataInputStream stream) throws JSerializerException {
        ArrayList<Pair<SemanticType, Long>> result = new ArrayList<Pair<SemanticType, Long>>();
        this.analyzeVisitors.put(Thread.currentThread().getId(), parameters -> result.add(new Pair<SemanticType, Long>((SemanticType)parameters[0], (Long)parameters[1])));
        try {
            this.deserialize(stream);
        }
        finally {
            this.analyzeVisitors.remove(Thread.currentThread().getId());
        }
        return result;
    }

    protected void setName(String serializerName) {
        this.serializerName = serializerName;
    }

    @Override
    public String getName() {
        return this.serializerName;
    }

    @Override
    protected SerializerException createException(int errorCode, String message) {
        return new JSerializerException(errorCode, message);
    }

    @Override
    protected SerializerException createException(int errorCode, Throwable cause) {
        return new JSerializerException(errorCode, cause);
    }

    @Override
    protected SerializerException createException(int errorCode, String message, Throwable cause) {
        return new JSerializerException(errorCode, message, cause);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    protected SerialSupport generateSerialSupport(Class objectClass, SerialSchema serialSchema) throws JSerializerException {
        return this.factory.generateSerialSupport(objectClass, (ClassLoader)this.classLoader, serialSchema);
    }

    private static interface AnalyzeVisitor {
        public void visit(Object ... var1);
    }
}

