/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.java;

import com.streamscape.lib.loader.ClassLoaderReference;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.lib.utils.Pair;
import com.streamscape.omf.java.AbstractSerialSupport;
import com.streamscape.omf.java.FieldResolver;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.omf.java.SerialSchema;
import com.streamscape.omf.java.SerialSupport;
import com.streamscape.repository.types.SemanticType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.compiler.Javac;

class Generator {
    private static final String OBJECT_PARAM = "obj";
    private static final String INPUT_VAR = "input";
    private static final String OUTPUT_VAR = "output";
    private static final String OBJECT_VAR = "object";
    private static final String FACTORY_VAR = "factory";
    private static final String SERIAL_SUPPORT_CLASS_PREFIX = "SySerial$";
    private static final String FIELD_SUFFIX = "_field";
    private static final String OBJECT_PARAM_DECL = Object.class.getName() + " obj";
    private static final String INPUT_VAR_DECL = DataInputStream.class.getName() + " input";
    private static final String OUTPUT_VAR_DECL = DataOutputStream.class.getName() + " output";
    private static final String FACTORY_VAR_DECL = JSerializer.class.getName() + " factory";
    private JSerializerFactory factory;
    private ClassPool classPool;
    private final Map<String, Pair<Class, CtClass>> ctClasses = new HashMap<String, Pair<Class, CtClass>>();
    private final Map<ClassLoader, LoaderClassPath> classPaths = new HashMap<ClassLoader, LoaderClassPath>();
    private static final LongNumberAllocatorSimple SERIAL_SUPPORT_NAME_ALLOCATOR = new LongNumberAllocatorSimple();
    public static final Boolean NULL_BOOLEAN = false;
    public static final Byte NULL_BYTE = 0;
    public static final Short NULL_SHORT = 0;
    public static final Integer NULL_INTEGER = 0;
    public static final Long NULL_LONG = 0L;
    public static final Float NULL_FLOAT = Float.valueOf(0.0f);
    public static final Double NULL_DOUBLE = 0.0;
    private static final int bannedMods = 136;

    Generator(JSerializerFactory factory) {
        this.factory = factory;
        this.classPool = ClassPool.getDefault();
    }

    private ClassLoader prepareClassLoader(Class clazz, ClassLoader classLoader) throws JSerializerException {
        classLoader = ClassLoaderReference.getRealClassLoader(classLoader);
        this.addClassLoader(clazz, classLoader);
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClassLoader(Class clazz, ClassLoader classLoader) throws JSerializerException {
        Map<ClassLoader, LoaderClassPath> map = this.classPaths;
        synchronized (map) {
            if (!this.classPaths.containsKey(classLoader)) {
                LoaderClassPath classPath = new LoaderClassPath(classLoader);
                this.classPaths.put(classLoader, classPath);
                this.classPool.appendClassPath(classPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassLoader removeClassLoader(ClassLoader classLoader) {
        Map<ClassLoader, LoaderClassPath> map = this.classPaths;
        synchronized (map) {
            classLoader = ClassLoaderReference.getRealClassLoader(classLoader);
            LoaderClassPath classPath = this.classPaths.remove(classLoader);
            if (classPath != null) {
                this.classPool.removeClassPath(classPath);
                return classLoader;
            }
        }
        return null;
    }

    Class detachCtClass(String ctClassName) {
        Pair<Class, CtClass> pair = this.ctClasses.remove(ctClassName);
        if (pair != null) {
            ((CtClass)pair.second).detach();
            return (Class)pair.first;
        }
        return null;
    }

    void destroy() {
        for (Pair<Class, CtClass> pair : this.ctClasses.values()) {
            ((CtClass)pair.second).detach();
        }
        this.ctClasses.clear();
        for (LoaderClassPath classPath : this.classPaths.values()) {
            this.classPool.removeClassPath(classPath);
        }
        this.classPaths.clear();
    }

    SerialSupport generateSerialSupport(Class clazz, long serialVersion, ClassLoader classLoader, SerialSchema schema) throws JSerializerException {
        Pair<AbstractSerialSupport, CtClass> result;
        classLoader = this.prepareClassLoader(clazz, classLoader);
        if (clazz.isEnum()) {
            result = this.generateEnumSerialSupport(clazz, classLoader, serialVersion);
        } else if (clazz.isArray()) {
            result = this.generateArraySerialSupport(clazz, classLoader);
        } else {
            CtClass ctClass = this.createSerialSupportClass(clazz.getName());
            Pair<Class, Boolean> parentClass = this.generateParentClass(clazz, ctClass, classLoader);
            Field[] fields = Generator.getFields(clazz);
            this.generateFieldAccessors(clazz, fields, ctClass);
            this.generateSerialization(clazz, fields, (Class)parentClass.first, (Boolean)parentClass.second, ctClass);
            this.generateInstantiation(clazz, ctClass);
            this.generateDeserialization(clazz, fields, (Class)parentClass.first, (Boolean)parentClass.second, schema, ctClass);
            result = new Pair<AbstractSerialSupport, CtClass>((AbstractSerialSupport)this.createInstance(ctClass, clazz.getName(), classLoader), ctClass);
        }
        this.ctClasses.put(((AbstractSerialSupport)result.first).getClass().getName(), new Pair<Class, CtClass>(clazz, (CtClass)result.second));
        ((AbstractSerialSupport)result.first).setSerialVersionUID(serialVersion);
        ((AbstractSerialSupport)result.first).objectClass = clazz;
        ((AbstractSerialSupport)result.first).classLoader = classLoader;
        return (SerialSupport)result.first;
    }

    private CtClass createSerialSupportClass(String className) throws JSerializerException {
        try {
            return this.classPool.makeClass(Generator.getSerialSupportClassName(className), this.classPool.get(AbstractSerialSupport.class.getName()));
        }
        catch (NotFoundException exception) {
            throw new JSerializerException(3029, "Generating SerialSupport for class '" + className + "' failed.", exception);
        }
    }

    private static String getSerialSupportClassName(String className) {
        String simpleName = className.substring(className.lastIndexOf(".") + 1);
        Object packageName = "";
        if (className.lastIndexOf(".") != -1) {
            packageName = className.substring(0, className.lastIndexOf("."));
            packageName = (String)packageName + ".";
        }
        return (String)packageName + SERIAL_SUPPORT_CLASS_PREFIX + simpleName + "_" + SERIAL_SUPPORT_NAME_ALLOCATOR.getNumber();
    }

    private Pair<Class, Boolean> generateParentClass(Class clazz, CtClass ctClass, ClassLoader classLoader) throws JSerializerException {
        Class superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            SemanticType type = this.factory.lookupSemanticClassFull(superclass);
            if (type == null || type.isSystem()) {
                this.setSuperclass(ctClass, superclass, classLoader);
                return new Pair<Class, Boolean>(superclass, true);
            }
            return new Pair<Class, Boolean>(superclass, false);
        }
        return new Pair<Object, Boolean>(null, false);
    }

    private void setSuperclass(CtClass cl, Class superClass, ClassLoader classLoader) throws JSerializerException {
        SerialSupport parent = this.factory.getSerialSupport(superClass, classLoader);
        if (parent != null) {
            try {
                cl.setSuperclass(this.classPool.get(parent.getClass().getName()));
            }
            catch (Exception exception) {
                throw new JSerializerException(3029, "Set of super class '" + superClass.getName() + "' for class '" + cl.getName() + "'. failed", exception);
            }
        }
    }

    static Field[] getFields(Class clazz) {
        Field[] result = clazz.getDeclaredFields();
        Arrays.sort(result, (obj1, obj2) -> obj1.getName().compareTo(obj2.getName()));
        return result;
    }

    private static List<FieldData> getFieldsData(Class clazz, Field[] fields, SerialSchema schema) {
        ArrayList<FieldData> result = new ArrayList();
        if (schema != null) {
            for (SerialSchema.Field fieldSchema : schema.fields) {
                FieldData fieldData = new FieldData(fieldSchema);
                try {
                    if (!fieldData.fieldSchema.isRemoved()) {
                        fieldData.field = clazz.getDeclaredField(fieldSchema.name);
                        if (!fieldData.field.getType().getName().equals(fieldSchema.type)) {
                            fieldData.field = null;
                        } else {
                            fieldData.fieldSchema = null;
                        }
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                result.add(fieldData);
            }
        } else {
            result = Arrays.stream(fields).map(FieldData::new).collect(Collectors.toList());
        }
        return result;
    }

    private void generateFieldAccessors(Class clazz, Field[] fields, CtClass resultClass) throws JSerializerException {
        for (Field field : fields) {
            String body = "private " + Field.class.getName() + " " + field.getName() + "_field = " + FieldResolver.class.getName() + ".getField(" + clazz.getName() + ".class, \"" + field.getName() + "\");";
            try {
                resultClass.addField(Javac.CtFieldWithInit.make(body, resultClass));
            }
            catch (CannotCompileException exception) {
                throw new JSerializerException(3029, "Generating accessor of private field '" + field.toString() + "' failed.", exception);
            }
        }
    }

    private void generateInstantiation(Class clazz, CtClass resultClass) throws JSerializerException {
        Object body = this.generateInstantiateMethodHeader(clazz);
        body = (String)body + this.generateInstantiateMethodBody(clazz);
        body = (String)body + "}\n";
        this.addMethod((String)body, resultClass, clazz.getName());
    }

    private String generateInstantiateMethodHeader(Class clazz) {
        return "public " + Object.class.getName() + " instantiate(" + INPUT_VAR_DECL + "," + FACTORY_VAR_DECL + (String)(Generator.isInnerClass(clazz) ? ", " + Object.class.getName() + " outer" : "") + ") {\n";
    }

    private String generateInstantiateMethodBody(Class clazz) {
        if (Throwable.class.isAssignableFrom(clazz)) {
            StringBuilder builder = new StringBuilder();
            builder.append(clazz.getName()).append(" result = new ").append(clazz.getName()).append("(com.streamscape.omf.java.Utils.deserialize(input));\nresult.setStackTrace((StackTraceElement[])deserialize(factory, input));\nresult.initCause((Throwable)deserialize(factory, input));\nreturn result;\n");
            return builder.toString();
        }
        if (Generator.isInnerClass(clazz)) {
            StringBuilder parameterTypes = new StringBuilder(clazz.getEnclosingClass().getName() + ".class");
            StringBuilder parameters = new StringBuilder("outer");
            Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
            for (Class<?> parameterType : constructor.getParameterTypes()) {
                if (parameterType.equals(clazz.getEnclosingClass())) continue;
                parameterTypes.append(", ").append(parameterType.getName()).append(".class");
                parameters.append(", ").append(parameterType.isPrimitive() ? Generator.getNullValue(parameterType) : "null");
            }
            String result = "\tjava.lang.reflect.Constructor constructor = " + clazz.getName() + ".class.getDeclaredConstructor(new Class[] { " + parameterTypes.toString() + " });\n";
            result = result + "\treturn constructor.newInstance(new Object[] { " + parameters.toString() + " });\n";
            return result;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return "\treturn null;\n";
        }
        if (!Generator.hasEmptyConstructor(clazz)) {
            return "\treturn com.streamscape.lib.reflection.ReflectionProvider.getInstance().newInstance(" + clazz.getName() + ".class);\n";
        }
        return "\treturn new " + clazz.getName() + "();\n";
    }

    private static String getNullValue(Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return "com.streamscape.omf.java.Generator.NULL_BOOLEAN";
        }
        if (clazz.equals(Byte.TYPE)) {
            return "com.streamscape.omf.java.Generator.NULL_BYTE";
        }
        if (clazz.equals(Short.TYPE)) {
            return "com.streamscape.omf.java.Generator.NULL_SHORT";
        }
        if (clazz.equals(Integer.TYPE)) {
            return "com.streamscape.omf.java.Generator.NULL_INTEGER";
        }
        if (clazz.equals(Long.TYPE)) {
            return "com.streamscape.omf.java.Generator.NULL_LONG";
        }
        if (clazz.equals(Float.TYPE)) {
            return "com.streamscape.omf.java.Generator.NULL_FLOAT";
        }
        if (clazz.equals(Double.TYPE)) {
            return "com.streamscape.omf.java.Generator.NULL_DOUBLE";
        }
        return "null";
    }

    private static boolean hasEmptyConstructor(Class clazz) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (Modifier.isPublic(constructor.getModifiers())) {
                return true;
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return false;
    }

    private void generateSerialization(Class clazz, Field[] fields, Class parentClass, boolean isSystemParent, CtClass resultClass) throws JSerializerException {
        Object body = this.generateSerializeMethodHeader();
        if (parentClass != null) {
            body = isSystemParent ? (String)body + "\tsuper.serialize(obj, output, factory);\n" : (String)body + "\tserializeParent(factory, obj, output, \"" + parentClass.getName() + "\");\n";
        }
        body = (String)body + this.generateObjectCast(clazz.getName());
        body = (String)body + this.generateFieldSerialization(clazz, fields, false);
        body = (String)body + "}\n";
        this.addMethod((String)body, resultClass, clazz.getName());
    }

    private String generateSerializeMethodHeader() {
        return "public void serialize(" + OBJECT_PARAM_DECL + ", " + OUTPUT_VAR_DECL + ", " + FACTORY_VAR_DECL + ") {\n";
    }

    private String generateFieldSerialization(Class clazz, Field[] fields, boolean noPublic) throws JSerializerException {
        Object result = "";
        if (noPublic) {
            result = (String)result + "\tcom.streamscape.lib.reflection.ReflectionProvider provider = com.streamscape.lib.reflection.ReflectionProvider.getInstance();\n";
        }
        for (Field field : fields) {
            if (Generator.isOuterClassReference(clazz, field.getName()) || Generator.isTransient(field)) continue;
            result = !Generator.isPublic(field) || noPublic ? (String)result + this.generatePrivateElementSerialization(field.getName(), field.getType(), "\t", noPublic) : (String)result + this.generateElementSerialization("object." + field.getName(), field.getType(), "\t");
        }
        return result;
    }

    private String generatePrivateElementSerialization(String fieldName, Class type, String tabs, boolean useReflectionProvider) throws JSerializerException {
        String accessParam;
        String string = accessParam = useReflectionProvider ? "(provider.getField(obj.getClass(), \"" + fieldName + "\"), obj)" : "(" + fieldName + "_field, object)";
        if (Boolean.TYPE.equals(type)) {
            String access = FieldResolver.class.getName() + ".getBoolean" + accessParam;
            return tabs + "output.writeByte((" + access + ")?(byte)1:(byte)0);\n";
        }
        if (Byte.TYPE.equals(type)) {
            String access = FieldResolver.class.getName() + ".getByte" + accessParam;
            return tabs + "output.writeByte(" + access + ");\n";
        }
        if (Short.TYPE.equals(type)) {
            String access = FieldResolver.class.getName() + ".getShort" + accessParam;
            return tabs + "output.writeShort(" + access + ");\n";
        }
        if (Integer.TYPE.equals(type)) {
            String access = FieldResolver.class.getName() + ".getInt" + accessParam;
            return tabs + "output.writeInt(" + access + ");\n";
        }
        if (Long.TYPE.equals(type)) {
            String access = FieldResolver.class.getName() + ".getLong" + accessParam;
            return tabs + "output.writeLong(" + access + ");\n";
        }
        if (Float.TYPE.equals(type)) {
            String access = FieldResolver.class.getName() + ".getFloat" + accessParam;
            return tabs + "output.writeFloat(" + access + ");\n";
        }
        if (Double.TYPE.equals(type)) {
            String access = FieldResolver.class.getName() + ".getDouble" + accessParam;
            return tabs + "output.writeDouble(" + access + ");\n";
        }
        if (Character.TYPE.equals(type)) {
            String access = FieldResolver.class.getName() + ".getChar" + accessParam;
            return tabs + "output.writeChar(" + access + ");\n";
        }
        String access = FieldResolver.class.getName() + ".get" + accessParam;
        return tabs + "serialize(factory, " + access + ", output);\n";
    }

    private String generateElementSerialization(String name, Class type, String tabs) throws JSerializerException {
        if (Boolean.TYPE.equals(type)) {
            return tabs + "output.writeByte((" + name + ")?(byte)1:(byte)0);\n";
        }
        if (Byte.TYPE.equals(type)) {
            return tabs + "output.writeByte(" + name + ");\n";
        }
        if (Short.TYPE.equals(type)) {
            return tabs + "output.writeShort(" + name + ");\n";
        }
        if (Integer.TYPE.equals(type)) {
            return tabs + "output.writeInt(" + name + ");\n";
        }
        if (Long.TYPE.equals(type)) {
            return tabs + "output.writeLong(" + name + ");\n";
        }
        if (Float.TYPE.equals(type)) {
            return tabs + "output.writeFloat(" + name + ");\n";
        }
        if (Double.TYPE.equals(type)) {
            return tabs + "output.writeDouble(" + name + ");\n";
        }
        if (Character.TYPE.equals(type)) {
            return tabs + "output.writeChar(" + name + ");\n";
        }
        return tabs + "serialize(factory, " + name + ", output);\n";
    }

    private void generateDeserialization(Class clazz, Field[] fields, Class parentClass, boolean isSystemParent, SerialSchema schema, CtClass result) throws JSerializerException {
        Object body = this.generateDeserializeMethodHeader();
        if (parentClass != null) {
            body = isSystemParent ? (String)body + "\tsuper.deserialize(obj, input, factory);\n" : (String)body + "\tdeserializeParent(factory, obj, input, \"" + parentClass.getName() + "\");\n";
        }
        body = (String)body + this.generateObjectCast(clazz.getName());
        for (FieldData field : Generator.getFieldsData(clazz, fields, schema)) {
            if (Generator.isOuterClassReference(clazz, field.getName())) continue;
            body = (String)body + this.generateFieldDeserialization(field);
        }
        body = (String)body + "}\n";
        this.addMethod((String)body, result, clazz.getName());
    }

    private String generateDeserializeMethodHeader() {
        return "public void deserialize(" + OBJECT_PARAM_DECL + ", " + INPUT_VAR_DECL + "," + FACTORY_VAR_DECL + ") {\n";
    }

    private String generateFieldDeserialization(FieldData field) throws JSerializerException {
        if (field.isTransient()) {
            return "";
        }
        if (field.isInner()) {
            return "\t" + (String)(field.field != null ? "object." + field.getName() + " = (" + this.getCastName(field.field.getType()) + ") " : "") + "deserialize(factory, input, object);\n";
        }
        return !field.isPublic() || Generator.isFinal(field.field) ? this.generatePrivateElementDeserialization(field, "\t") : this.generateElementDeserialization("object." + field.getName(), field.getType(), field.field != null ? field.field.getType() : null, "\t");
    }

    private String generatePrivateElementDeserialization(FieldData fieldData, String tabs) throws JSerializerException {
        String method;
        String value;
        String suffix;
        String type = fieldData.getType();
        String prefix = fieldData.field != null ? FieldResolver.class.getName() + "." : "";
        String accessParam = fieldData.field != null ? "(" + fieldData.getName() + "_field, object, " : "";
        String string = suffix = fieldData.field != null ? ");\n" : ";\n";
        if (type.equals(Boolean.TYPE.getName())) {
            value = fieldData.field != null ? "(input.readByte() != 0)" : "input.readByte()";
            method = "setBoolean";
        } else if (type.equals(Byte.TYPE.getName())) {
            value = "input.readByte()";
            method = "setByte";
        } else if (type.equals(Short.TYPE.getName())) {
            value = "input.readShort()";
            method = "setShort";
        } else if (type.equals(Integer.TYPE.getName())) {
            value = "input.readInt()";
            method = "setInt";
        } else if (type.equals(Long.TYPE.getName())) {
            value = "input.readLong()";
            method = "setLong";
        } else if (type.equals(Float.TYPE.getName())) {
            value = "input.readFloat()";
            method = "setFloat";
        } else if (type.equals(Double.TYPE.getName())) {
            value = "input.readDouble()";
            method = "setDouble";
        } else if (type.equals(Character.TYPE.getName())) {
            value = "input.readChar()";
            method = "setChar";
        } else {
            value = "deserialize(factory, input)";
            method = "set";
        }
        if (fieldData.field == null) {
            method = "";
        }
        return tabs + prefix + method + accessParam + value + suffix;
    }

    private String generateElementDeserialization(String name, String typeName, Class type, String tabs) throws JSerializerException {
        boolean isStub;
        boolean bl = isStub = type == null;
        if (typeName.equals(Boolean.TYPE.getName())) {
            return tabs + (String)(!isStub ? name + " = (input.readByte() != 0);\n" : "input.readByte();\n");
        }
        if (typeName.equals(Byte.TYPE.getName())) {
            return this.generateElementDeserialization(tabs, name, ".readByte();", isStub);
        }
        if (typeName.equals(Short.TYPE.getName())) {
            return this.generateElementDeserialization(tabs, name, ".readShort();", isStub);
        }
        if (typeName.equals(Integer.TYPE.getName())) {
            return this.generateElementDeserialization(tabs, name, ".readInt();", isStub);
        }
        if (typeName.equals(Long.TYPE.getName())) {
            return this.generateElementDeserialization(tabs, name, ".readLong();", isStub);
        }
        if (typeName.equals(Float.TYPE.getName())) {
            return this.generateElementDeserialization(tabs, name, ".readFloat();", isStub);
        }
        if (typeName.equals(Double.TYPE.getName())) {
            return this.generateElementDeserialization(tabs, name, ".readDouble();", isStub);
        }
        if (typeName.equals(Character.TYPE.getName())) {
            return this.generateElementDeserialization(tabs, name, ".readChar();", isStub);
        }
        return tabs + (String)(!isStub ? name + " = (" + this.getCastName(type) + ")" : "") + "deserialize(factory, input);\n";
    }

    private String generateElementDeserialization(String tabs, String name, String body, boolean isStub) {
        return tabs + (String)(!isStub ? name + " = " : "") + INPUT_VAR + body + "\n";
    }

    private Pair<AbstractSerialSupport, CtClass> generateEnumSerialSupport(Class clazz, ClassLoader classLoader, long serialVersionUID) throws JSerializerException {
        String className = clazz.getName();
        CtClass ctClasss = this.createSerialSupportClass(className);
        this.setSuperclass(ctClasss, clazz.getSuperclass(), classLoader);
        Object body = this.generateInstantiateMethodHeader(clazz);
        body = (String)body + "\t return " + className + ".values()[input.readInt()];\n";
        body = (String)body + "}\n";
        this.addMethod((String)body, ctClasss, className);
        return new Pair<AbstractSerialSupport, CtClass>((AbstractSerialSupport)this.createInstance(ctClasss, className, classLoader), ctClasss);
    }

    private Pair<AbstractSerialSupport, CtClass> generateArraySerialSupport(Class clazz, ClassLoader classLoader) throws JSerializerException {
        Object className = this.getCastName(clazz);
        CtClass ctClass = this.createSerialSupportClass(clazz.getName().replaceAll("\\[", "_ARR\\$").replaceAll(";", "_"));
        Object body = this.generateSerializeMethodHeader();
        body = clazz.getComponentType().isPrimitive() ? (String)body + this.generateObjectCast((String)className) : (String)body + "\tObject[] object = (Object[])obj;\n";
        body = (String)body + "\toutput.writeInt(object.length);\n";
        if (clazz.getName().equals(byte[].class.getName())) {
            body = (String)body + "\toutput.write(object);\n";
        } else {
            body = (String)body + "\tfor (int i = 0; i < object.length; ++i) {\n";
            body = (String)body + this.generateElementSerialization("object[i]", clazz.getComponentType(), "\t\t");
            body = (String)body + "\t}\n";
        }
        body = (String)body + "}\n";
        this.addMethod((String)body, ctClass, (String)className);
        Class<?> baseType = clazz.getComponentType();
        int depth = 0;
        while (baseType.isArray()) {
            baseType = baseType.getComponentType();
            ++depth;
        }
        className = baseType.getName() + "[]";
        String newOperation = baseType.getName() + "[len]";
        for (int i = depth; i > 0; --i) {
            className = (String)className + "[]";
            newOperation = newOperation + "[]";
        }
        body = this.generateInstantiateMethodHeader(clazz);
        body = (String)body + "\tint len = input.readInt();\n";
        body = (String)body + "\treturn new " + newOperation + ";\n";
        body = (String)body + "}\n";
        this.addMethod((String)body, ctClass, (String)className);
        body = this.generateDeserializeMethodHeader();
        body = (String)body + this.generateObjectCast((String)className);
        if (clazz.getName().equals(byte[].class.getName())) {
            body = (String)body + "\tinput.readFully(object, 0, object.length);\n";
        } else {
            body = (String)body + "\tfor (int i = 0; i < object.length; ++i) {\n";
            body = (String)body + this.generateElementDeserialization("object[i]", clazz.getComponentType().getName(), clazz.getComponentType(), "\t\t");
            body = (String)body + "\t}\n";
        }
        body = (String)body + "\treturn object;\n}\n";
        this.addMethod((String)body, ctClass, (String)className);
        return new Pair<AbstractSerialSupport, CtClass>((AbstractSerialSupport)this.createInstance(ctClass, (String)className, classLoader), ctClass);
    }

    private void addMethod(String body, CtClass cl, String className) throws JSerializerException {
        try {
            cl.addMethod(CtNewMethod.make(body, cl));
        }
        catch (Exception exception) {
            throw new JSerializerException(3029, "Adding of method for class '" + className + "' failed.", exception);
        }
    }

    private Object createInstance(CtClass cl, String className, ClassLoader classLoader) throws JSerializerException {
        try {
            return cl.toClass(classLoader, null).newInstance();
        }
        catch (Exception exception) {
            throw new JSerializerException(3029, "Creation of instance for class '" + className + "' failed.", exception);
        }
    }

    private String getCastName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        Class<?> baseType = clazz.getComponentType();
        int depth = 1;
        while (baseType.isArray()) {
            baseType = baseType.getComponentType();
            ++depth;
        }
        Object className = baseType.getName();
        for (int i = depth; i > 0; --i) {
            className = (String)className + "[]";
        }
        return className;
    }

    private String generateObjectCast(String className) {
        return "\t" + className + " object = (" + className + ") obj;\n";
    }

    static boolean isTransient(Field field) {
        return (field.getModifiers() & 0x88) != 0;
    }

    static boolean isPublic(Field field) {
        return Modifier.isPublic(field.getModifiers());
    }

    static boolean isFinal(Field field) {
        return field != null && Modifier.isFinal(field.getModifiers());
    }

    static boolean isInner(Field field) {
        return Generator.isInnerClass(field.getType());
    }

    private static boolean isInnerClass(Class clazz) {
        return clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers());
    }

    private static boolean isOuterClassReference(Class clazz, String fieldName) {
        return Generator.isInnerClass(clazz) && fieldName.contains("this$");
    }

    private static class FieldData {
        Field field;
        SerialSchema.Field fieldSchema;

        FieldData(Field field) {
            this.field = field;
        }

        FieldData(SerialSchema.Field fieldSchema) {
            this.fieldSchema = fieldSchema;
        }

        String getName() {
            return this.field != null ? this.field.getName() : this.fieldSchema.name;
        }

        String getType() {
            return this.field != null ? this.field.getType().getName() : this.fieldSchema.type;
        }

        boolean isPublic() {
            return this.field != null ? Generator.isPublic(this.field) : this.fieldSchema.isPublic;
        }

        boolean isInner() {
            return this.field != null ? Generator.isInner(this.field) : this.fieldSchema.isInner;
        }

        boolean isTransient() {
            return this.field != null && Generator.isTransient(this.field);
        }
    }
}

