/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.java;

import com.streamscape.omf.java.JSerializerException;
import java.lang.reflect.Field;

public class FieldResolver {
    public static Field getField(Class clazz, String name) throws JSerializerException {
        try {
            Field result = clazz.getDeclaredField(name);
            result.setAccessible(true);
            return result;
        }
        catch (SecurityException exception) {
            throw new JSerializerException(3028, "Resolving field '" + name + "' for class " + clazz.getName() + " failed.", exception);
        }
        catch (NoSuchFieldException exception) {
            throw new JSerializerException(3028, "Field '" + name + "' not found for class " + clazz.getName() + ": " + exception.getMessage());
        }
    }

    public static Object get(Field field, Object obj) throws JSerializerException {
        try {
            return field.get(obj);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static void set(Field field, Object obj, Object value) throws JSerializerException {
        try {
            field.set(obj, value);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static boolean getBoolean(Field field, Object obj) throws JSerializerException {
        try {
            return field.getBoolean(obj);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static byte getByte(Field field, Object obj) throws JSerializerException {
        try {
            return field.getByte(obj);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static short getShort(Field field, Object obj) throws JSerializerException {
        try {
            return field.getShort(obj);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static int getInt(Field field, Object obj) throws JSerializerException {
        try {
            return field.getInt(obj);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static long getLong(Field field, Object obj) throws JSerializerException {
        try {
            return field.getLong(obj);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static float getFloat(Field field, Object obj) throws JSerializerException {
        try {
            return field.getFloat(obj);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static double getDouble(Field field, Object obj) throws JSerializerException {
        try {
            return field.getDouble(obj);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static char getChar(Field field, Object obj) throws JSerializerException {
        try {
            return field.getChar(obj);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static void setBoolean(Field field, Object obj, boolean value) throws JSerializerException {
        try {
            field.setBoolean(obj, value);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static void setByte(Field field, Object obj, byte value) throws JSerializerException {
        try {
            field.setByte(obj, value);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static void setShort(Field field, Object obj, short value) throws JSerializerException {
        try {
            field.setShort(obj, value);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static void setInt(Field field, Object obj, int value) throws JSerializerException {
        try {
            field.setInt(obj, value);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static void setLong(Field field, Object obj, long value) throws JSerializerException {
        try {
            field.setLong(obj, value);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static void setFloat(Field field, Object obj, float value) throws JSerializerException {
        try {
            field.setFloat(obj, value);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static void setDouble(Field field, Object obj, double value) throws JSerializerException {
        try {
            field.setDouble(obj, value);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    public static void setChar(Field field, Object obj, char value) throws JSerializerException {
        try {
            field.setChar(obj, value);
        }
        catch (Exception exception) {
            throw FieldResolver.createAccessFieldException(field, exception);
        }
    }

    private static JSerializerException createAccessFieldException(Field field, Exception exception) {
        return new JSerializerException(3028, "Accessing field '" + field.getName() + "' for class " + field.getDeclaringClass().getName() + " failed: " + exception.getMessage());
    }
}

