/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf;

import com.streamscape.Trace;
import com.streamscape.lib.reflection.ReflectionProvider;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.omf.ObjectMediationException;
import java.lang.reflect.Field;

public class ObjectConverter {
    public static Object convert(Object obj, ClassLoader classLoader) throws ObjectMediationException {
        return obj != null ? ObjectConverter.convert(obj, ObjectConverter.loadClass(obj.getClass().getName(), classLoader)) : obj;
    }

    private static Class loadClass(String className, ClassLoader classLoader) throws ObjectMediationException {
        try {
            return ClassUtils.loadClass(className, classLoader);
        }
        catch (ClassNotFoundException exception) {
            throw new ObjectMediationException(3025, "Class '" + className + "' not found.");
        }
    }

    public static Object convert(Object obj, final Class newClass) throws ObjectMediationException {
        if (obj == null || newClass.isInstance(obj)) {
            return obj;
        }
        Class<?> oldClass = obj.getClass();
        try {
            final Object result = ReflectionProvider.getInstance().newInstance(newClass);
            ReflectionProvider.getInstance().visitSerializableFields(obj, new ReflectionProvider.FieldVisitor(){

                @Override
                public void visit(String name, Class type, Object value, Class definedIn) {
                    try {
                        Field field = ObjectConverter.getField(newClass, name);
                        if (field != null) {
                            field.setAccessible(true);
                            field.set(result, value);
                        }
                    }
                    catch (Exception exception) {
                        Trace.logError(ObjectConverter.class, "Converting field '" + name + "' in class '" + newClass.getName() + "' failed. Cause: " + exception.toString());
                    }
                }
            });
            return result;
        }
        catch (Exception exception) {
            throw new ObjectMediationException(3045, "Converting object to latest version failed.", exception);
        }
    }

    private static Field getField(Class cls, String fieldName) {
        try {
            return ReflectionProvider.getInstance().getField(cls, fieldName);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

