/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.zip;

import com.streamscape.lib.zip.ArchiveEntry;
import com.streamscape.lib.zip.ArchiveOutputStream;
import com.streamscape.lib.zip.ZipEncArchiveEntry;
import com.streamscape.lib.zip.zip4j.exception.ZipException;
import com.streamscape.lib.zip.zip4j.io.ZipOutputStream;
import com.streamscape.lib.zip.zip4j.model.ZipParameters;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class ZipEncArchiveOutputStream
extends ZipOutputStream
implements ArchiveOutputStream {
    private String password;

    public ZipEncArchiveOutputStream(OutputStream out, String password) {
        super(out);
        this.password = password;
    }

    @Override
    public void putArchiveEntry(ArchiveEntry entry) throws IOException {
        ZipParameters parameters = new ZipParameters();
        File entryFile = ((ZipEncArchiveEntry)entry).getEntryFile();
        parameters.setEncryptFiles(true);
        parameters.setEncryptionMethod(0);
        parameters.setPassword(this.password);
        String root = new File(((ZipEncArchiveEntry)entry).getEntryName()).getParent();
        parameters.setRootFolderInZip(root);
        try {
            this.putNextEntry(entryFile, parameters);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void closeArchiveEntry() throws IOException {
        try {
            this.closeEntry();
        }
        catch (ZipException e) {
            throw new IOException(e);
        }
    }

    @Override
    public ArchiveEntry createArchiveEntry(File inputFile, String entryName) throws IOException {
        return new ZipEncArchiveEntry(inputFile, entryName);
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
            super.close();
        }
        catch (ZipException e) {
            throw new IOException(e);
        }
    }
}

