/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.xml;

import com.streamscape.Trace;
import com.streamscape.lib.xml.Utils;
import com.streamscape.lib.xml.XMLNode;
import com.streamscape.lib.xml.XMLNodeEventListener;
import com.streamscape.omf.xml.EscapeStrategy;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLNodeEventSource
implements ContentHandler {
    private String filePath = "";
    private String xmlContent = null;
    private Locator locator = null;
    private XMLReader parser = null;
    private String encoding = "utf-8";
    private EscapeStrategy escapeStrategy = EscapeStrategy.ESCAPE_SYSTEM;
    private XNode xNodeLast;
    private XNode xNodeCurrent;
    private Stack<XNode> xPathStack = new Stack();
    private HashMap<String, XMLNode> nodeRegistry = new HashMap();
    private HashMap<String, XMLNodeEventListener> listeners = new HashMap();

    public final void initFromString(String xmlContent) throws Exception {
        this.xmlContent = xmlContent;
        this.initFromFile("");
    }

    public final void initFromFile(String filePath) throws Exception {
        this.filePath = filePath;
        if (filePath != null && filePath.length() > 0) {
            this.xmlContent = null;
        }
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            this.parser.setContentHandler(this);
            this.parser.setErrorHandler(new DefaultHandler());
            if (this.xmlContent == null) {
                Trace.logDebug(this, "Accessing XML content at path {}", Paths.get(this.filePath, new String[0]).toAbsolutePath());
            }
        }
        catch (FactoryConfigurationError ex) {
            Trace.logError(this, "SAX parser construction error '{}' at document line number: {}", ex.getMessage(), this.getLineNumber());
            throw ex;
        }
        catch (ParserConfigurationException ex) {
            Trace.logError(this, "SAX parser configuration error '{}' at document line number: {}", ex.getMessage(), this.getLineNumber());
            throw ex;
        }
        catch (SAXException ex) {
            Trace.logError(this, "SAX parser general exception '{}' at document line number: {}", ex.getMessage(), this.getLineNumber());
            throw ex;
        }
        catch (InvalidPathException ex) {
            Trace.logError(this, "SAX parser invalid path at document line number: {}", this.getLineNumber());
            throw ex;
        }
    }

    public void addEventListener(String xPath, XMLNodeEventListener listener) {
        this.addXMLNode(listener.getXPath());
        this.listeners.put(xPath, listener);
    }

    private void checkResourceFileExists() throws IOException {
        if (this.xmlContent != null) {
            return;
        }
        Path filePath = Paths.get(this.filePath, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            Trace.logError(this, "SAX parser not found resource to parse");
            throw new IOException("SAX parser not found resource to parse");
        }
    }

    public final void addXMLNode(String xPath) {
        XMLNode xNode = new XMLNode(xPath);
        this.nodeRegistry.put(xPath, xNode);
    }

    public final boolean isRegistered(String xPath) {
        String registeredPath = this.getRegisteredPath(xPath);
        return registeredPath != null;
    }

    public final XMLNode getXMLNode(String XPath) {
        return this.nodeRegistry.get(XPath);
    }

    public final void enableXMLNode(String XPath) {
        this.nodeRegistry.get(XPath).enable();
    }

    public final void disableXMLNode(String XPath) {
        this.nodeRegistry.get(XPath).disable();
    }

    public final boolean isXMLNodeEnabled(String XPath) {
        return this.nodeRegistry.get(XPath).isEnabled();
    }

    public final void invoke() throws SAXException, IOException {
        this.checkResourceFileExists();
        try (InputStreamReader reader = null;){
            InputSource source;
            if (this.xmlContent != null) {
                source = new InputSource(new StringReader(this.xmlContent));
            } else {
                reader = new FileReader(this.filePath);
                source = new InputSource(reader);
            }
            source.setEncoding(this.encoding);
            this.parser.parse(source);
        }
    }

    public void onData(XMLNode xmlNode) {
        Trace.logDebug(this, "Execute listeners on '{}'", xmlNode);
        XMLNodeEventListener listener = this.listeners.get(xmlNode.getQName());
        if (listener != null) {
            listener.onData(xmlNode);
        }
    }

    public void buildSubDocument(EventSource eventSource, String xPath, String xData) {
        Trace.logDebug(this, "Build sub document. Source: {}. XPath: {}.  XData: {}.", new Object[]{xPath, eventSource, xData});
        switch (eventSource.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isRegistered(xPath)) {
                    String registeredXPath = this.getRegisteredPath(xPath);
                    Trace.logDebug(this, "Entering registered XNode: {}", registeredXPath);
                    if (!this.isXMLNodeEnabled(registeredXPath)) {
                        Trace.logDebug(this, "Enabling registered XNode collector: {}", registeredXPath);
                        this.enableXMLNode(registeredXPath);
                    }
                }
                this.addXDataToAllRegisteredXNodes(xData);
                break;
            }
            case 2: {
                if (this.escapeStrategy == EscapeStrategy.ESCAPE_ALL || this.escapeStrategy == EscapeStrategy.ESCAPE_SYSTEM) {
                    xData = xData.replaceAll("&", "&amp;");
                    xData = xData.replaceAll("'", "&apos;");
                    xData = xData.replaceAll("\"", "&quot;");
                    xData = xData.replaceAll("<", "&lt;");
                    xData = xData.replaceAll(">", "&gt;");
                }
                if (this.escapeStrategy == EscapeStrategy.ESCAPE_ALL || this.escapeStrategy == EscapeStrategy.ESCAPE_SPECIAL) {
                    xData = Utils.escapeSpecialCharacters(xData);
                }
                this.addXDataToAllRegisteredXNodes(xData);
                break;
            }
            case 3: {
                if (this.isRegistered(xPath)) {
                    String registeredXPath = this.getRegisteredPath(xPath);
                    Trace.logDebug(this, "Exiting registered XNode: {}", registeredXPath);
                    this.addXDataToAllRegisteredXNodes(xData);
                    Trace.logDebug(this, "Disabling collector for registered XNode: {}", registeredXPath);
                    this.disableXMLNode(registeredXPath);
                    XMLNode xNode = this.getXMLNode(registeredXPath);
                    this.onData(xNode);
                    xNode.clear();
                    break;
                }
                this.addXDataToAllRegisteredXNodes(xData);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                if (!this.isRegistered(xPath)) break;
                String registeredXPath = this.getRegisteredPath(xPath);
                XMLNode xNode = this.getXMLNode(registeredXPath);
                xNode.enable();
                xNode.add(xData);
                xNode.disable();
                this.onData(xNode);
                xNode.clear();
                break;
            }
            default: {
                Trace.logError(this, "Unknown event source: {}", new Object[]{eventSource});
            }
        }
    }

    private int getLineNumber() {
        int lineNumber = -1;
        if (this.locator != null) {
            lineNumber = this.locator.getLineNumber();
        }
        return lineNumber;
    }

    private void addXDataToAllRegisteredXNodes(String xData) {
        this.nodeRegistry.values().stream().forEach(n -> n.add(xData));
    }

    private String getXNodeTreeString() {
        return this.xPathStack.stream().map(n -> n.qName + n.idx).collect(Collectors.joining("\n"));
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public final void startDocument() throws SAXException {
        Trace.logDebug(this, "Handle start of document");
        this.xNodeLast = this.xNodeCurrent = new XNode(this, "/", "[1]");
        this.xPathStack.push(this.xNodeLast);
        this.buildSubDocument(EventSource.START_DOCUMENT, "/", "/");
    }

    @Override
    public final void endDocument() throws SAXException {
        Trace.logDebug(this, "Handle end of document");
        this.xPathStack.pop();
        this.buildSubDocument(EventSource.END_DOCUMENT, "/", "/");
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
        Trace.logDebug(this, "Handle start prefix mapping: {}, URI: {}", prefix, uri);
    }

    @Override
    public final void endPrefixMapping(String prefix) throws SAXException {
        Trace.logDebug(this, "Handle end prefix mapping: {}");
    }

    @Override
    public final void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        Trace.logDebug("Handle start of element: {}", qName);
        String xPath = this.xPathStack.peek().qName + "/" + qName;
        String oldXPath = this.xNodeLast.qName;
        if (xPath.equals(oldXPath)) {
            int idx = this.xNodeLast.getIndex() + 1;
            this.xNodeCurrent = new XNode(this, xPath, "[" + idx + "]");
        } else {
            this.xNodeCurrent = new XNode(this, xPath, "[1]");
        }
        this.xPathStack.push(this.xNodeCurrent);
        this.xNodeLast = this.xNodeCurrent;
        if (Trace.isDebugEnabled(this.getClass())) {
            Trace.logDebug(this, "XPath tree:\n{}", this.getXNodeTreeString());
        }
        StringBuilder xData = new StringBuilder();
        xData.append("<").append(qName);
        if (attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                xData.append(" ").append(name).append("=\"").append(value).append("\"");
                this.buildSubDocument(EventSource.ATTRIBUTE, xPath + "/@" + name, value);
            }
        }
        xData.append(">");
        this.buildSubDocument(EventSource.START_ELEMENT, xPath, xData.toString());
    }

    @Override
    public final void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        StringBuilder xData = new StringBuilder();
        Trace.logDebug(this, "Handle end of element: {}", qName);
        xData.append("</").append(qName).append(">");
        this.xNodeLast = this.xPathStack.peek();
        this.buildSubDocument(EventSource.END_ELEMENT, this.xNodeLast.qName, xData.toString());
        this.xPathStack.pop();
        if (Trace.isDebugEnabled(this.getClass())) {
            Trace.logDebug(this, "XPath tree:\n{}", this.getXNodeTreeString());
        }
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        String xData = new String(ch, start, length);
        this.buildSubDocument(EventSource.CHARACTERS, this.xNodeCurrent.qName, xData);
    }

    @Override
    public final void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        Trace.logDebug(this, "Handle ignorable whitespace");
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
        Trace.logDebug(this, "Handle processing instruction: {}, {}", target, data);
    }

    @Override
    public final void skippedEntity(String name) throws SAXException {
        Trace.logDebug(this, "Handle skipped entity: {}", name);
    }

    public void setEscapeStrategy(EscapeStrategy strategy) {
        this.escapeStrategy = strategy;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected String getIndexedPath(String xmlPath, boolean isCurrentPath) {
        StringBuilder result = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(xmlPath, "/");
        int i = 1;
        while (tokenizer.hasMoreTokens()) {
            Object token = tokenizer.nextToken();
            if (!((String)token).endsWith("]") && !((String)token).startsWith("@")) {
                if (!isCurrentPath) {
                    token = (String)token + "[1]";
                } else if (i < this.xPathStack.size()) {
                    token = (String)token + ((XNode)this.xPathStack.elementAt((int)i)).idx;
                }
            }
            result.append('/').append((String)token);
            ++i;
        }
        return result.toString();
    }

    protected String getRegisteredPath(String xPath) {
        if (this.nodeRegistry.containsKey(xPath)) {
            return xPath;
        }
        String indexedXPath = this.getIndexedPath(xPath, true);
        for (String key : this.nodeRegistry.keySet()) {
            String registeredPath = this.getIndexedPath(key, false);
            if (!indexedXPath.equals(registeredPath)) continue;
            return key;
        }
        return null;
    }

    static enum EventSource {
        START_DOCUMENT,
        START_ELEMENT,
        CHARACTERS,
        END_ELEMENT,
        END_DOCUMENT,
        ATTRIBUTE;

    }

    final class XNode {
        public String qName;
        public String idx;

        public XNode(XMLNodeEventSource this$0, String qName, String idx) {
            this.qName = qName;
            this.idx = idx;
        }

        public int getIndex() {
            String idxString = this.idx.substring(1, this.idx.length() - 1);
            return Integer.parseInt(idxString);
        }
    }
}

