/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils.parser;

import com.streamscape.lib.utils.parser.FileParserSettings;
import com.streamscape.lib.utils.parser.Fragment;
import com.streamscape.lib.utils.parser.Image;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class StDocument {
    private String FileName;
    private String SemanticPath;
    private String DocExtension;
    private Date CreatedOn;
    private Date ModifiedOn;
    private String Author;
    private String Title;
    private int Pages;
    private int Words;
    private int Images;
    private int Paragraphs;
    private transient FileParserSettings settings;
    private List<Fragment> Content = new LinkedList<Fragment>();

    public StDocument(FileParserSettings settings) {
        this.settings = settings;
    }

    public String getFileName() {
        return this.FileName;
    }

    public void setFileName(String fileName) {
        this.FileName = fileName;
    }

    public String getSemanticPath() {
        return this.SemanticPath;
    }

    public void setSemanticPath(String semanticPath) {
        this.SemanticPath = semanticPath;
    }

    public Date getCreatedOn() {
        return this.CreatedOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.CreatedOn = createdOn;
    }

    public Date getModifiedOn() {
        return this.ModifiedOn;
    }

    public void setModifiedOn(Date modifiedOn) {
        this.ModifiedOn = modifiedOn;
    }

    public String getAuthor() {
        return this.Author;
    }

    public void setAuthor(String author) {
        this.Author = author;
    }

    public String getTitle() {
        return this.Title;
    }

    public void setTitle(String title) {
        this.Title = title;
    }

    public List<Fragment> getContent() {
        return this.Content;
    }

    public void setContent(List<Fragment> content) {
        this.Content = content;
    }

    public String getWholeText(String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (Fragment fragment : this.Content) {
            if (fragment.getTitles() != null && !fragment.getTitles().isEmpty()) {
                sb.append(delimiter).append(fragment.getTitles());
            }
            if (fragment.getText() != null && !fragment.getText().isEmpty()) {
                sb.append(delimiter).append(fragment.getText());
            }
            if (fragment.getFooters() != null && !fragment.getFooters().isEmpty()) {
                sb.append(delimiter).append(fragment.getFooters());
            }
            if (fragment.getImages() != null) {
                for (Image img : fragment.getImages()) {
                    sb.append(delimiter).append(img.getText()).append(delimiter);
                }
            }
            if (fragment.getNotes() != null && !fragment.getNotes().isEmpty()) {
                sb.append(delimiter).append(fragment.getNotes());
            }
            if (fragment.getComments() == null || fragment.getComments().isEmpty()) continue;
            sb.append(delimiter).append(fragment.getComments());
        }
        return sb.toString();
    }

    public String getWholeText() {
        return this.getWholeText("\n");
    }

    public String getDocExtension() {
        return this.DocExtension;
    }

    public void setDocExtension(String docExtension) {
        this.DocExtension = docExtension;
    }

    public int getPages() {
        return this.Pages;
    }

    public void setPages(int pages) {
        this.Pages = pages;
    }

    public int getWords() {
        return this.Words;
    }

    public void setWords(int words) {
        this.Words = words;
    }

    public int getImages() {
        return this.Images;
    }

    public void setImages(int images) {
        this.Images = images;
    }

    public int getParagraphs() {
        return this.Paragraphs;
    }

    public void setParagraphs(int paragraphs) {
        this.Paragraphs = paragraphs;
    }

    public Map asMap() {
        ArrayList fragments = new ArrayList();
        for (Fragment p : this.Content) {
            LinkedHashMap<String, Object> fragmentDto = new LinkedHashMap<String, Object>();
            fragmentDto.put("Id", p.getId());
            fragmentDto.put("Titles", p.getTitles());
            fragmentDto.put("Text", p.getText());
            fragmentDto.put("Footers", p.getFooters());
            fragmentDto.put("Notes", p.getNotes());
            fragmentDto.put("Comments", p.getComments());
            fragmentDto.put("OutlineLevel", p.getOutlineLevel());
            fragmentDto.put("Images", p.getImages());
            if (this.settings.getExcludedFields() != null) {
                List<String> exclFields = this.settings.getExcludedFields();
                for (String fName : exclFields) {
                    fragmentDto.remove(fName);
                }
            }
            fragments.add(fragmentDto);
        }
        LinkedHashMap<String, Object> stDoc = new LinkedHashMap<String, Object>();
        stDoc.put("FileName", this.FileName);
        stDoc.put("SemanticPath", this.SemanticPath);
        stDoc.put("DocExtension", this.DocExtension);
        stDoc.put("CreatedOn", this.CreatedOn);
        stDoc.put("ModifiedOn", this.ModifiedOn);
        stDoc.put("Author", this.Author);
        stDoc.put("Title", this.Title);
        stDoc.put("Pages", this.Pages);
        stDoc.put("Words", this.Words);
        stDoc.put("Images", this.Images);
        stDoc.put("Paragraphs", this.Paragraphs);
        stDoc.put("Content", fragments);
        return stDoc;
    }
}

