/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils.parser;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.xslf.usermodel.XSLFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;

public class PictureData {
    private byte[] data;
    private String fileName;
    private int id;

    public PictureData(byte[] data, String fileName) {
        this.data = data;
        this.fileName = fileName;
    }

    public PictureData(byte[] data, String fileName, int id) {
        this.data = data;
        this.fileName = fileName;
        this.id = id;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public static List<PictureData> XSLFtoPictureData(List<XSLFPictureData> pdlist) {
        return pdlist.stream().map(pd -> new PictureData(pd.getData(), pd.getFileName())).collect(Collectors.toList());
    }

    public static List<PictureData> XWPFtoPictureData(List<XWPFPictureData> pdlist) {
        return pdlist.stream().map(pd -> new PictureData(pd.getData(), pd.getFileName())).collect(Collectors.toList());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

