/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils.parser;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.lib.utils.parser.FileParser;
import com.streamscape.lib.utils.parser.FileParserSettings;
import com.streamscape.lib.utils.parser.Fragment;
import com.streamscape.lib.utils.parser.Image;
import com.streamscape.lib.utils.parser.PictureData;
import com.streamscape.lib.utils.parser.StDocument;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.hslf.model.HeadersFooters;
import org.apache.poi.hslf.usermodel.HSLFPictureShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTable;
import org.apache.poi.hslf.usermodel.HSLFTableCell;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFComments;
import org.apache.poi.xslf.usermodel.XSLFNotes;
import org.apache.poi.xslf.usermodel.XSLFPictureData;
import org.apache.poi.xslf.usermodel.XSLFPictureShape;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.poi.xslf.usermodel.XSLFTableCell;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.presentationml.x2006.main.CTComment;

public class POIParser
extends FileParser {
    private String NEW_LINE_SEPARATOR_TYPE = "nl";
    private String SPACE_SEPARATOR_TYPE = "space";
    private String ITEM_SEPARATOR_TYPE = "item";

    public POIParser(Session session, InputStream is, String fileName, FileParserSettings options) {
        super(session, is, fileName, options);
    }

    @Override
    public StDocument parse() throws Exception {
        if (this.type.equals(PPTX_TYPE)) {
            return this.parsePPTX();
        }
        if (this.type.equals(PPT_TYPE)) {
            return this.parsePPT();
        }
        if (this.type.equals(DOCX_TYPE)) {
            return this.parseDOCX();
        }
        return null;
    }

    private static String getTitleLvl(XWPFDocument doc, XWPFParagraph para) {
        int lvl = POIParser._getTitleLvl(doc, para);
        return lvl == -1 ? "Paragraph" : "h" + (lvl + 1);
    }

    private static int _getTitleLvl(XWPFDocument doc, XWPFParagraph para) {
        int titleLvl = -1;
        try {
            if (para.getCTP().getPPr().getOutlineLvl() != null) {
                return para.getCTP().getPPr().getOutlineLvl().getVal().intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (doc.getStyles().getStyle(para.getStyle()).getCTStyle().getPPr().getOutlineLvl() != null) {
                return doc.getStyles().getStyle(para.getStyle()).getCTStyle().getPPr().getOutlineLvl().getVal().intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (doc.getStyles().getStyle(doc.getStyles().getStyle(para.getStyle()).getCTStyle().getBasedOn().getVal()).getCTStyle().getPPr().getOutlineLvl() != null) {
                String styleName = doc.getStyles().getStyle(para.getStyle()).getCTStyle().getBasedOn().getVal();
                return doc.getStyles().getStyle(styleName).getCTStyle().getPPr().getOutlineLvl().getVal().intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return titleLvl;
    }

    private StDocument parseDOCX() throws IOException {
        XWPFDocument doc = new XWPFDocument(this.is);
        StDocument stdoc = new StDocument(this.settings);
        POIXMLProperties.CoreProperties props = doc.getProperties().getCoreProperties();
        stdoc.setAuthor(props.getCreator());
        stdoc.setCreatedOn(props.getCreated());
        stdoc.setModifiedOn(props.getModified());
        stdoc.setTitle(props.getTitle());
        POIXMLProperties.ExtendedProperties extProps = doc.getProperties().getExtendedProperties();
        stdoc.setPages(extProps.getPages());
        stdoc.setWords(extProps.getWords());
        stdoc.setParagraphs(doc.getParagraphs().size());
        stdoc.setImages(doc.getAllPictures().size());
        Map<String, Image> images = this.processPictures(PictureData.XWPFtoPictureData(doc.getAllPictures()));
        List<String> levels = this.settings.getLevelWindow();
        if (levels != null && !levels.isEmpty()) {
            for (String windowLevel : levels) {
                LevelType.parse(windowLevel);
            }
            List pars = doc.getParagraphs().stream().filter(f -> f.getText() != null && !f.getText().isEmpty()).collect(Collectors.toList());
            int idx = 1;
            AtomicInteger imageIdx = new AtomicInteger(1);
            List outLvls = pars.stream().map(p -> POIParser.getTitleLvl(doc, p)).collect(Collectors.toList());
            int i = 0;
            while (i < outLvls.size()) {
                Object lvl;
                ArrayList<LevelNode> intersec = new ArrayList<LevelNode>();
                for (int j = 0; j < levels.size(); ++j) {
                    String outLvl = (String)outLvls.get(i + j);
                    lvl = levels.get(j);
                    LevelType levelType = LevelType.parse((String)lvl);
                    if (levelType.isParagraph) {
                        lvl = "Paragraph";
                    }
                    if (!outLvl.equals(lvl)) {
                        intersec.clear();
                        break;
                    }
                    LevelNode levelNode = new LevelNode();
                    if (levelType.isParagraph) {
                        ArrayList<Integer> prepIdx = new ArrayList<Integer>();
                        for (int k = i + j; k <= outLvls.size() - 1 && ((String)outLvls.get(k)).equals("Paragraph"); ++k) {
                            prepIdx.add(k);
                        }
                        if (levelType.type.equals((Object)LevelType.Type.SINGLE)) {
                            if (levelType.listIndex <= prepIdx.size()) {
                                levelNode.add((Integer)prepIdx.get(levelType.listIndex - 1));
                            }
                        } else if (levelType.type.equals((Object)LevelType.Type.MERGE)) {
                            levelNode.type = LevelNode.Type.MERGE;
                            levelNode.addAll(prepIdx);
                        } else {
                            levelNode.addAll(prepIdx);
                        }
                    } else {
                        levelNode.add(i + j);
                    }
                    intersec.add(levelNode);
                }
                if (!intersec.isEmpty()) {
                    for (LevelNode levelNode : intersec) {
                        if (levelNode.type.equals((Object)LevelNode.Type.SEPARATE)) {
                            lvl = levelNode.indexes.iterator();
                            while (lvl.hasNext()) {
                                int parsIdx = (Integer)lvl.next();
                                Fragment fragment = new Fragment(this.settings);
                                fragment.setId(idx);
                                fragment.setText(((XWPFParagraph)pars.get(parsIdx)).getText());
                                fragment.setOutlineLevel(POIParser.getTitleLvl(doc, (XWPFParagraph)pars.get(parsIdx)));
                                this.populateImages((XWPFParagraph)pars.get(parsIdx), fragment, images, imageIdx);
                                stdoc.getContent().add(fragment);
                                ++i;
                            }
                            continue;
                        }
                        Fragment baseFragment = new Fragment(this.settings);
                        baseFragment.setId(idx);
                        baseFragment.setOutlineLevel("Paragraph");
                        for (int parsIdx : levelNode.indexes) {
                            Fragment fragment = new Fragment(this.settings);
                            fragment.setText(((XWPFParagraph)pars.get(parsIdx)).getText());
                            fragment.setOutlineLevel(POIParser.getTitleLvl(doc, (XWPFParagraph)pars.get(parsIdx)));
                            this.populateImages((XWPFParagraph)pars.get(parsIdx), fragment, images, imageIdx);
                            ++i;
                            baseFragment.merge(fragment);
                        }
                        stdoc.getContent().add(baseFragment);
                    }
                    ++idx;
                    continue;
                }
                ++i;
            }
        } else {
            int idx = 1;
            AtomicInteger ai = new AtomicInteger(1);
            for (XWPFParagraph ph : doc.getParagraphs()) {
                Fragment fragment = new Fragment(this.settings);
                fragment.setId(idx);
                fragment.setText(ph.getText());
                fragment.setOutlineLevel(POIParser.getTitleLvl(doc, ph));
                this.populateImages(ph, fragment, images, ai);
                if (!this.isPageAddedToDocx(fragment)) continue;
                stdoc.getContent().add(fragment);
                ++idx;
            }
        }
        return stdoc;
    }

    private boolean isPageAddedToDocx(Fragment fragment) {
        return !fragment.getText().isEmpty() || !fragment.getImages().isEmpty();
    }

    private void populateImages(XWPFParagraph ph, Fragment fragment, Map<String, Image> imageMap, AtomicInteger ai) {
        if (imageMap == null) {
            return;
        }
        for (XWPFRun run : ph.getRuns()) {
            for (XWPFPicture pict : run.getEmbeddedPictures()) {
                XWPFPictureData pictData = pict.getPictureData();
                Image image = imageMap.get(pictData.getFileName());
                if (image == null) continue;
                image.setId(ai.getAndIncrement());
                fragment.getImages().add(image);
            }
        }
    }

    public StDocument parsePPT() throws IOException {
        StDocument structure = new StDocument(this.settings);
        HSLFSlideShow hss = new HSLFSlideShow(this.is);
        int idx = 1;
        for (HSLFSlide hslfSlide : hss.getSlides()) {
            Fragment slide = new Fragment(this.settings);
            HeadersFooters headersFooters = hslfSlide.getHeadersFooters();
            slide.setTitles(hslfSlide.getTitle());
            slide.setFooters(headersFooters.getFooterText());
            slide.setId(idx);
            StringBuilder content = new StringBuilder();
            for (HSLFShape hslfShape : hslfSlide.getShapes()) {
                if (hslfShape instanceof HSLFTextShape) {
                    String text = ((HSLFTextShape)hslfShape).getText();
                    content.append(text);
                    continue;
                }
                if (hslfShape instanceof HSLFTable) {
                    System.out.println("HSLFTable");
                    int rowSize = ((HSLFTable)hslfShape).getNumberOfRows();
                    int columnSize = ((HSLFTable)hslfShape).getNumberOfColumns();
                    for (int rowNum = 0; rowNum < rowSize; ++rowNum) {
                        for (int columnNum = 0; columnNum < columnSize; ++columnNum) {
                            HSLFTableCell cell = ((HSLFTable)hslfShape).getCell(rowNum, columnNum);
                            if (cell == null) continue;
                            content.append(cell.getText());
                        }
                    }
                    continue;
                }
                if (!(hslfShape instanceof HSLFPictureShape)) continue;
            }
            slide.setText(content.toString());
            structure.getContent().add(slide);
            ++idx;
        }
        return structure;
    }

    private String getPPTSeparatorString(String type) throws UtilitiesException {
        if (type.equals(this.NEW_LINE_SEPARATOR_TYPE)) {
            return "\n";
        }
        if (type.equals(this.SPACE_SEPARATOR_TYPE)) {
            return " ";
        }
        if (type.equals(this.ITEM_SEPARATOR_TYPE)) {
            String itemOption = (String)this.settings.getOption(FileParserSettings.ESC_PPT_ITEM_OPTION);
            return itemOption == null ? "" : itemOption;
        }
        throw new UtilitiesException("Separator type '" + type + "' does not exist.");
    }

    public StDocument parsePPTX() throws Exception {
        StDocument structure = new StDocument(this.settings);
        XMLSlideShow xss = new XMLSlideShow(this.is);
        POIXMLProperties.CoreProperties props = xss.getProperties().getCoreProperties();
        structure.setAuthor(props.getCreator());
        structure.setCreatedOn(props.getCreated());
        structure.setModifiedOn(props.getModified());
        structure.setTitle(props.getTitle());
        POIXMLProperties.ExtendedProperties exProps = xss.getProperties().getExtendedProperties();
        structure.setPages(xss.getSlides().size());
        structure.setWords(exProps.getWords());
        structure.setImages(xss.getPictureData().size());
        structure.setParagraphs(exProps.getParagraphs());
        Map<String, Image> images = this.processPictures(PictureData.XSLFtoPictureData(xss.getPictureData()));
        int idx = 1;
        for (XSLFSlide xslfSlide : xss.getSlides()) {
            Fragment slide = new Fragment(this.settings);
            slide.setId(idx);
            LinkedList<String> titles = new LinkedList<String>();
            StringBuilder textContent = new StringBuilder();
            LinkedList<String> footers = new LinkedList<String>();
            int imIdx = 1;
            for (XSLFShape xslfShape : xslfSlide.getShapes()) {
                XSLFPictureData pictData;
                Image image;
                if (xslfShape instanceof XSLFTextShape) {
                    String shapeName = xslfShape.getShapeName();
                    String text = ((XSLFTextShape)xslfShape).getText();
                    if (StringUtils.containsIgnoreCase((CharSequence)shapeName, (CharSequence)"Title")) {
                        titles.add(text);
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((CharSequence)shapeName, (CharSequence)"footer")) {
                        footers.add(text);
                        continue;
                    }
                    textContent.append(text).append("\n");
                    continue;
                }
                if (xslfShape instanceof XSLFTable) {
                    int rowSize = ((XSLFTable)xslfShape).getNumberOfRows();
                    int columnSize = ((XSLFTable)xslfShape).getNumberOfColumns();
                    String tableSepType = (String)this.settings.getOption(FileParserSettings.ESC_PPT_TABLE_OPTION, this.SPACE_SEPARATOR_TYPE);
                    String tablePrefix = this.getPPTSeparatorString(tableSepType);
                    if (rowSize > 0) {
                        textContent.append(tablePrefix);
                    }
                    String rowSepType = (String)this.settings.getOption(FileParserSettings.ESC_PPT_TABLE_ROW_OPTION, this.SPACE_SEPARATOR_TYPE);
                    String rowPrefix = this.getPPTSeparatorString(rowSepType);
                    String cellSepType = (String)this.settings.getOption(FileParserSettings.ESC_PPT_TABLE_CELL_OPTION, this.SPACE_SEPARATOR_TYPE);
                    String cellPrefix = this.getPPTSeparatorString(cellSepType);
                    for (int rowNum = 0; rowNum < rowSize; ++rowNum) {
                        StringBuilder rowContent = new StringBuilder();
                        for (int columnNum = 0; columnNum < columnSize; ++columnNum) {
                            XSLFTableCell cell = ((XSLFTable)xslfShape).getCell(rowNum, columnNum);
                            if (cell == null) continue;
                            rowContent.append(cellPrefix);
                            rowContent.append(cell.getText());
                        }
                        rowContent.append(rowPrefix);
                        textContent.append((CharSequence)rowContent);
                    }
                    continue;
                }
                if (!(xslfShape instanceof XSLFPictureShape) || images == null || (image = images.get((pictData = ((XSLFPictureShape)xslfShape).getPictureData()).getFileName())) == null || image.getText().isEmpty()) continue;
                image.setId(imIdx++);
                slide.getImages().add(image);
            }
            if (!titles.isEmpty()) {
                slide.setTitles(String.join((CharSequence)"\n", titles));
            }
            if (textContent.length() != 0) {
                slide.setText(textContent.toString());
            }
            if (!footers.isEmpty()) {
                slide.setFooters(String.join((CharSequence)"\n", footers));
            }
            slide.setComments(this.getXSlideComments(xslfSlide));
            slide.setNotes(this.getXNotes(xslfSlide));
            structure.getContent().add(slide);
            ++idx;
        }
        return structure;
    }

    private String getXSlideComments(XSLFSlide xslfSlide) {
        LinkedList<String> commentsList = new LinkedList<String>();
        XSLFComments comments = xslfSlide.getComments();
        if (comments != null) {
            for (CTComment comment : comments.getCTCommentsList().getCmArray()) {
                commentsList.add(comment.getText());
            }
        }
        if (!commentsList.isEmpty()) {
            return String.join((CharSequence)"\n", commentsList);
        }
        return null;
    }

    private String getXNotes(XSLFSlide xslfSlide) {
        LinkedList<String> noteList = new LinkedList<String>();
        XSLFNotes notes = xslfSlide.getNotes();
        if (notes != null) {
            for (XSLFShape s : notes) {
                XSLFTextShape ts = (XSLFTextShape)s;
                String text = ts.getText();
                if (text.isEmpty() || text.matches("^\\d+$")) continue;
                noteList.add(text);
            }
        }
        if (!noteList.isEmpty()) {
            return String.join((CharSequence)"\n", noteList);
        }
        return null;
    }

    private Map<String, Image> processPictures(List<PictureData> pictures) {
        if (!this.settings.imageProcessingAvailable()) {
            return null;
        }
        HashMap<String, Image> images = new HashMap<String, Image>();
        int threadNum = this.settings.getImageParallelDegree();
        ExecutorService executorService = Executors.newFixedThreadPool(threadNum);
        LinkedList<Future<Image>> futures = new LinkedList<Future<Image>>();
        Integer imageMinSize = this.settings.getImageMinSize();
        for (PictureData pictureData : pictures) {
            if (imageMinSize != null && pictureData.getData().length < imageMinSize) continue;
            futures.add(executorService.submit(() -> {
                String imageText = this.processImage(pict.getData());
                Image img = new Image(this.settings);
                img.setFile(pict.getFileName());
                img.setText(imageText);
                return img;
            }));
        }
        for (Future future : futures) {
            Image img;
            try {
                img = (Image)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                continue;
            }
            if (img == null) continue;
            images.put(img.getFile(), img);
        }
        executorService.shutdown();
        return images;
    }

    public static class LevelType {
        boolean isParagraph;
        Type type;
        int listIndex;

        public LevelType(boolean isParagraph, Type type, int listIndex) {
            this.isParagraph = isParagraph;
            this.type = type;
            this.listIndex = listIndex;
        }

        public static LevelType parse(String stype) {
            String singleRegex = "Paragraph\\[(\\d+)\\]";
            boolean isPar = false;
            int listIndex = 0;
            Type type = null;
            if (stype.equals("Paragraph[*]")) {
                isPar = true;
                type = Type.MULTI;
            } else if (stype.equals("Paragraph+")) {
                isPar = true;
                type = Type.MERGE;
            } else if (stype.matches(singleRegex)) {
                isPar = true;
                type = Type.SINGLE;
                Pattern reg = Pattern.compile(singleRegex);
                Matcher res = reg.matcher(stype);
                res.find();
                listIndex = Integer.valueOf(res.group(1));
            } else if (stype.matches("h\\d+")) {
                type = Type.HEADING;
            } else {
                throw new DataspaceException("Wrong level:" + stype);
            }
            return new LevelType(isPar, type, listIndex);
        }

        static enum Type {
            HEADING,
            SINGLE,
            MULTI,
            MERGE;

        }
    }

    public static class LevelNode {
        Type type = Type.SEPARATE;
        List<Integer> indexes = new ArrayList<Integer>();

        public LevelNode() {
        }

        public LevelNode(Type type, List<Integer> indexes) {
            this.type = type;
            this.indexes = indexes;
        }

        public void add(Integer item) {
            this.indexes.add(item);
        }

        public void addAll(List<Integer> items) {
            this.indexes.addAll(items);
        }

        static enum Type {
            SEPARATE,
            MERGE;

        }
    }
}

