/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils.parser;

import com.streamscape.ds.session.Session;
import com.streamscape.lib.utils.parser.FileParser;
import com.streamscape.lib.utils.parser.FileParserSettings;
import com.streamscape.lib.utils.parser.Fragment;
import com.streamscape.lib.utils.parser.Image;
import com.streamscape.lib.utils.parser.PictureData;
import com.streamscape.lib.utils.parser.StDocument;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.multipdf.Splitter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.text.PDFTextStripper;

public class PDFBoxParser
extends FileParser {
    public PDFBoxParser(Session session, InputStream is, String type, FileParserSettings settings) {
        super(session, is, type, settings);
    }

    @Override
    public StDocument parse() throws IOException {
        StDocument structure = new StDocument(this.settings);
        PDDocument document = PDDocument.load((InputStream)this.is);
        PDDocumentInformation info = document.getDocumentInformation();
        structure.setAuthor(info.getCreator());
        structure.setTitle(info.getTitle());
        if (info.getCreationDate() != null) {
            structure.setCreatedOn(info.getCreationDate().getTime());
        }
        if (info.getModificationDate() != null) {
            structure.setModifiedOn(info.getModificationDate().getTime());
        }
        Splitter splitter = new Splitter();
        List Pages = splitter.split(document);
        structure.setPages(Pages.size());
        ListIterator iterator = Pages.listIterator();
        PDFTextStripper pdfStripper = new PDFTextStripper();
        int idx = 1;
        int imIdx = 0;
        ArrayList<PictureData> pictureDataList = new ArrayList<PictureData>();
        while (iterator.hasNext()) {
            List<RenderedImage> images;
            Fragment fragment = new Fragment(this.settings);
            PDDocument pd = (PDDocument)iterator.next();
            if (this.settings.imageProcessingAvailable() && (images = this.getImagesFromPDF(pd)) != null) {
                for (RenderedImage image : images) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write(image, "png", baos);
                    byte[] bytes = baos.toByteArray();
                    pictureDataList.add(new PictureData(bytes, null, ++imIdx));
                    Image img = new Image(this.settings);
                    img.setId(imIdx);
                    fragment.getImages().add(img);
                }
            }
            fragment.setId(idx);
            fragment.setText(pdfStripper.getText(pd));
            structure.getContent().add(fragment);
            ++idx;
        }
        document.close();
        structure.setImages(imIdx);
        Map<Integer, Image> processedImages = this.processPictures(pictureDataList);
        if (processedImages != null) {
            for (Fragment fragment : structure.getContent()) {
                List<Image> filteredIm = fragment.getImages().stream().map(im -> {
                    if (processedImages.containsKey(im.getId())) {
                        im.setText(((Image)processedImages.get(im.getId())).getText());
                    }
                    return im;
                }).filter(im -> im.getText() != null && !im.getText().isEmpty()).collect(Collectors.toList());
                fragment.setImages(filteredIm);
            }
        }
        return structure;
    }

    public List<RenderedImage> getImagesFromPDF(PDDocument document) throws IOException {
        ArrayList<RenderedImage> images = new ArrayList<RenderedImage>();
        for (PDPage page : document.getPages()) {
            images.addAll(this.getImagesFromResources(page.getResources()));
        }
        return images;
    }

    private List<RenderedImage> getImagesFromResources(PDResources resources) throws IOException {
        ArrayList<RenderedImage> images = new ArrayList<RenderedImage>();
        if (resources != null && resources.getXObjectNames() != null) {
            for (COSName xObjectName : resources.getXObjectNames()) {
                PDXObject xObject = resources.getXObject(xObjectName);
                if (xObject instanceof PDFormXObject) {
                    images.addAll(this.getImagesFromResources(((PDFormXObject)xObject).getResources()));
                    continue;
                }
                if (!(xObject instanceof PDImageXObject)) continue;
                images.add(((PDImageXObject)xObject).getImage());
            }
        }
        return images;
    }

    private Map<Integer, Image> processPictures(List<PictureData> pictures) {
        if (!this.settings.imageProcessingAvailable()) {
            return null;
        }
        HashMap<Integer, Image> images = new HashMap<Integer, Image>();
        int threadNum = this.settings.getImageParallelDegree();
        ExecutorService executorService = Executors.newFixedThreadPool(threadNum);
        LinkedList<Future<Image>> futures = new LinkedList<Future<Image>>();
        Integer imageMinSize = this.settings.getImageMinSize();
        for (PictureData pictureData : pictures) {
            if (imageMinSize != null && pictureData.getData().length < imageMinSize) continue;
            futures.add(executorService.submit(() -> {
                String text = this.processImage(pict.getData());
                Image img = new Image(this.settings);
                img.setFile(pict.getFileName());
                img.setText(text);
                img.setId(pict.getId());
                return img;
            }));
        }
        for (Future future : futures) {
            Image img;
            try {
                img = (Image)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                continue;
            }
            if (img == null) continue;
            images.put(img.getId(), img);
        }
        executorService.shutdown();
        return images;
    }
}

