/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils.parser;

import com.streamscape.lib.utils.parser.FileParserSettings;
import com.streamscape.lib.utils.parser.FileParserUtil;
import com.streamscape.lib.utils.parser.Image;
import java.util.LinkedList;
import java.util.List;

public class Fragment {
    private int Id;
    private String Titles;
    private String Text;
    private String Footers;
    private String Notes;
    private String Comments;
    private String OutlineLevel;
    private List<Image> Images = new LinkedList<Image>();
    private transient FileParserSettings settings;

    public Fragment(FileParserSettings settings) {
        this.settings = settings;
    }

    public Fragment(FileParserSettings settings, int idx, String text, String level) {
        this(settings);
        this.setId(idx);
        this.setText(text);
        this.setOutlineLevel(level);
    }

    public int getId() {
        return this.Id;
    }

    public void setId(int id) {
        this.Id = id;
    }

    public String getTitles() {
        return this.Titles;
    }

    public void setTitles(String titles) {
        this.Titles = FileParserUtil.postProcess(titles, this.settings);
    }

    public String getText() {
        return this.Text;
    }

    public void setText(String text) {
        this.Text = FileParserUtil.postProcess(text, this.settings);
    }

    public String getFooters() {
        return this.Footers;
    }

    public void setFooters(String footers) {
        this.Footers = FileParserUtil.postProcess(footers, this.settings);
    }

    public String getNotes() {
        return this.Notes;
    }

    public void setNotes(String notes) {
        this.Notes = FileParserUtil.postProcess(notes, this.settings);
    }

    public String getComments() {
        return this.Comments;
    }

    public void setComments(String comments) {
        this.Comments = FileParserUtil.postProcess(comments, this.settings);
    }

    public String getOutlineLevel() {
        return this.OutlineLevel;
    }

    public void setOutlineLevel(String outlineLevel) {
        this.OutlineLevel = outlineLevel;
    }

    public List<Image> getImages() {
        return this.Images;
    }

    public void setImages(List<Image> images) {
        this.Images = images;
    }

    public boolean isEmpty() {
        return (this.Text == null || this.Text.isEmpty()) && this.Images.isEmpty();
    }

    public void merge(Fragment fragment) {
        this.Titles = this.concat(this.Titles, fragment.Titles);
        this.Footers = this.concat(this.Footers, fragment.Footers);
        this.Notes = this.concat(this.Notes, fragment.Notes);
        this.Comments = this.concat(this.Comments, fragment.Comments);
        this.Text = this.concat(this.Text, fragment.Text);
        this.Images.addAll(fragment.Images);
    }

    private String concat(String str1, String str2) {
        Object res = "";
        if (str1 == null && str2 == null) {
            return null;
        }
        if (str1 != null) {
            res = (String)res + str1;
        }
        if (str2 != null) {
            if (!((String)res).isEmpty()) {
                res = (String)res + "\n";
            }
            res = (String)res + str2;
        }
        return res;
    }
}

