/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils.parser;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.lib.utils.parser.FileParserSettings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;

public class FileParserUtil {
    public static InputStream retrieveStreamFromSource(Session session, Object source) {
        InputStream inputStream;
        if (source instanceof BlobDataID) {
            inputStream = ((BlobDataID)source).getBinaryStream(session);
        } else if (source instanceof FlobDataID) {
            inputStream = ((FlobDataID)source).getBlobAdapter().getBinaryStream(session);
        } else if (source instanceof BinaryData) {
            inputStream = new ByteArrayInputStream(((BinaryData)source).getBytes());
        } else if (source instanceof byte[]) {
            inputStream = new ByteArrayInputStream((byte[])source);
        } else {
            throw new DataspaceException("Unsupported type for source. Should be binary, flob or blob.");
        }
        return inputStream;
    }

    public static String cleanText(String text) {
        text = text.replace("\n", " ");
        text = text.replaceAll("\\s+", " ");
        return text;
    }

    public static String forceGrammar(String text) {
        CharSequence[] lookBehindSymbolArr = new CharSequence[]{".", ",", ":", "?", "|", "-", "!", ".)"};
        String lookBehindSymbols = "([.,:?|\\-!]|\\.\\))";
        text = text.replace("\r\n", "\n");
        text = text.replaceAll("\\s+\n", "\n");
        text = text.replaceAll("\\s+$", "");
        text = text.replaceAll("\n+", "\n");
        text = StringUtils.removeStart((String)text, (String)"\n");
        text = FileParserUtil.combineSingleWords(text);
        text = text.replaceAll("(?<!" + lookBehindSymbols + ")\n", ".\n");
        if (!(text = StringUtils.removeEnd((String)text, (String)"\n")).isEmpty()) {
            text = StringUtils.appendIfMissing((String)text, (CharSequence)".", (CharSequence[])lookBehindSymbolArr);
        }
        return text;
    }

    public static String combineSingleWords(String text) {
        return text.replaceAll("\n(\\w+)\n", " $1 ");
    }

    public static String postProcess(String text, FileParserSettings settings) {
        if (text == null) {
            return null;
        }
        if (settings.isForceGrammar()) {
            text = FileParserUtil.forceGrammar(text);
        }
        if (!settings.isPreserveStructure()) {
            return FileParserUtil.cleanText(text);
        }
        return text;
    }
}

