/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils.parser;

import com.streamscape.lib.utils.UtilitiesException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileParserSettings {
    public static String ESC_PPT_ITEM_OPTION = "esc.microsoft.ppt.item";
    public static String ESC_PPT_TABLE_OPTION = "esc.microsoft.ppt.table";
    public static String ESC_PPT_TABLE_ROW_OPTION = "esc.microsoft.ppt.table.row";
    public static String ESC_PPT_TABLE_CELL_OPTION = "esc.microsoft.ppt.table.cell";
    public static String ESC_PPT_SHAPE_OPTION = "esc.microsoft.ppt.shape";
    public static String FILE_NAME = "file.name";
    public static String FILE_DATE = "file.date";
    public static String CONTENT_LEVELS = "content.levels";
    public static String PARSER_JSON_EXCLUDED_FIELDS = "json.excluded.fields";
    public static String IMAGE_OCREADER = "image.ocreader";
    public static String IMAGE_PROCESS = "image.process";
    public static String IMAGE_MINSIZE = "image.minSize";
    public static String IMAGE_PROCESS_PREFIX = "image.process.";
    public static String IMAGE_PARALLEL_DEGREE = "image.parallel.degree";
    public static int DEFAULT_PARALLEL_DEGREE = 4;
    private static List<String> availableOptions = Arrays.asList(ESC_PPT_ITEM_OPTION, ESC_PPT_TABLE_OPTION, ESC_PPT_TABLE_ROW_OPTION, ESC_PPT_TABLE_CELL_OPTION, ESC_PPT_SHAPE_OPTION, FILE_NAME, FILE_DATE, PARSER_JSON_EXCLUDED_FIELDS, CONTENT_LEVELS, IMAGE_OCREADER, IMAGE_PROCESS, IMAGE_PARALLEL_DEGREE, IMAGE_MINSIZE);
    private boolean preserveStructure;
    private boolean forceGrammar;
    private Map<String, Object> options = new HashMap<String, Object>();

    public boolean isPreserveStructure() {
        return this.preserveStructure;
    }

    public void setPreserveStructure(boolean preserveStructure) {
        this.preserveStructure = preserveStructure;
    }

    public void addOptions(Map<String, Object> opts) throws UtilitiesException {
        if (opts != null) {
            for (String opt : opts.keySet()) {
                if (availableOptions.contains(opt)) {
                    this.options.put(opt, opts.get(opt));
                    continue;
                }
                throw new UtilitiesException("Option " + opt + " does not exist.");
            }
        }
    }

    public Object getOption(String option, Object defaultVal) {
        Object val = this.options.get(option);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public Object getOption(String option) {
        return this.getOption(option, null);
    }

    public List<String> getExcludedFields() {
        return (List)this.getOption(PARSER_JSON_EXCLUDED_FIELDS);
    }

    public List<String> getLevelWindow() {
        List option = (List)this.getOption(CONTENT_LEVELS);
        if (option == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (Object item : option) {
            res.add(String.valueOf(item));
        }
        return res;
    }

    public boolean isForceGrammar() {
        return this.forceGrammar;
    }

    public void setForceGrammar(boolean forceGrammar) {
        this.forceGrammar = forceGrammar;
    }

    public boolean imageProcessingAvailable() {
        Boolean imProc = (Boolean)this.getOption(IMAGE_PROCESS);
        boolean imageProcess = imProc != null && imProc != false;
        return imageProcess && this.getImageProcessor() != null;
    }

    public String getImageProcessor() {
        return (String)this.getOption(IMAGE_OCREADER);
    }

    public int getImageParallelDegree() {
        return (Integer)this.getOption(IMAGE_PARALLEL_DEGREE, DEFAULT_PARALLEL_DEGREE);
    }

    public Integer getImageMinSize() {
        return (Integer)this.getOption(IMAGE_MINSIZE, null);
    }
}

