/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils.parser;

import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.utils.parser.FileParserSettings;
import com.streamscape.lib.utils.parser.StDocument;
import com.streamscape.sef.accessor.FabricComponentAccessor;
import com.streamscape.sef.dispatcher.AccessorParentSessionLink;
import com.streamscape.sef.moderator.ModeratorUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.regex.Pattern;

abstract class FileParser {
    public static String DOCX_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static String PPT_TYPE = "application/vnd.ms-powerpoint";
    public static String PPTX_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    public static String PDF_TYPE = "application/pdf";
    private static String OCREADER_TYPE = "OCReader";
    protected InputStream is;
    protected String type;
    protected Session session;
    protected FileParserSettings settings;

    public FileParser(Session session, InputStream is, String type, FileParserSettings settings) {
        this.is = is;
        this.type = type;
        this.session = session;
        this.settings = settings;
    }

    public abstract StDocument parse() throws Exception;

    protected String processImage(byte[] bytes) {
        String imageProcessor = this.settings.getImageProcessor();
        if (imageProcessor != null) {
            try (FabricComponentAccessor accessor = null;){
                String componentType = OCREADER_TYPE;
                String componentName = ModeratorUtils.extractComponentNameName(imageProcessor);
                DataspaceSchema dataspace = this.session.dataspaceStore.schemaManager.findSchema(this.session.currentDataspace.name);
                accessor = dataspace.getAccessorsPool().createServiceAccessor(null, componentType, componentName);
                ((AccessorParentSessionLink)((Object)accessor)).setParentSession(this.session);
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("preprocess", "type,Grayscale,negate,,define,morphology:compose=darken,morphology,Thinning Rectangle:1x80+0+0<,negate,");
                Object res = accessor.invokeServiceRequest("scan", bytes, props, 500000L);
                if (res instanceof String) {
                    String string = this.cleanImageText((String)res);
                    return string;
                }
            }
        }
        return null;
    }

    private String cleanImageText(String text) {
        if (text == null) {
            return null;
        }
        String rgx = "~#^*{}[]|/<>=_`";
        text = text.replaceAll(Pattern.quote(rgx), "");
        text = text.replaceAll("(\n[\u00a9%><]+)|(\\(C\\))\\s", "\n");
        return text;
    }
}

