/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils.html.textextractor;

import com.streamscape.lib.utils.html.textextractor.HtmlHandler;
import com.streamscape.lib.utils.html.textextractor.XHTMLDowngradeHandler;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.config.LoadErrorHandler;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.DefaultEncodingDetector;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.html.HtmlEncodingDetector;
import org.apache.tika.parser.html.HtmlMapper;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.sax.WriteOutContentHandler;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.ccil.cowan.tagsoup.Schema;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class TikaHtmlParser
extends HtmlParser {
    public String parse(String html) throws Exception {
        html = html.replace("&nbsp;", " ");
        WriteOutContentHandler handler = new WriteOutContentHandler(-1);
        ArrayList<Class<HtmlEncodingDetector>> exclude = new ArrayList<Class<HtmlEncodingDetector>>();
        exclude.add(HtmlEncodingDetector.class);
        DefaultEncodingDetector detector = new DefaultEncodingDetector(new ServiceLoader(DefaultEncodingDetector.class.getClassLoader()), exclude);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(html.getBytes());){
            String string;
            try (AutoDetectReader reader = new AutoDetectReader((InputStream)new CloseShieldInputStream(stream), new Metadata(), (EncodingDetector)detector);){
                ParseContext context = new ParseContext();
                Parser parser = new Parser();
                Schema schema = (Schema)context.get(Schema.class, (Object)new HTMLSchema());
                parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", schema);
                parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons", true);
                HtmlMapper mapper = (HtmlMapper)context.get(HtmlMapper.class, (Object)new HtmlParserMapper());
                parser.setContentHandler((ContentHandler)((Object)new XHTMLDowngradeHandler((ContentHandler)((Object)new HtmlHandler(mapper, (ContentHandler)handler, new Metadata(), context, false)))));
                parser.parse(reader.asInputSource());
                string = handler.toString();
            }
            return string;
        }
    }

    private static class AutoDetectReader
    extends BufferedReader {
        private static final ServiceLoader DEFAULT_LOADER = new ServiceLoader(AutoDetectReader.class.getClassLoader());
        private final Charset charset;

        private static Charset detect(InputStream input, Metadata metadata, List<EncodingDetector> detectors, LoadErrorHandler handler) throws IOException {
            return Charset.forName("UTF-8");
        }

        private AutoDetectReader(InputStream stream, Charset charset) throws IOException {
            super(new InputStreamReader(stream, charset));
            this.charset = charset;
            this.mark(1);
            if (this.read() != 65279) {
                this.reset();
            }
        }

        private AutoDetectReader(InputStream stream, Metadata metadata, List<EncodingDetector> detectors, LoadErrorHandler handler) throws IOException, TikaException {
            this(stream, AutoDetectReader.detect(stream, metadata, detectors, handler));
        }

        public AutoDetectReader(InputStream stream, Metadata metadata, EncodingDetector encodingDetector) throws IOException, TikaException {
            this(AutoDetectReader.getBuffered(stream), metadata, Collections.singletonList(encodingDetector), DEFAULT_LOADER.getLoadErrorHandler());
        }

        public AutoDetectReader(InputStream stream, Metadata metadata, ServiceLoader loader) throws IOException, TikaException {
            this(AutoDetectReader.getBuffered(stream), metadata, loader.loadServiceProviders(EncodingDetector.class), loader.getLoadErrorHandler());
        }

        public AutoDetectReader(InputStream stream, Metadata metadata) throws IOException, TikaException {
            this(stream, metadata, DEFAULT_LOADER);
        }

        public AutoDetectReader(InputStream stream) throws IOException, TikaException {
            this(stream, new Metadata());
        }

        private static InputStream getBuffered(InputStream stream) {
            if (stream.markSupported()) {
                return stream;
            }
            return new BufferedInputStream(stream);
        }

        public Charset getCharset() {
            return this.charset;
        }

        public InputSource asInputSource() {
            InputSource source = new InputSource(this);
            source.setEncoding(this.charset.name());
            return source;
        }
    }

    private class HtmlParserMapper
    implements HtmlMapper {
        private HtmlParserMapper() {
        }

        public String mapSafeElement(String name) {
            return TikaHtmlParser.this.mapSafeElement(name);
        }

        public boolean isDiscardElement(String name) {
            return TikaHtmlParser.this.isDiscardElement(name);
        }

        public String mapSafeAttribute(String elementName, String attributeName) {
            return TikaHtmlParser.this.mapSafeAttribute(elementName, attributeName);
        }
    }
}

