/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils.html;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.lib.utils.html.HTMLType;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonCustomization;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.slex.lang.AbstractDSLOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HTMLDocument {
    private static final char[] ELEMENT_INVALID_SYMBOLS = new char[]{'?', '*', '#', '<', '>', '@', '[', ']', '{', '}', '|', '(', ')', '&', '!', '^', '%', '\"', '/', '\\', '~', '+', '=', '`', ';', ',', ':', '.', ' '};
    private Document document;

    public HTMLDocument(String html, boolean fragment) {
        this.document = fragment ? Jsoup.parseBodyFragment(html) : Jsoup.parse(html);
    }

    public HTMLDocument(String html) {
        this(html, false);
    }

    public Document toDocument() {
        return this.document;
    }

    public Element selectFirst(String selector) {
        return this.document.select(selector).first();
    }

    public Elements select(String selector) {
        return this.document.select(selector);
    }

    public String toJSON(HTMLType htmlType, boolean nullable, String topElement, boolean prettyPrint, List<String> columnNames, boolean matches) throws UtilitiesException, SerializerException {
        if (!HTMLType.TABLE.equals((Object)htmlType)) {
            throw new UtilitiesException("HTML Type is not supported yet");
        }
        List<Map<String, Object>> resultList = this.tableToResultList(nullable, columnNames, matches);
        Object objectToSerialize = resultList;
        if (topElement != null) {
            HashMap<String, List<Map<String, Object>>> pre = new HashMap<String, List<Map<String, Object>>>();
            pre.put(topElement, resultList);
            objectToSerialize = pre;
        }
        return HTMLDocument.getJsonSerializer(prettyPrint).serialize(objectToSerialize);
    }

    public RowSet toRowSet(HTMLType htmlType, boolean nullable, List<String> columnNames, boolean matches) throws Exception {
        if (!HTMLType.TABLE.equals((Object)htmlType)) {
            throw new UtilitiesException("HTML Type is not supported yet");
        }
        List<Map<String, Object>> resultList = this.tableToResultList(nullable, columnNames, matches);
        if (resultList.isEmpty()) {
            return null;
        }
        RowMetaData metaData = new RowMetaData();
        for (String column : resultList.get(0).keySet()) {
            AbstractDSLOperation.addColumn(metaData, column);
        }
        RowSet rs = new RowSet(metaData);
        for (Map<String, Object> row : resultList) {
            rs.addToRowSet(row.values().toArray());
        }
        return rs;
    }

    private static Object convertValue(String value, boolean nullable) {
        if (value.isEmpty() && nullable) {
            return null;
        }
        String cleanedValue = value.replaceAll("[\\s,\\^\\&\\(\\)\\/\\{\\}\\[\\]]", "");
        Object result = value;
        if (HTMLDocument.isNumeric(cleanedValue)) {
            int intValue;
            BigDecimal bdValue = NumberUtils.createBigDecimal((String)cleanedValue);
            result = bdValue.equals(new BigDecimal(intValue = bdValue.intValue())) ? Integer.valueOf(intValue) : bdValue;
        }
        return result;
    }

    private static boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private List<Map<String, Object>> tableToResultList(boolean nullable, List<String> columnNames, boolean matches) throws UtilitiesException {
        List<String> currentHeaderFields;
        Element table = this.document.select("table").first();
        Iterator rowElementsIter = table.select("tr").iterator();
        Elements headerElements = ((Element)rowElementsIter.next()).select("th");
        List<String> tableHeaderFields = HTMLDocument.headerColumns(headerElements);
        if (!matches) {
            if (columnNames == null) {
                currentHeaderFields = tableHeaderFields;
            } else {
                if (tableHeaderFields.size() != columnNames.size()) {
                    throw new UtilitiesException("Invalid tuple count. Specified " + columnNames.size() + " columns but " + tableHeaderFields.size() + " columns detected.  HTML column names " + String.valueOf(tableHeaderFields));
                }
                currentHeaderFields = columnNames;
            }
        } else {
            if (columnNames == null || columnNames.isEmpty()) {
                throw new UtilitiesException("Column names must be specified.");
            }
            for (String column : columnNames) {
                if (tableHeaderFields.contains(column)) continue;
                throw new UtilitiesException("Column '" + column + "' does not exist. HTML column names " + String.valueOf(tableHeaderFields));
            }
            currentHeaderFields = columnNames;
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        while (rowElementsIter.hasNext()) {
            Element rowElement = (Element)rowElementsIter.next();
            LinkedHashMap<String, Object> rowObject = new LinkedHashMap<String, Object>();
            Elements fieldElements = rowElement.select("td");
            int fieldElementsSize = fieldElements.size();
            for (String field : currentHeaderFields) {
                if (field == null) continue;
                String value = tableHeaderFields.indexOf(field) < fieldElementsSize ? ((Element)fieldElements.get(tableHeaderFields.indexOf(field))).text() : "";
                rowObject.put(field, HTMLDocument.convertValue(value, nullable));
            }
            resultList.add(rowObject);
        }
        return resultList;
    }

    private static List<String> headerColumns(Elements headerElements) {
        ArrayList<String> headerFields = new ArrayList<String>();
        for (Element headerElement : headerElements) {
            headerFields.add(HTMLDocument.normalizeHeaderField(headerElement.text()));
        }
        return headerFields;
    }

    private static String normalizeHeaderField(String value) {
        return StringUtils.toCamelCase(value, true, ELEMENT_INVALID_SYMBOLS);
    }

    private static JSONSerializer getJsonSerializer(boolean prettyPrint) {
        String jsonNotationLevel = "none";
        JsonCustomization.Builder builder = JsonCustomization.builder().fromMap(Collections.singletonMap("level", jsonNotationLevel != null ? jsonNotationLevel.replace('+', ',') : null)).setNotation(null).setPrettyPrint(prettyPrint);
        return HTTPUtils.getJsonSerializerForRest((FabricContext)DataspaceStore.getContext(), builder.build());
    }
}

