/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.local.LocalFileSystem;
import com.streamscape.tools.lexer.BufferUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;

public class ZipUtils {
    public static final char ZIP_FILE_SEPARATOR = '/';

    public static void compress(File sourceFile, File targetFile) throws IOException {
        ZipUtils.compress(sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), new LocalFileSystem(), new LocalFileSystem());
    }

    public static void compress(String sourcePath, String targetPath, FileSystem sourceFileSystem, FileSystem targetFileSystem) throws IOException {
        byte[] buffer = new byte[65536];
        if (targetFileSystem.exists(targetPath)) {
            throw new IOException("Target file " + targetPath + " already exists");
        }
        try (OutputStream outputStream = targetFileSystem.create(targetPath);
             ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(outputStream));){
            if (sourceFileSystem.isDirectory(sourcePath)) {
                ZipUtils.addDir(zip, sourcePath, "", sourceFileSystem, buffer);
            } else {
                ZipUtils.addFile(zip, new File(sourcePath).getName(), sourcePath, sourceFileSystem, buffer);
            }
        }
    }

    private static void addDir(ZipOutputStream zip, String workingDir, String namespace, FileSystem sourceFileSystem, byte[] buffer) throws IOException {
        String dir = BufferUtils.unslashString(workingDir + "/" + namespace);
        if (ZipUtils.doAddDir(zip, workingDir, namespace, sourceFileSystem, buffer)) {
            for (FileInfo file : sourceFileSystem.list(dir)) {
                if (!file.isDirectory()) continue;
                ZipUtils.addDir(zip, workingDir, (String)(namespace.isEmpty() ? "" : namespace + File.separator) + file.getName(), sourceFileSystem, buffer);
            }
        }
    }

    private static boolean doAddDir(ZipOutputStream zip, String workingDir, String namespace, FileSystem sourceFileSystem, byte[] buffer) throws IOException {
        String dir = BufferUtils.unslashString(workingDir + "/" + namespace);
        if (!sourceFileSystem.exists(dir)) {
            return false;
        }
        for (FileInfo file : sourceFileSystem.list(dir)) {
            if (file.isDirectory()) continue;
            ZipUtils.addFile(zip, (String)(namespace.isEmpty() ? "" : namespace + File.separator) + file.getName(), file.getAbsolutePath(), sourceFileSystem, buffer);
        }
        return true;
    }

    private static void addFile(ZipOutputStream zip, String entryName, String sourceFile, FileSystem sourceFileSystem, byte[] buffer) throws IOException {
        zip.putNextEntry(new ZipEntry(entryName.replace(File.separatorChar, '/')));
        try (InputStream input = sourceFileSystem.open(sourceFile);){
            int readBytes;
            while ((readBytes = input.read(buffer)) > 0) {
                zip.write(buffer, 0, readBytes);
            }
        }
        zip.closeEntry();
    }

    public static void extract(File sourcePath, File targetDir) throws IOException {
        ZipUtils.extract(sourcePath.getAbsolutePath(), targetDir.getAbsolutePath(), new LocalFileSystem(), new LocalFileSystem());
    }

    public static void extract(String sourceFile, String targetDir, FileSystem sourceFileSystem, FileSystem targetFileSystem) throws IOException {
        byte[] buffer = new byte[65536];
        try (InputStream inputStream = sourceFileSystem.open(sourceFile);
             ZipInputStream zip = new ZipInputStream(new BufferedInputStream(inputStream));){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                String entryTarget = targetDir + File.separatorChar + entry.getName().replace('/', File.separatorChar);
                if (entry.isDirectory()) {
                    if (targetFileSystem.exists(entryTarget)) continue;
                    targetFileSystem.mkdir(entryTarget);
                    continue;
                }
                String entryTargetParent = FilenameUtils.getPath(entryTarget);
                if (!targetFileSystem.exists(entryTargetParent)) {
                    targetFileSystem.mkdir(entryTargetParent);
                }
                targetFileSystem.writeFileFromInputStream(entryTarget, zip, 0x6400000);
            }
        }
    }

    public static List<FileInfo> listZipFileEntries(String file, FileSystem fileSystem) throws IOException {
        ArrayList<FileInfo> result = new ArrayList<FileInfo>();
        try (InputStream inputStream = fileSystem.open(file);
             ZipInputStream zip = new ZipInputStream(new BufferedInputStream(inputStream));){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                FileInfo info = new FileInfo(entry.getName(), null);
                info.setSize(entry.getSize());
                info.setModificationTime(entry.getTime());
                info.setDirectory(entry.isDirectory());
                result.add(info);
            }
        }
        return result;
    }
}

