/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.types.AbstractSemanticFactory;
import com.streamscape.sef.scheduler.SchedulerException;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Utils
extends AbstractSemanticFactory {
    static final int MSECS_PER_SECOND = 1000;
    static final int MSECS_PER_MINUTE = 60000;
    static final int MSECS_PER_HOUR = 3600000;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static boolean equalsNullSafe(Object object1, Object object2) {
        return object1 == null ? object2 == null : object2 != null && object1.equals(object2);
    }

    public static <T> boolean equalsNullSafe(Collection<T> list1, Collection<T> list2) {
        return list1 == null ? list2 == null : list2 != null && Utils.equals(list1, list2);
    }

    public static <T> boolean equals(Collection<T> list1, Collection<T> list2) {
        if (list1.size() == list2.size()) {
            Iterator<T> iter1 = list1.iterator();
            Iterator<T> iter2 = list2.iterator();
            while (iter1.hasNext()) {
                if (Utils.equalsNullSafe(iter1.next(), iter2.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static <T> boolean equals(Collection<T> list1, T ... list2) {
        return Utils.equals(list1, Arrays.asList(list2));
    }

    public static <Key, Value> boolean equalsNullSafe(Map<Key, Value> map1, Map<Key, Value> map2) {
        return map1 == null ? map2 == null : map2 != null && Utils.equalsNullSafe(map1.entrySet(), map2.entrySet());
    }

    public static <T> boolean isEmpty(Collection<T> list) {
        return list == null || list.isEmpty();
    }

    public static boolean sleep(long timeout) {
        return Utils.doSleep(timeout, true);
    }

    public static boolean sleepNoInterrupt(long timeout) {
        return Utils.doSleep(timeout, false);
    }

    private static boolean doSleep(long timeout, boolean interrupt) {
        try {
            if (timeout > 0L) {
                Thread.sleep(timeout);
            }
        }
        catch (InterruptedException exception) {
            if (interrupt) {
                Thread.currentThread().interrupt();
            }
            return false;
        }
        return true;
    }

    public static String formatException(Throwable exception) {
        StringBuilder builder = new StringBuilder();
        Utils.formatException(exception, " ", builder);
        return builder.toString();
    }

    public static String formatException(Throwable exception, String separator) {
        StringBuilder builder = new StringBuilder();
        Utils.formatException(exception, separator, builder);
        return builder.toString();
    }

    public static void formatException(Throwable exception, String separator, StringBuilder result) {
        result.append(exception.getMessage());
        if (exception.getCause() != null && exception.getCause().getMessage() != null) {
            result.append(separator).append("Cause: ");
            Utils.formatException(exception.getCause(), separator, result);
        }
    }

    public static String formatExceptionWithUnrepeatedCauses(Throwable exception) {
        return Utils.formatExceptionWithUnrepeatedCauses(exception, " ");
    }

    public static String formatExceptionWithUnrepeatedCauses(Throwable exception, String separator) {
        StringBuilder builder = new StringBuilder();
        if (exception != null && exception.getMessage() != null) {
            builder.append(Utils.formatExceptionMessage(exception));
        } else if (exception instanceof NullPointerException) {
            builder.append("Null pointer exception.");
        } else if (exception != null) {
            builder.append(exception.toString());
        } else {
            builder.append("Null exception!");
        }
        while (exception != null && exception.getCause() != null && exception.getCause() != exception) {
            String message;
            exception = exception.getCause();
            while (builder.length() > 0 && Character.isWhitespace(builder.charAt(builder.length() - 1))) {
                builder.setLength(builder.length() - 1);
            }
            if (builder.length() > 0 && builder.charAt(builder.length() - 1) != '.') {
                builder.append(".");
            }
            if (builder.indexOf((message = !StringUtils.isEmpty(exception.getMessage()) ? Utils.formatExceptionMessage(exception) : exception.toString()).trim()) != -1) continue;
            builder.append(separator).append("Cause: ").append(message);
        }
        return builder.toString();
    }

    private static String formatExceptionMessage(Throwable exception) {
        if (exception instanceof SchedulerException) {
            return "SCH-" + ((SchedulerException)exception).getErrorCode() + " " + exception.getMessage();
        }
        return exception.getMessage();
    }

    public static Throwable unwrapInvokeException(Throwable exception) {
        if (exception instanceof UndeclaredThrowableException) {
            UndeclaredThrowableException e = (UndeclaredThrowableException)exception;
            if (e.getUndeclaredThrowable() != null) {
                return Utils.unwrapInvokeException(e.getUndeclaredThrowable());
            }
            return e;
        }
        if (exception instanceof InvocationTargetException) {
            Throwable target = ((InvocationTargetException)exception).getTargetException();
            if (target != null) {
                return Utils.unwrapInvokeException(target);
            }
            return exception;
        }
        return exception;
    }

    public static <T> T getCause(Throwable exception, Class<T> causeClazz) {
        while (exception != null && exception.getClass() != causeClazz) {
            exception = exception.getCause();
        }
        return (T)exception;
    }

    public static <T> T getCauseAssignable(Throwable exception, Class<T> causeClazz) {
        while (exception != null && !causeClazz.isAssignableFrom(exception.getClass())) {
            exception = exception.getCause();
        }
        return (T)exception;
    }

    public static String toTimeString(long time) {
        StringBuilder result = new StringBuilder();
        DecimalFormat format = new DecimalFormat();
        format.setMinimumIntegerDigits(2);
        long hours = time / 3600000L;
        result.append(format.format(hours)).append(":");
        long minutes = (time -= hours * 3600000L) / 60000L;
        result.append(format.format(minutes)).append(":");
        long seconds = (time -= minutes * 60000L) / 1000L;
        result.append(format.format(seconds)).append(".");
        format.setMinimumIntegerDigits(3);
        result.append(format.format(time - seconds * 1000L));
        return result.toString();
    }

    public static int min(int a, long b) {
        return b < Integer.MAX_VALUE && (int)b < a ? (int)b : a;
    }

    public static byte[] readByteArray(DataInputStream input) throws IOException {
        byte[] bytes = new byte[input.available()];
        input.readFully(bytes);
        return bytes;
    }

    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static void writeInt(int v, OutputStream out) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
    }

    public static long readLong(InputStream in) throws IOException {
        byte[] readBuffer = new byte[8];
        in.read(readBuffer, 0, 8);
        return ((long)readBuffer[0] << 56) + ((long)(readBuffer[1] & 0xFF) << 48) + ((long)(readBuffer[2] & 0xFF) << 40) + ((long)(readBuffer[3] & 0xFF) << 32) + ((long)(readBuffer[4] & 0xFF) << 24) + (long)((readBuffer[5] & 0xFF) << 16) + (long)((readBuffer[6] & 0xFF) << 8) + (long)((readBuffer[7] & 0xFF) << 0);
    }

    public static void writeLong(long v, OutputStream out) throws IOException {
        Utils.writeInt((int)(v >>> 32), out);
        Utils.writeInt((int)v, out);
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(HEX_DIGITS[b >> 4 & 0xF]);
            result.append(HEX_DIGITS[b & 0xF]);
        }
        return result.toString();
    }

    public static <TKey, TValue> Map<TKey, TValue> removeAll(Map<TKey, TValue> from, Map<TKey, TValue> removedValues) {
        removedValues.keySet().forEach(from::remove);
        return from;
    }

    public static <TKey, TValue> void recreate(Map<TKey, TValue> map) {
        ArrayList<Map.Entry<TKey, TValue>> entries = new ArrayList<Map.Entry<TKey, TValue>>(map.size());
        entries.addAll(map.entrySet());
        map.clear();
        for (Map.Entry entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static <TKey, TValue> HashMap<TKey, TValue> createMap(TKey key, TValue value) {
        HashMap<TKey, TValue> result = new HashMap<TKey, TValue>();
        result.put(key, value);
        return result;
    }
}

