/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.NamedObject;
import java.util.Date;

public class TimeWindow
extends CloneableDataObject
implements NamedObject,
Comparable<TimeWindow> {
    private String name;
    private Date startTime;
    private Date endTime;

    public TimeWindow(Date time) {
        this(time, time);
    }

    public TimeWindow(String name, Date time) {
        this(name, time, time);
    }

    public TimeWindow(Date startTime, Date endTime) {
        this(null, startTime, endTime);
    }

    public TimeWindow(String name, Date startTime, Date endTime) {
        this.name = name;
        if (startTime != null && endTime != null && startTime.after(endTime)) {
            this.startTime = endTime;
            this.endTime = startTime;
        } else {
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean contains(Date time) {
        return time.getTime() >= this.startTime.getTime() && time.getTime() <= this.endTime.getTime();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof TimeWindow && Utils.equalsNullSafe(this.name, ((TimeWindow)other).name) && Utils.equalsNullSafe(this.startTime, ((TimeWindow)other).startTime) && Utils.equalsNullSafe(this.endTime, ((TimeWindow)other).endTime);
    }

    @Override
    public int compareTo(TimeWindow other) {
        return this.startTime.before(other.startTime) ? -1 : (this.startTime.after(other.startTime) ? 1 : 0);
    }

    public String toString() {
        return this.name + "(" + String.valueOf(this.startTime) + ", " + String.valueOf(this.endTime) + ")";
    }
}

