/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.lib.utils.CryptoUtils;
import com.streamscape.lib.utils.UtilitiesException;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class StringUtils {
    private static byte[] EMPTY_UTF;
    private static final Pattern WHITESPACE_PATTERN;
    private static final Method IS_CHARACTER_VALID_FOR_EVENT_ID;
    private static final Method IS_CHARACTER_VALID_FOR_EVENT_FILTER;
    private static final char[] OBJECT_NAME_INVALIDS;
    private static final char[] SEMANTIC_NAME_INVALIDS;
    private static final char[] STRING_INVALIDS;
    public static final List<String> EMPTY_TOKENS;

    public static boolean containsChars(String str, char[] characters, boolean withSpaces) {
        if (str == null || str.isEmpty() || characters == null || characters.length == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            for (char searchChar : characters) {
                if (searchChar != ch && (!withSpaces || !Character.isWhitespace(ch))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsChars(String str, String characters, boolean withSpaces) {
        return characters != null && StringUtils.containsChars(str, characters.toCharArray(), withSpaces);
    }

    public static boolean validateConsumerName(String consumerName) {
        if (consumerName == null || consumerName.isEmpty()) {
            return false;
        }
        String validCharacters = new String(new char[]{'?', '#', '&', '@', '!', '%', '/', '+', '-', '=', '.', ']', '['});
        for (int i = 0; i < consumerName.length(); ++i) {
            char c = consumerName.charAt(i);
            if (Character.isJavaIdentifierPart(c) || validCharacters.indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }

    public static String hashEventId(String eventId) throws UtilitiesException {
        if (!StringUtils.validateEventId(eventId)) {
            throw new UtilitiesException("Invalid Event Id specified.");
        }
        try {
            return CryptoUtils.calculateDigest(eventId.getBytes(), "MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UtilitiesException("No Such Algorithm Exception: " + ex.getMessage());
        }
    }

    private static boolean isCharacterValidForEventId(char c) {
        return Character.isJavaIdentifierPart(c) || c == '[' || c == ']' || c == '-';
    }

    private static boolean isCharacterValidForEventFilter(char c) {
        return StringUtils.isCharacterValidForEventId(c) || c == '*' || c == '#' || c == '!';
    }

    public static boolean validateEventId(String eventId) {
        return StringUtils.validateEventIdOrFilter(eventId, IS_CHARACTER_VALID_FOR_EVENT_ID);
    }

    public static boolean validateEventFilter(String eventFilter) {
        return StringUtils.validateEventIdOrFilter(eventFilter, IS_CHARACTER_VALID_FOR_EVENT_FILTER);
    }

    private static boolean validateEventIdOrFilter(String eventId, Method characterValidator) {
        if (eventId == null || eventId.length() == 0) {
            return false;
        }
        int iBegin = 0;
        int iEnd = 0;
        while (iEnd < eventId.length()) {
            char c;
            while (iEnd < eventId.length() && (c = eventId.charAt(iEnd)) != '.' && c != '/') {
                try {
                    if (!((Boolean)characterValidator.invoke(StringUtils.class, Character.valueOf(c))).booleanValue()) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("Critical error!", exception);
                }
                ++iEnd;
            }
            if (iEnd <= iBegin) {
                return false;
            }
            if (++iEnd == eventId.length()) {
                return false;
            }
            iBegin = iEnd;
        }
        return true;
    }

    public static boolean validateObjectName(String name) {
        return !name.startsWith(".") && !name.endsWith(".") && !StringUtils.containsChars(name, OBJECT_NAME_INVALIDS, true);
    }

    public static boolean validateSemanticName(String name) {
        return !StringUtils.containsChars(name, SEMANTIC_NAME_INVALIDS, true);
    }

    public static boolean validateString(String str) {
        return !StringUtils.containsChars(str, STRING_INVALIDS, false);
    }

    public static String normalizeObjectName(String objectName) {
        return objectName.replace('.', '%');
    }

    public static String deNormalizeObjectName(String objectName) {
        return objectName.replace('%', '.');
    }

    public static String normalizeString(String str) {
        str.replace(' ', '_');
        str.replace('&', '_');
        str.replace('*', '_');
        str.replace('#', '_');
        str.replace('!', '_');
        str.replace('^', '_');
        str.replace('%', '_');
        str.replace('\"', '_');
        str.replace('/', '_');
        str.replace('\\', '_');
        str.replace('~', '_');
        str.replace('+', '_');
        str.replace('=', '_');
        str.replace('`', '_');
        str.replace(';', '_');
        str.replace('<', '_');
        str.replace('>', '_');
        str.replace(',', '_');
        return str;
    }

    public static String UTFToString(byte[] utf, int off) throws UtilitiesException {
        try {
            int utflen = (utf[off++] & 0xFF) << 8 | utf[off++] & 0xFF;
            char[] str = new char[utflen];
            int count = 0;
            int strlen = 0;
            block7: while (count < utflen) {
                byte c = utf[off++];
                switch (c >>> 4 & 0xF) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++count;
                        str[strlen++] = (char)c;
                        continue block7;
                    }
                    case 12: 
                    case 13: {
                        byte char2;
                        if ((count += 2) > utflen) {
                            throw new UtilitiesException("UTFDataFormatException: invalid length.");
                        }
                        if (((char2 = utf[off++]) & 0xC0) != 128) {
                            throw new UtilitiesException("UTFDataFormatException: invalid hex character.");
                        }
                        str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        continue block7;
                    }
                    case 14: {
                        if ((count += 3) > utflen) {
                            throw new UtilitiesException("UTFDataFormatException: invalid length.");
                        }
                        byte char2 = utf[off++];
                        byte char3 = utf[off++];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UtilitiesException("UTFDataFormatException: invalid hex character.");
                        }
                        str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        continue block7;
                    }
                }
                throw new UtilitiesException("UTFDataFormatException: general exception.");
            }
            return new String(str, 0, strlen);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UtilitiesException("UTFDataFormatException: " + e.getMessage());
        }
    }

    public static byte[] stringToUTF(String str) throws UtilitiesException {
        int strlen = str.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UtilitiesException("UTFDataFormatException: String too long: " + str);
        }
        byte[] utf = new byte[utflen + 2];
        int p = 0;
        utf[p++] = (byte)(utflen >>> 8 & 0xFF);
        utf[p++] = (byte)(utflen >>> 0 & 0xFF);
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                utf[p++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                utf[p++] = (byte)(0xE0 | c >> 12 & 0xF);
                utf[p++] = (byte)(0x80 | c >> 6 & 0x3F);
                utf[p++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            utf[p++] = (byte)(0xC0 | c >> 6 & 0x1F);
            utf[p++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return utf;
    }

    public static byte[] getEmptyUTF() {
        return EMPTY_UTF;
    }

    public static int lengthUTF(String str) {
        int strlen = str.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen + 2;
    }

    public static long hostToLong(String host) throws UnknownHostException {
        int port = 2506;
        int i = host.lastIndexOf(":");
        if (i >= 0) {
            port = Integer.parseInt(host.substring(i + 1));
            host = host.substring(0, i);
        }
        if (host.equals("localhost")) {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        byte[] ip = InetAddress.getByName(host).getAddress();
        return ((long)ip[0] & 0xFFL) << 56 | ((long)ip[1] & 0xFFL) << 48 | ((long)ip[2] & 0xFFL) << 40 | ((long)ip[3] & 0xFFL) << 32 | (long)port & 0xFFFFL;
    }

    public static List<String> split(String str, char delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        StringUtils.split(str, delimiter, result);
        return result;
    }

    public static void split(String str, char delimiter, List<String> result) {
        if (str.length() != 0) {
            int iBegin = 0;
            int iEnd = 0;
            while (iEnd <= str.length()) {
                iEnd = str.indexOf(delimiter, iBegin);
                if (iEnd == -1) {
                    iEnd = str.length();
                }
                result.add(str.substring(iBegin, iEnd));
                iBegin = ++iEnd;
            }
        }
    }

    public static List<String> split(String str, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        StringUtils.split(str, delimiter, result);
        return result;
    }

    public static void split(String str, String delimiter, List<String> result) {
        if (str.length() != 0) {
            int iBegin = 0;
            int iEnd = 0;
            while (iEnd <= str.length()) {
                iEnd = str.indexOf(delimiter, iBegin);
                if (iEnd == -1) {
                    iEnd = str.length();
                }
                result.add(str.substring(iBegin, iEnd));
                iBegin = ++iEnd;
            }
        }
    }

    public static List<String> splitWithTrim(String str, char delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        StringUtils.splitWithTrim(str, delimiter, result);
        return result;
    }

    public static void splitWithTrim(String str, char delimiter, List<String> result) {
        List<String> tokens = StringUtils.split(str, delimiter);
        for (String token : tokens) {
            result.add(token.trim());
        }
    }

    public static List<String> split(String str, char delimiter1, char delimiter2) {
        ArrayList<String> result = new ArrayList<String>();
        StringUtils.split(str, delimiter1, delimiter2, result);
        return result;
    }

    public static void split(String str, char delimiter1, char delimiter2, List<String> result) {
        if (str.length() != 0) {
            int iBegin = 0;
            int iEnd = 0;
            while (iEnd <= str.length()) {
                char c;
                while (iEnd < str.length() && (c = str.charAt(iEnd)) != delimiter1 && c != delimiter2) {
                    ++iEnd;
                }
                result.add(str.substring(iBegin, iEnd));
                iBegin = ++iEnd;
            }
        }
    }

    public static List<String> splitWithTrim(String str, char delimiter1, char delimiter2) {
        ArrayList<String> result = new ArrayList<String>();
        StringUtils.splitWithTrim(str, delimiter1, delimiter2, result);
        return result;
    }

    public static void splitWithTrim(String str, char delimiter1, char delimiter2, List<String> result) {
        List<String> tokens = StringUtils.split(str, delimiter1, delimiter2);
        for (String token : tokens) {
            result.add(token.trim());
        }
    }

    public static List<String> splitWithoutEmptyTokens(String str, char delimiter) {
        LinkedList<String> result = new LinkedList<String>();
        StringUtils.splitWithoutEmptyTokens(str, delimiter, result);
        return result;
    }

    public static void splitWithoutEmptyTokens(String str, char delimiter, List<String> result) {
        StringUtils.split(str, delimiter, result);
        result.removeAll(EMPTY_TOKENS);
    }

    public static String trimLeadingSlashes(String s, char slash) {
        int i;
        for (i = 0; i < s.length() && s.charAt(i) == slash; ++i) {
        }
        return s.substring(i);
    }

    public static String trimLeadingSlashes(String s) {
        return StringUtils.trimLeadingSlashes(s, File.separatorChar);
    }

    public static String trimTrailingSlashes(String s, char slash, boolean keepFirst) {
        if (s.length() > 0) {
            int j;
            int start = keepFirst ? 1 : 0;
            for (j = s.length() - 1; j >= start && s.charAt(j) == slash; --j) {
            }
            s = s.substring(0, j + 1);
        }
        return s;
    }

    public static String trimTrailingSlashes(String s) {
        return StringUtils.trimTrailingSlashes(s, File.separatorChar, false);
    }

    public static String trimSlashes(String s) {
        int j;
        int i;
        for (i = 0; i < s.length() && s.charAt(i) == File.separatorChar; ++i) {
        }
        for (j = s.length() - 1; j >= 0 && s.charAt(j) == File.separatorChar; --j) {
        }
        return s.substring(i, j + 1);
    }

    public static boolean equalsNullSafe(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean equalsNullTrimSafe(String str1, String str2) {
        if (str1 == null) {
            str1 = "";
        }
        if (str2 == null) {
            str2 = "";
        }
        return str1.trim().equals(str2.trim());
    }

    public static String toCapitalized(String str) {
        return str.length() > 0 ? Character.toUpperCase(str.charAt(0)) + str.substring(1) : str;
    }

    public static String prependSeparatorIfNotEmpty(String s) {
        return s.length() > 0 ? File.separatorChar + s : s;
    }

    public static String prependSeparatorIfNotEmptyAndRelative(String s) {
        return s.length() > 0 && s.charAt(0) != File.separatorChar ? File.separatorChar + s : s;
    }

    public static String wrapEventId(String eventId) {
        if (eventId == null || eventId.isEmpty()) {
            return "none";
        }
        if (eventId != null && !eventId.isEmpty() && eventId.charAt(0) != '[') {
            return "[" + eventId + "]";
        }
        return eventId;
    }

    public static String unwrapEventId(String eventId) {
        if (eventId == null || eventId.isEmpty()) {
            return null;
        }
        if ((eventId = eventId.trim()).startsWith("[") && eventId.endsWith("]")) {
            eventId = eventId.substring(1, eventId.length() - 1);
        }
        return eventId.trim();
    }

    public static String escapeDsObjectName(String name) {
        if (name == null || name.isEmpty()) {
            return "none";
        }
        if (name != null && !name.isEmpty() && name.charAt(0) != '[' && name.charAt(0) != '\"') {
            return "[" + name + "]";
        }
        return name;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isAlpha(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return IntStream.range(0, str.length()).allMatch(i -> Character.isLetter(str.charAt(i)));
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return IntStream.range(0, str.length()).allMatch(i -> Character.isDigit(str.charAt(i)));
    }

    public static boolean isAlphanumeric(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return IntStream.range(0, str.length()).allMatch(i -> Character.isLetterOrDigit(str.charAt(i)));
    }

    public static boolean isAllUpperCase(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return IntStream.range(0, str.length()).allMatch(i -> Character.isUpperCase(str.charAt(i)));
    }

    public static boolean isAllLowerCase(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return IntStream.range(0, str.length()).allMatch(i -> Character.isLowerCase(str.charAt(i)));
    }

    public static String toCamelCase(String name, boolean lcFirst, char ... delimiters) {
        StringBuilder builder = new StringBuilder();
        String symbols = new String(delimiters);
        for (int i = 0; i < name.length(); ++i) {
            int startI = i;
            char c = name.charAt(i);
            if (lcFirst && i == 0) {
                c = Character.toLowerCase(c);
            }
            if (name.length() > i + 1) {
                while (symbols.indexOf(c) >= 0) {
                    c = name.charAt(++i);
                }
            }
            if (i > startI) {
                builder.append(Character.toUpperCase(c));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String normalizeSpace(String str) {
        if (str == null) {
            return null;
        }
        return WHITESPACE_PATTERN.matcher(str.trim()).replaceAll(" ");
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        return str.endsWith(remove) ? str.substring(0, str.length() - remove.length()) : str;
    }

    public static int lastIndexOfAny(CharSequence str, CharSequence ... searchStrings) {
        if (str == null || searchStrings == null) {
            return -1;
        }
        int result = -1;
        int tmp = 0;
        for (CharSequence search : searchStrings) {
            if (search == null || (tmp = StringUtils.lastIndexOf(str, search, str.length())) <= result) continue;
            result = tmp;
        }
        return result;
    }

    private static int lastIndexOf(CharSequence cs, CharSequence searchChar, int start) {
        return cs.toString().lastIndexOf(searchChar.toString(), start);
    }

    public static boolean endsWithAny(String string, String ... searchStrings) {
        if (StringUtils.isEmpty(string) || searchStrings.length == 0) {
            return false;
        }
        return Arrays.stream(searchStrings).anyMatch(string::endsWith);
    }

    static {
        WHITESPACE_PATTERN = Pattern.compile("(?: |\\u00A0|\\s|[\\s&&[^ ]])\\s*");
        try {
            EMPTY_UTF = StringUtils.stringToUTF("");
        }
        catch (UtilitiesException utilitiesException) {
            // empty catch block
        }
        try {
            IS_CHARACTER_VALID_FOR_EVENT_ID = StringUtils.class.getDeclaredMethod("isCharacterValidForEventId", Character.TYPE);
            IS_CHARACTER_VALID_FOR_EVENT_FILTER = StringUtils.class.getDeclaredMethod("isCharacterValidForEventFilter", Character.TYPE);
        }
        catch (Exception exception) {
            throw new RuntimeException("StringUtils initialization failed.");
        }
        OBJECT_NAME_INVALIDS = new char[]{'?', '*', '#', '<', '>', '@', '[', ']', '{', '}', '|', '(', ')', '&', '!', '^', '%', '\"', '\'', '/', '\\', '~', '+', '=', '`', ';', ','};
        SEMANTIC_NAME_INVALIDS = new char[]{'?', '*', '#', '<', '>', '@', '[', ']', '{', '}', '|', '(', ')', '&', '!', '^', '%', '\"', '\'', '/', '\\', '~', '+', '=', '`', ';', ',', ':', '.'};
        STRING_INVALIDS = new char[]{'&', '*', '#', '!', '^', '%', '\"', '/', '\\', '~', '+', '=', '`', ';', '<', '>', ',', '.', '|'};
        EMPTY_TOKENS = Arrays.asList("");
    }
}

