/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.cli.ClientContext;
import com.streamscape.cli.ClientState;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import com.streamscape.sef.mf.admin.FabricContext;

public class SemanticTypeResolver {
    protected FabricContext context;
    protected ClassLoader classLoader;
    protected SemanticTypeCache typeCache;

    public SemanticTypeResolver() {
        this.initContext();
        this.initClassLoader();
    }

    public SemanticTypeResolver(FabricContext context) {
        this.context = context;
        this.initClassLoader();
    }

    public SemanticTypeResolver(ClassLoader classLoader, SemanticTypeCache typeCache) {
        this.initContext();
        this.classLoader = classLoader;
        this.typeCache = typeCache;
    }

    public SemanticTypeResolver(FabricContext context, ClassLoader classLoader, SemanticTypeCache typeCache) {
        this.context = context;
        this.classLoader = classLoader;
        this.typeCache = typeCache;
    }

    protected void initContext() {
        if (ClientState.isActive()) {
            this.context = ClientContext.getInstance();
        } else if (RuntimeState.isActive()) {
            this.context = RuntimeContext.getInstance();
        }
    }

    protected void initClassLoader() {
        this.typeCache = this.context != null ? this.context.getSemanticTypeCache() : null;
        this.classLoader = null;
        if (this.context == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        } else if (this.context.getSystemClassLoaderChain() != null) {
            try {
                this.classLoader = this.context.getSystemClassLoaderChain();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.classLoader == null) {
            this.classLoader = ClassLoader.getSystemClassLoader();
        }
    }

    public Class<?> resolveSemanticType(String semanticType) throws ClassNotFoundException {
        String className = null;
        if (this.typeCache != null) {
            className = this.typeCache.resolveSemanticType(semanticType);
        }
        if (className == null) {
            className = semanticType;
        }
        return ClassUtils.loadClass(className, this.classLoader);
    }

    public FabricContext getContext() {
        return this.context;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public SemanticTypeCache getSemanticTypeCache() {
        return this.typeCache;
    }
}

