/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.sdo.StructuredDataObject;
import com.streamscape.sdo.lob.LargeBinaryObject;
import com.streamscape.sdo.lob.LargeTextObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;

public class SQLTypes {
    public static final String DecimalClassName = "java.math.BigDecimal";
    public static final String DateClassName = "java.sql.Date";
    public static final String TimeClassName = "java.sql.Time";
    public static final String TimestampClassName = "java.sql.Timestamp";
    public static final int UNDEFINED = -10000;
    public static final int ARRAY = 2003;
    public static final int BIGINT = -5;
    public static final int BINARY = -2;
    public static final int BLOB = 2004;
    public static final int BOOLEAN = 16;
    public static final int CHAR = 1;
    public static final int CLOB = 2005;
    public static final int DATALINK = 70;
    public static final int DATE = 91;
    public static final int DECIMAL = 3;
    public static final int DISTINCT = 2001;
    public static final int DOUBLE = 8;
    public static final int FLOAT = 6;
    public static final int INTEGER = 4;
    public static final int JAVA_OBJECT = 2000;
    public static final int LONGVARBINARY = -4;
    public static final int LONGVARCHAR = -1;
    public static final int NULL = 0;
    public static final int NUMERIC = 2;
    public static final int OTHER = 1111;
    public static final int REAL = 7;
    public static final int REF = 2006;
    public static final int SMALLINT = 5;
    public static final int STRUCT = 2002;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int TINYINT = -6;
    public static final int VARBINARY = -3;
    public static final int VARCHAR = 12;
    public static final int XML = 137;
    static final int SQL_CHARACTER = 1;
    static final int SQL_CHAR = 1;
    static final int SQL_NUMERIC = 2;
    static final int SQL_DECIMAL = 3;
    static final int SQL_DEC = 3;
    static final int SQL_INTEGER = 4;
    static final int SQL_INT = 4;
    static final int SQL_SMALLINT = 5;
    static final int SQL_FLOAT = 6;
    static final int SQL_REAL = 7;
    static final int SQL_DOUBLE = 8;
    static final int SQL_CHARACTER_VARYING = 12;
    static final int SQL_CHAR_VARYING = 12;
    static final int SQL_VARCHAR = 12;
    static final int SQL_BOOLEAN = 16;
    static final int SQL_USER_DEFINED_TYPE = 17;
    static final int SQL_ROW = 19;
    static final int SQL_REF = 20;
    static final int SQL_BIGINT = 25;
    static final int SQL_BINARY_LARGE_OBJECT = 30;
    static final int SQL_BLOB = 30;
    static final int SQL_CHARACTER_LARGE_OBJECT = 40;
    static final int SQL_CLOB = 40;
    static final int SQL_ARRAY = 50;
    static final int SQL_MULTISET = 55;
    static final int SQL_DATE = 91;
    static final int SQL_TIME = 92;
    static final int SQL_TIMESTAMP = 93;
    static final int SQL_TIME_WITH_TIME_ZONE = 94;
    static final int SQL_TIMESTAMP_WITH_TIME_ZONE = 95;
    static final int SQL_INTERVAL_YEAR = 101;
    static final int SQL_INTERVAL_MONTH = 102;
    static final int SQL_INTERVAL_DAY = 103;
    static final int SQL_INTERVAL_HOUR = 104;
    static final int SQL_INTERVAL_MINUTE = 105;
    static final int SQL_INTERVAL_SECOND = 106;
    static final int SQL_INTERVAL_YEAR_TO_MONTH = 107;
    static final int SQL_INTERVAL_DAY_TO_HOUR = 108;
    static final int SQL_INTERVAL_DAY_TO_MINUTE = 109;
    static final int SQL_INTERVAL_DAY_TO_SECOND = 110;
    static final int SQL_INTERVAL_HOUR_TO_MINUTE = 111;
    static final int SQL_INTERVAL_HOUR_TO_SECOND = 112;
    static final int SQL_INTERVAL_MINUTE_TO_SECOND = 113;
    static final int SQL_BIT_VARYING = 15;
    static final int SQL_DATALINK = 70;
    static final int SQL_UDT = 17;
    static final int SQL_UDT_LOCATOR = 18;
    static final int SQL_BLOB_LOCATOR = 31;
    static final int SQL_CLOB_LOCATOR = 41;
    static final int SQL_ARRAY_LOCATOR = 51;
    static final int SQL_MULTISET_LOCATOR = 56;
    static final int SQL_ALL_TYPES = 0;
    static final int SQL_DATETIME = 9;
    static final int SQL_INTERVAL = 10;
    static final int SQL_XML = 137;
    static final int SQL_DISTINCT = 1;
    static final int SQL_SCTRUCTURED = 2;
    public static final int VARCHAR_IGNORECASE = 100;
    static HashMap<Integer, String> typeNames = new HashMap();
    static HashMap<String, Integer> typeAliases = new HashMap();
    static HashMap javaClassTypes = new HashMap();
    public static final int MAX_CHAR_OR_VARCHAR_DISPLAY_SIZE;

    public static String getClassNameFromSQLType(String sqlType) {
        String className = (String)javaClassTypes.get(sqlType);
        return className == null ? sqlType : className;
    }

    public static Class getClassFromSQLType(String sqlType) {
        String name = (String)javaClassTypes.get(sqlType);
        if (name != null) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        }
        return null;
    }

    public static int getSQLType(Class clazz) {
        if (clazz.isAssignableFrom(StructuredDataObject.class)) {
            return 1111;
        }
        Integer sqlType = typeAliases.get(clazz.getName());
        if (sqlType != null) {
            return sqlType;
        }
        return typeAliases.get("NULL");
    }

    public static int getSQLType(String typeName) {
        Integer sqlType = typeAliases.get(typeName);
        return sqlType == null ? typeAliases.get("NULL").intValue() : sqlType.intValue();
    }

    public static String getTypeClass(int type) {
        String typeName = SQLTypes.getTypeName(type);
        if (typeName == null) {
            return "UNDEFINED";
        }
        return (String)javaClassTypes.get(typeName);
    }

    public static String getTypeString(int type) {
        return typeNames.get(type);
    }

    public static String getTypeString(int type, int precision, int scale) {
        String s = typeNames.get(type);
        if (precision != 0 && SQLTypes.acceptsPrecisionCreateParam(type)) {
            StringBuffer sb = new StringBuffer(s);
            sb.append("(");
            sb.append(precision);
            if (scale != 0 && SQLTypes.acceptsScaleCreateParam(type)) {
                sb.append(",");
                sb.append(scale);
            }
            sb.append(")");
            return sb.toString();
        }
        return s;
    }

    public static boolean acceptsPrecisionCreateParam(int type) {
        switch (type) {
            case -2: 
            case 1: 
            case 2004: {
                return true;
            }
            case -3: 
            case 12: 
            case 2005: {
                return true;
            }
            case 100: {
                return true;
            }
            case 2: 
            case 3: 
            case 6: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public static int numericPrecisionCreateParamRadix(int type) {
        switch (type) {
            case 2: 
            case 3: {
                return 10;
            }
            case 6: {
                return 2;
            }
        }
        return 0;
    }

    public static boolean acceptsScaleCreateParam(int type) {
        switch (type) {
            case 2: 
            case 3: {
                return true;
            }
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case 100: {
                return "VARCHAR_IGNORECASE";
            }
            case 137: {
                return "XML";
            }
        }
        return null;
    }

    private static int MAX_CHAR_OR_VARCHAR_DISPLAY_SIZE() {
        try {
            return Integer.getInteger("MAX_CHAR_VARCHAR_DISPLAY_SIZE", 32766);
        }
        catch (SecurityException e) {
            return 32766;
        }
    }

    public static int getSQLTypeMaxDisplaySize(int type) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 137: 
            case 1111: {
                return Integer.MAX_VALUE;
            }
            case 1: 
            case 12: {
                return MAX_CHAR_OR_VARCHAR_DISPLAY_SIZE;
            }
            case -5: {
                return 20;
            }
            case 16: {
                return 5;
            }
            case 70: {
                return 20004;
            }
            case 2: 
            case 3: {
                return 646456995;
            }
            case 91: {
                return 10;
            }
            case 4: {
                return 11;
            }
            case 6: 
            case 7: 
            case 8: {
                return 23;
            }
            case 92: {
                return 8;
            }
            case 5: {
                return 6;
            }
            case 93: {
                return 29;
            }
            case -6: {
                return 4;
            }
        }
        return 0;
    }

    public static boolean isSearchable(int type) {
        switch (type) {
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: {
                return false;
            }
        }
        return true;
    }

    public static Boolean isCaseSensitive(int type) {
        switch (type) {
            case 0: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                return null;
            }
            case -1: 
            case 1: 
            case 70: 
            case 137: 
            case 1111: {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static Boolean isUnsignedAttribute(int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static int getPrecision(int type) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 137: 
            case 1111: {
                return Integer.MAX_VALUE;
            }
            case -5: {
                return 19;
            }
            case 16: {
                return 1;
            }
            case 70: {
                return 20004;
            }
            case 2: 
            case 3: {
                return 646456993;
            }
            case 4: 
            case 91: {
                return 10;
            }
            case 6: 
            case 7: 
            case 8: {
                return 17;
            }
            case 92: {
                return 8;
            }
            case 5: {
                return 5;
            }
            case 93: {
                return 29;
            }
            case -6: {
                return 3;
            }
        }
        return 0;
    }

    public static String getColStClsName(int type) {
        switch (type) {
            case -5: {
                return "java.lang.Long";
            }
            case -4: 
            case -3: 
            case -2: {
                return "[B";
            }
            case 1111: {
                return "com.streamscape.sdo.StructuredDataObject";
            }
            case 16: {
                return "java.lang.Boolean";
            }
            case -1: 
            case 1: 
            case 12: 
            case 137: {
                return "java.lang.String";
            }
            case 70: {
                return "java.net.URL";
            }
            case 91: {
                return DateClassName;
            }
            case 2: 
            case 3: {
                return DecimalClassName;
            }
            case 6: 
            case 7: 
            case 8: {
                return "java.lang.Double";
            }
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case 92: {
                return TimeClassName;
            }
            case 93: {
                return TimestampClassName;
            }
        }
        return null;
    }

    static {
        typeAliases.put("INTEGER", 4);
        typeAliases.put("INT", 4);
        typeAliases.put("int", 4);
        typeAliases.put(Integer.class.getName(), 4);
        typeAliases.put("IDENTITY", 4);
        typeAliases.put("DOUBLE", 8);
        typeAliases.put("double", 8);
        typeAliases.put(Double.class.getName(), 8);
        typeAliases.put("FLOAT", 6);
        typeAliases.put("REAL", 7);
        typeAliases.put("VARCHAR", 12);
        typeAliases.put(StringBuffer.class.getName(), 1);
        typeAliases.put(String.class.getName(), 12);
        typeAliases.put("CHAR", 1);
        typeAliases.put("CHARACTER", 1);
        typeAliases.put("LONGVARCHAR", -1);
        typeAliases.put("VARCHAR_IGNORECASE", 100);
        typeAliases.put("DATE", 91);
        typeAliases.put(DateClassName, 91);
        typeAliases.put("TIME", 92);
        typeAliases.put(TimeClassName, 92);
        typeAliases.put("TIMESTAMP", 93);
        typeAliases.put(TimestampClassName, 93);
        typeAliases.put("DATETIME", 93);
        typeAliases.put(Date.class.getName(), 91);
        typeAliases.put("DECIMAL", 3);
        typeAliases.put(DecimalClassName, 3);
        typeAliases.put("NUMERIC", 2);
        typeAliases.put("BIT", 16);
        typeAliases.put("BOOLEAN", 16);
        typeAliases.put("boolean", 16);
        typeAliases.put(Boolean.class.getName(), 16);
        typeAliases.put("TINYINT", -6);
        typeAliases.put("byte", -6);
        typeAliases.put(Byte.class.getName(), -6);
        typeAliases.put("SMALLINT", 5);
        typeAliases.put("short", 5);
        typeAliases.put(Short.class.getName(), 5);
        typeAliases.put("BIGINT", -5);
        typeAliases.put("long", -5);
        typeAliases.put(Long.class.getName(), -5);
        typeAliases.put("BINARY", -2);
        typeAliases.put("[B", -2);
        typeAliases.put("VARBINARY", -3);
        typeAliases.put("LONGVARBINARY", -4);
        typeAliases.put("OTHER", 1111);
        typeAliases.put("OBJECT", 2000);
        typeAliases.put(Object.class.getName(), 2000);
        typeAliases.put(StructuredDataObject.class.getName(), 2000);
        typeAliases.put("NULL", 0);
        typeAliases.put("void", 0);
        typeAliases.put(Void.class.getName(), 0);
        typeNames.put(0, "NULL");
        typeNames.put(4, "INTEGER");
        typeNames.put(8, "DOUBLE");
        typeNames.put(100, "VARCHAR_IGNORECASE");
        typeNames.put(12, "VARCHAR");
        typeNames.put(1, "CHAR");
        typeNames.put(-1, "LONGVARCHAR");
        typeNames.put(91, "DATE");
        typeNames.put(92, "TIME");
        typeNames.put(3, "DECIMAL");
        typeNames.put(16, "BOOLEAN");
        typeNames.put(-6, "TINYINT");
        typeNames.put(5, "SMALLINT");
        typeNames.put(-5, "BIGINT");
        typeNames.put(7, "REAL");
        typeNames.put(6, "FLOAT");
        typeNames.put(2, "NUMERIC");
        typeNames.put(93, "TIMESTAMP");
        typeNames.put(-2, "BINARY");
        typeNames.put(-3, "VARBINARY");
        typeNames.put(-4, "LONGVARBINARY");
        typeNames.put(1111, "OBJECT");
        javaClassTypes.put("ARRAY", Object.class.getName());
        javaClassTypes.put("BIGINT", Integer.class.getName());
        javaClassTypes.put("BINARY", LargeBinaryObject.class.getName());
        javaClassTypes.put("BLOB", LargeBinaryObject.class.getName());
        javaClassTypes.put("BOOLEAN", Boolean.class.getName());
        javaClassTypes.put("CHAR", StringBuffer.class.getName());
        javaClassTypes.put("CLOB", LargeTextObject.class.getName());
        javaClassTypes.put("DATALINK", Object.class.getName());
        javaClassTypes.put("DATE", java.sql.Date.class.getName());
        javaClassTypes.put("DECIMAL", BigDecimal.class.getName());
        javaClassTypes.put("DISTINCT", Object.class.getName());
        javaClassTypes.put("DOUBLE", Double.class.getName());
        javaClassTypes.put("FLOAT", Float.class.getName());
        javaClassTypes.put("INTEGER", Integer.class.getName());
        javaClassTypes.put("JAVA_OBJECT", Object.class.getName());
        javaClassTypes.put("LONGVARBINARY", LargeBinaryObject.class.getName());
        javaClassTypes.put("LONGVARCHAR", LargeTextObject.class.getName());
        javaClassTypes.put("NULL", Void.class.getName());
        javaClassTypes.put("NUMERIC", Void.class.getName());
        javaClassTypes.put("OTHER", StructuredDataObject.class.getName());
        javaClassTypes.put("REAL", Void.class.getName());
        javaClassTypes.put("REF", Object.class.getName());
        javaClassTypes.put("SMALLINT", Integer.class.getName());
        javaClassTypes.put("STRUCT", StructuredDataObject.class.getName());
        javaClassTypes.put("TIME", java.sql.Date.class.getName());
        javaClassTypes.put("TIMESTAMP", Timestamp.class.getName());
        javaClassTypes.put("TINYINT", Integer.class.getName());
        javaClassTypes.put("VARBINARY", LargeBinaryObject.class.getName());
        javaClassTypes.put("VARCHAR", String.class.getName());
        javaClassTypes.put("VARCHAR_IGNORECASE", String.class.getName());
        javaClassTypes.put("XML", String.class.getName());
        MAX_CHAR_OR_VARCHAR_DISPLAY_SIZE = SQLTypes.MAX_CHAR_OR_VARCHAR_DISPLAY_SIZE();
    }
}

