/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.cli.ds.collection.Aspects;
import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.ds.parser.expression.URL;
import com.streamscape.sdo.ImmutableEventDatagram;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public enum SQLType {
    CHAR(1, "CHAR", String.class),
    VARCHAR(12, "VARCHAR", String.class),
    LONGVARCHAR(-1, "LONGVARCHAR", String.class),
    NCHAR(-15, "NCHAR", String.class),
    NVARCHAR(-9, "NVARCHAR", String.class),
    LONGNVARCHAR(-16, "LONGNVARCHAR", String.class),
    STRING(12, "STRING", String.class),
    CATEGORY(12, "CATEGORY", String.class),
    SQLDATE(91, "SQLDATE", Date.class),
    SQLTIME(92, "SQLTIME", Time.class),
    SQLTIMESTAMP(93, "SQLTIMESTAMP", Timestamp.class),
    TINYINT(-6, "TINYINT", Byte.class),
    SMALLINT(5, "SMALLINT", Short.class),
    INTEGER(4, "INTEGER", Integer.class),
    LONG(-5, "LONG", Long.class),
    BIGINT(-5, "BIGINT", BigInteger.class),
    REAL(7, "REAL", Float.class),
    DOUBLE(8, "DOUBLE", Double.class),
    FLOAT(6, "FLOAT", Float.class),
    NUMERIC(2, "NUMERIC", BigDecimal.class),
    DECIMAL(3, "DECIMAL", BigDecimal.class),
    BOOLEAN(16, "BOOLEAN", Boolean.class),
    BINARY(-2, "BINARY", byte[].class),
    VARBINARY(-3, "VARBINARY", byte[].class),
    LONGVARBINARY(-4, "LONGVARBINARY", byte[].class),
    CLOB(2005, "CLOB", String.class),
    BLOB(2004, "BLOB", byte[].class),
    BIT(-7, "BIT", byte[].class),
    EVENT(1111, "EVENT", ImmutableEventDatagram.class),
    ARRAY(2003, "ARRAY", Object[].class),
    URL(1111, "URL", URL.class),
    OTHER(1111, "OTHER", Object.class),
    DATE(1111, "DATE", java.util.Date.class),
    FLOB(1119, "FLOB", byte[].class),
    FACETS(1122, "FACETS", Facets.class),
    ASPECTS(1123, "ASPECTS", Aspects.class),
    UTINYINT(-6, "TINYINT", Integer.class),
    USMALLINT(5, "SMALLINT", Integer.class),
    UINTEGER(4, "INTEGER UNSIGNED", Long.class),
    UBIGINT(-5, "BIGINT UNSIGNED", BigInteger.class);

    private static Map<Integer, SQLType> typeMap;
    private static Map<String, SQLType> nameMap;
    private static Map<Class<?>, SQLType> classToType;
    private static Map<Integer, SQLType> typeMapMysql;
    private int id;
    private String name;
    private Class<?> javaClass;

    private SQLType(int id, String name, Class<?> javaClass) {
        this.id = id;
        this.name = name;
        this.javaClass = javaClass;
    }

    public int getType() {
        return this.id;
    }

    public String getTypeName() {
        return this.name;
    }

    public Class<?> getTypeClass() {
        return this.javaClass;
    }

    public static SQLType typeForId(int id) {
        SQLType type = typeMap.get(id);
        if (type == null) {
            type = OTHER;
        }
        return type;
    }

    public static SQLType typeForId(int columnType, String columnTypeName, String columnClassName) {
        SQLType type = typeMapMysql.get(columnType);
        if (type != null && type.getTypeClass().getName().equals(columnClassName) && type.getTypeName().equals(columnTypeName.toLowerCase())) {
            return type;
        }
        return SQLType.typeForId(columnType);
    }

    public static SQLType typeForName(String name) {
        SQLType type = nameMap.get(name.toUpperCase());
        if (type == null) {
            type = OTHER;
        }
        return type;
    }

    public static SQLType typeForClass(Class<?> clazz) {
        SQLType type = classToType.get(clazz);
        if (type == null) {
            type = OTHER;
        }
        return type;
    }

    static {
        typeMap = new HashMap<Integer, SQLType>();
        nameMap = new HashMap<String, SQLType>();
        classToType = new HashMap();
        typeMapMysql = new HashMap<Integer, SQLType>();
        classToType.put(String.class, VARCHAR);
        classToType.put(Date.class, SQLDATE);
        classToType.put(Time.class, SQLTIME);
        classToType.put(Timestamp.class, SQLTIMESTAMP);
        classToType.put(Byte.class, TINYINT);
        classToType.put(Short.class, SMALLINT);
        classToType.put(Integer.class, INTEGER);
        classToType.put(Long.class, LONG);
        classToType.put(BigInteger.class, BIGINT);
        classToType.put(Float.class, REAL);
        classToType.put(Double.class, DOUBLE);
        classToType.put(BigDecimal.class, DECIMAL);
        classToType.put(Boolean.class, BOOLEAN);
        classToType.put(byte[].class, VARBINARY);
        classToType.put(byte[].class, LONGVARBINARY);
        classToType.put(Clob.class, CLOB);
        classToType.put(Blob.class, BLOB);
        classToType.put(ImmutableEventDatagram.class, EVENT);
        classToType.put(Object[].class, ARRAY);
        classToType.put(Facets.class, FACETS);
        classToType.put(Aspects.class, ASPECTS);
        typeMap.put(CHAR.getType(), CHAR);
        typeMap.put(VARCHAR.getType(), VARCHAR);
        typeMap.put(LONGVARCHAR.getType(), LONGVARCHAR);
        typeMap.put(NCHAR.getType(), NCHAR);
        typeMap.put(NVARCHAR.getType(), NVARCHAR);
        typeMap.put(LONGNVARCHAR.getType(), LONGNVARCHAR);
        typeMap.put(SQLDATE.getType(), SQLDATE);
        typeMap.put(SQLTIME.getType(), SQLTIME);
        typeMap.put(SQLTIMESTAMP.getType(), SQLTIMESTAMP);
        typeMap.put(TINYINT.getType(), TINYINT);
        typeMap.put(SMALLINT.getType(), SMALLINT);
        typeMap.put(INTEGER.getType(), INTEGER);
        typeMap.put(BIGINT.getType(), BIGINT);
        typeMap.put(REAL.getType(), REAL);
        typeMap.put(FLOAT.getType(), FLOAT);
        typeMap.put(DOUBLE.getType(), DOUBLE);
        typeMap.put(NUMERIC.getType(), NUMERIC);
        typeMap.put(DECIMAL.getType(), DECIMAL);
        typeMap.put(BOOLEAN.getType(), BOOLEAN);
        typeMap.put(BINARY.getType(), BINARY);
        typeMap.put(VARBINARY.getType(), VARBINARY);
        typeMap.put(LONGVARBINARY.getType(), LONGVARBINARY);
        typeMap.put(CLOB.getType(), CLOB);
        typeMap.put(BLOB.getType(), BLOB);
        typeMap.put(BIT.getType(), BIT);
        typeMap.put(ARRAY.getType(), ARRAY);
        typeMap.put(OTHER.getType(), OTHER);
        typeMap.put(FLOB.getType(), FLOB);
        typeMap.put(FACETS.getType(), FACETS);
        typeMap.put(ASPECTS.getType(), ASPECTS);
        typeMap.put(50, ARRAY);
        nameMap.put("CHARACTER", CHAR);
        nameMap.put("CHAR", CHAR);
        nameMap.put("VARCHAR", VARCHAR);
        nameMap.put("LONGVARCHAR", LONGVARCHAR);
        nameMap.put("NCHAR", NCHAR);
        nameMap.put("NVARCHAR", NVARCHAR);
        nameMap.put("LONGNVARCHAR", LONGNVARCHAR);
        nameMap.put("DATE", SQLDATE);
        nameMap.put("TIME", SQLTIME);
        nameMap.put("TIMESTAMP", SQLTIMESTAMP);
        nameMap.put("TINYINT", TINYINT);
        nameMap.put("SMALLINT", SMALLINT);
        nameMap.put("INTEGER", INTEGER);
        nameMap.put("INT", INTEGER);
        nameMap.put("BIGINT", BIGINT);
        nameMap.put("REAL", REAL);
        nameMap.put("FLOAT", FLOAT);
        nameMap.put("DOUBLE", DOUBLE);
        nameMap.put("NUMERIC", NUMERIC);
        nameMap.put("DECIMAL", DECIMAL);
        nameMap.put("BOOLEAN", BOOLEAN);
        nameMap.put("BINARY", BINARY);
        nameMap.put("VARBINARY", VARBINARY);
        nameMap.put("LONGVARBINARY", LONGVARBINARY);
        nameMap.put("CLOB", CLOB);
        nameMap.put("BLOB", BLOB);
        nameMap.put("BIT", BIT);
        nameMap.put("OTHER", OTHER);
        nameMap.put("EVENT", EVENT);
        nameMap.put("STRING", STRING);
        nameMap.put("CATEGORY", CATEGORY);
        nameMap.put("ARRAY", ARRAY);
        nameMap.put("URL", URL);
        nameMap.put("FACETS", FACETS);
        nameMap.put("ASPECTS", ASPECTS);
        nameMap.put("FLOB", FLOB);
        typeMapMysql.put(UTINYINT.getType(), UTINYINT);
        typeMapMysql.put(USMALLINT.getType(), USMALLINT);
        typeMapMysql.put(UINTEGER.getType(), UINTEGER);
        typeMapMysql.put(UBIGINT.getType(), UBIGINT);
    }
}

