/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.lib.utils.ArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrderedMap<K, V>
extends HashMap<K, V> {
    private ArraySet<K> keyOrder = new ArraySet();
    private List<V> valueOrder = new ArrayList<V>();

    public OrderedMap() {
    }

    public OrderedMap(Map<K, V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.keyOrder.clear();
        this.valueOrder.clear();
    }

    @Override
    public V put(K key, V value) {
        int idx = this.keyOrder.lastIndexOf(key);
        if (idx == -1) {
            this.keyOrder.add(key);
            this.valueOrder.add(value);
        } else {
            this.valueOrder.set(idx, value);
        }
        return super.put(key, value);
    }

    @Override
    public V remove(Object key) {
        int idx = this.keyOrder.lastIndexOf(key);
        if (idx != -1) {
            this.keyOrder.remove(idx);
            this.valueOrder.remove(idx);
        }
        return super.remove(key);
    }

    @Override
    public Set<K> keySet() {
        return new ArraySet<K>(this.keyOrder);
    }

    @Override
    public Collection<V> values() {
        return new ArrayList<V>(this.valueOrder);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Map.Entry[] entries = new Map.Entry[this.size()];
        Iterator iterator = super.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            entries[this.keyOrder.indexOf(entry.getKey())] = entry = iterator.next();
        }
        ArraySet<Map.Entry<K, V>> result = new ArraySet<Map.Entry<K, V>>();
        result.addAll(Arrays.asList(entries));
        return result;
    }
}

