/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.Trace;
import com.streamscape.lib.utils.CryptoUtils;
import com.streamscape.lib.utils.RandomGenerator;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.globals.UnresolvedVariableException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.MetricAdvisory;
import com.streamscape.sdo.advisory.StateAdvisory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.Moderator;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacroProcessor {
    private static final Character MACROS_NAME_BEGIN = Character.valueOf('$');
    private static final Character MACROS_NAME_END = Character.valueOf(':');
    private static final Character MACROS_PARAM_START = Character.valueOf('(');
    private static final Character MACROS_PARAM_END = Character.valueOf(')');
    private static final Pattern MACRO_PATTERN = Pattern.compile(".*\\$\\w+:\\([^\\)]*\\).*");
    private boolean staticMode = false;
    private ImmutableEventDatagram event = null;
    private Moderator moderator;

    public MacroProcessor() {
        this(RuntimeContext.isInitialized() ? RuntimeContext.getInstance().getModerator() : null);
    }

    public MacroProcessor(Moderator moderator) {
        this.moderator = moderator;
    }

    public synchronized String process(String source) {
        return this.process(source, false);
    }

    protected String process(String source, boolean inStatic) {
        String replacement;
        int macroParamEnd;
        int macroStart;
        Object resultString;
        block49: {
            if (source == null) {
                return null;
            }
            resultString = source;
            macroStart = ((String)resultString).indexOf(MACROS_NAME_BEGIN.charValue());
            if (macroStart == -1) {
                return source;
            }
            int macroEnd = ((String)resultString).indexOf(MACROS_NAME_END.charValue(), macroStart);
            if (macroEnd == -1) {
                return source;
            }
            String macroName = ((String)resultString).substring(macroStart + 1, macroEnd).toLowerCase();
            macroParamEnd = -1;
            String parameter = null;
            int macroParamStart = ((String)resultString).indexOf(MACROS_PARAM_START.charValue(), macroEnd + 1);
            if (macroParamStart == -1) {
                if (!macroName.equals("hostname")) {
                    return source;
                }
                macroParamEnd = macroEnd - 1;
            } else {
                macroParamEnd = ((String)resultString).indexOf(MACROS_PARAM_END.charValue(), macroParamStart + 1);
                if (macroParamEnd == -1) {
                    return source;
                }
                int nextMacro = ((String)resultString).indexOf(MACROS_NAME_BEGIN.charValue(), macroParamStart + 1);
                if (nextMacro != -1) {
                    boolean temp = nextMacro < macroParamEnd && macroName.equals("static");
                    macroParamEnd = ((String)(resultString = ((String)resultString).substring(0, nextMacro) + this.process(source.substring(nextMacro), temp))).indexOf(MACROS_PARAM_END.charValue(), macroEnd + 2);
                    if (macroParamEnd == -1) {
                        return source;
                    }
                }
                parameter = ((String)resultString).substring(macroEnd + 2, macroParamEnd);
            }
            replacement = null;
            if (macroName.equals("datetime")) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(parameter);
                replacement = dateFormat.format(new Date());
            } else if (macroName.equals("system")) {
                replacement = System.getProperty(parameter);
                if (replacement == null) {
                    replacement = System.getenv(parameter);
                }
            } else if (macroName.equals("rand")) {
                replacement = Long.toString(RandomGenerator.generateUniqueID());
            } else if (macroName.equals("password")) {
                replacement = parameter;
            } else if (macroName.equals("hostname")) {
                if (StringUtils.isEmpty(parameter)) {
                    try {
                        replacement = InetAddress.getLocalHost().getHostName();
                    }
                    catch (Exception exception) {
                        Trace.logException(this, exception, true);
                        Trace.logError(this, "Wrong use of macros $hostname:[(<interfaceId>)].");
                    }
                } else {
                    try {
                        NetworkInterface nic = null;
                        try {
                            nic = NetworkInterface.getByIndex(Integer.parseInt(parameter));
                        }
                        catch (NumberFormatException exception) {
                            nic = NetworkInterface.getByName(parameter);
                        }
                        if (nic != null) {
                            Enumeration<InetAddress> addresses = nic.getInetAddresses();
                            while (replacement == null && addresses.hasMoreElements()) {
                                InetAddress address = addresses.nextElement();
                                if (!(address instanceof Inet4Address)) continue;
                                replacement = address.getHostName();
                            }
                            if (replacement == null) {
                                Trace.logError(this, "Interface with index/name " + parameter + " '" + nic.getDisplayName() + "' does not have IPv4 address.");
                            }
                            break block49;
                        }
                        Trace.logError(this, "Interface with index/name " + parameter + " does not exist.");
                    }
                    catch (Exception exception) {
                        Trace.logException(this, exception, true);
                        Trace.logError(this, "Wrong use of macros $hostname:[(<interfaceId>)].");
                    }
                }
            } else if (macroName.equals("guid")) {
                UUID uuid = UUID.randomUUID();
                replacement = uuid.toString();
            } else if (macroName.equals("gvar")) {
                try {
                    replacement = this.resolveGVariable(parameter);
                }
                catch (UnresolvedVariableException exception) {
                    Trace.logError(MacroProcessor.class, "Unable to resolve '" + parameter + "' global variable.");
                }
            } else if (macroName.equals("hash")) {
                try {
                    replacement = CryptoUtils.calculateDigest(parameter.getBytes(), "MD5");
                }
                catch (Exception error) {
                    Trace.logException(MacroProcessor.class, error, true);
                }
            } else if (macroName.equals("static")) {
                resultString = ((String)resultString).substring(0, macroStart) + parameter + ((String)resultString).substring(macroParamEnd + 1);
            } else if (macroName.equals("event")) {
                replacement = this.resolveEvent(parameter);
            } else if (macroName.equals("seqid")) {
                // empty if block
            }
        }
        if (this.staticMode && !inStatic) {
            return resultString;
        }
        if (replacement != null) {
            resultString = ((String)resultString).substring(0, macroStart) + replacement + ((String)resultString).substring(macroParamEnd + 1);
            if (inStatic || !this.staticMode) {
                return this.process((String)resultString, false);
            }
        }
        return resultString;
    }

    protected String resolveGVariable(String gvar) throws UnresolvedVariableException {
        return VariableFactory.getVariable(gvar);
    }

    private String resolveEvent(String parameter) {
        try {
            Object result;
            EventMacroSystemParams systemParam = null;
            try {
                systemParam = EventMacroSystemParams.valueOf(parameter);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (this.event instanceof MapEvent && (result = ((MapEvent)this.event).getObject(parameter)) != null) {
                return result.toString();
            }
            if (this.event instanceof EventDatagram) {
                EventDatagram eventDatagram = (EventDatagram)this.event;
                Object result2 = eventDatagram.getEventObjectProperty(parameter);
                if (result2 != null) {
                    return result2.toString();
                }
                if (systemParam != null) {
                    return this.resolveSystemProperty(systemParam, eventDatagram);
                }
            } else if (this.event instanceof StateAdvisory) {
                StateAdvisory stateAdvisory = (StateAdvisory)this.event;
                String result3 = stateAdvisory.getProperty(parameter);
                if (result3 != null) {
                    return result3;
                }
                if (systemParam != null) {
                    return this.resolveSystemProperty(systemParam, stateAdvisory);
                }
            } else if (this.event instanceof AdvisoryEventDatagram) {
                if (systemParam != null) {
                    return this.resolveSystemProperty(systemParam, (AdvisoryEventDatagram)this.event);
                }
            } else if (this.event instanceof ExceptionEventDatagram && systemParam != null) {
                return this.resolveSystemProperty(systemParam, (ExceptionEventDatagram)this.event);
            }
        }
        catch (Exception error) {
            Trace.logException(MacroProcessor.class, error, true);
        }
        return null;
    }

    public synchronized void setEvent(ImmutableEventDatagram event) {
        this.event = event;
    }

    public synchronized String processStaticMacro(String source) {
        this.staticMode = true;
        String result = this.process(source);
        this.staticMode = false;
        return result;
    }

    public static boolean isMacro(String source) {
        Matcher matcher = MACRO_PATTERN.matcher(source);
        return matcher.find();
    }

    private String resolveSystemProperty(EventMacroSystemParams systemProperty, EventDatagram event) {
        switch (systemProperty.ordinal()) {
            case 1: {
                return event.getEventId();
            }
            case 4: {
                return event.getCorrelationId();
            }
            case 3: {
                return event.getEventGroupId();
            }
            case 2: {
                return event.getEventKey();
            }
            case 6: {
                return event.getForwardTo();
            }
            case 5: {
                return event.getReplyTo();
            }
            case 0: {
                if (event.getEventSource() != null) {
                    ComponentReference component;
                    FabricAddress source = new FabricAddress(event.getEventSource());
                    if (this.moderator == null) {
                        this.moderator = RuntimeContext.getInstance().getModerator();
                    }
                    String sourceName = (component = this.moderator.lookupComponent(source)) != null ? component.getName() : "Unknown";
                    return sourceName;
                }
            }
            case 8: {
                return new Date(event.getEventExpiration()).toString();
            }
            case 7: {
                Date timestamp = event.getTimestamp();
                if (timestamp == null) break;
                return timestamp.toString();
            }
        }
        return null;
    }

    private String resolveSystemProperty(EventMacroSystemParams systemProperty, ExceptionEventDatagram exception) {
        switch (systemProperty.ordinal()) {
            case 1: {
                return exception.getEventId();
            }
            case 4: {
                return exception.getCorrelationId();
            }
            case 3: {
                return exception.getEventGroupId();
            }
            case 2: {
                return exception.getEventKey();
            }
            case 5: {
                return exception.getReplyTo();
            }
            case 0: {
                if (exception.getEventSource() != null) {
                    ComponentReference component;
                    FabricAddress source = new FabricAddress(exception.getEventSource());
                    if (this.moderator == null) {
                        this.moderator = RuntimeContext.getInstance().getModerator();
                    }
                    String sourceName = (component = this.moderator.lookupComponent(source)) != null ? component.getName() : "Unknown";
                    return sourceName;
                }
            }
            case 7: {
                Date timestamp = exception.getTimestamp();
                if (timestamp != null) {
                    return timestamp.toString();
                }
            }
            case 9: {
                return Integer.toString(exception.getErrorCode());
            }
            case 10: {
                return exception.getErrorMessage();
            }
            case 11: {
                return exception.getSeverity().name();
            }
        }
        return null;
    }

    private String resolveSystemProperty(EventMacroSystemParams systemProperty, AdvisoryEventDatagram advisory) {
        switch (systemProperty.ordinal()) {
            case 1: {
                return advisory.getEventId();
            }
            case 4: {
                return advisory.getCorrelationId();
            }
            case 3: {
                return advisory.getEventGroupId();
            }
            case 2: {
                return advisory.getEventKey();
            }
            case 0: {
                if (advisory.getEventSource() != null) {
                    ComponentReference component;
                    FabricAddress source = new FabricAddress(advisory.getEventSource());
                    if (this.moderator == null) {
                        this.moderator = RuntimeContext.getInstance().getModerator();
                    }
                    String sourceName = (component = this.moderator.lookupComponent(source)) != null ? component.getName() : "Unknown";
                    return sourceName;
                }
            }
            case 7: {
                Date timestamp = advisory.getTimestamp();
                if (timestamp != null) {
                    return timestamp.toString();
                }
            }
            case 12: {
                if (!(advisory instanceof StateAdvisory)) break;
                return ((StateAdvisory)advisory).getName();
            }
            case 14: {
                if (!(advisory instanceof StateAdvisory)) break;
                return ((StateAdvisory)advisory).getType().toString();
            }
            case 13: {
                if (!(advisory instanceof StateAdvisory)) break;
                return ((StateAdvisory)advisory).getMessage();
            }
            case 15: {
                if (!(advisory instanceof MetricAdvisory)) break;
                return ((MetricAdvisory)advisory).getAdvisoryMessage();
            }
            case 16: {
                if (!(advisory instanceof MetricAdvisory)) break;
                return Long.toString(((MetricAdvisory)advisory).getMaxThreshold());
            }
            case 17: {
                if (!(advisory instanceof MetricAdvisory)) break;
                return Long.toString(((MetricAdvisory)advisory).getMinThreshold());
            }
            case 19: {
                if (!(advisory instanceof MetricAdvisory)) break;
                return ((MetricAdvisory)advisory).getUnits().name();
            }
            case 18: {
                if (!(advisory instanceof MetricAdvisory)) break;
                return Long.toString(((MetricAdvisory)advisory).getValue());
            }
        }
        return null;
    }

    public static boolean isGlobalVariable(String value) {
        if (value == null) {
            return false;
        }
        return (value = value.trim()).startsWith("$gvar:(") && value.endsWith(")");
    }

    public static enum EventMacroSystemParams {
        EventSource,
        EventId,
        EventKey,
        EventGroupId,
        CorrelationId,
        EventReplyTo,
        EventForwardTo,
        Timestamp,
        EventExpiration,
        ErrorCode,
        ErrorMessage,
        Severity,
        StateAdvisoryName,
        StateAdvisoryMessage,
        StateAdvisoryType,
        MetricAdvisoryMessage,
        MetricMaxThreshold,
        MetricMinThreshold,
        MetricValue,
        MetricUnits;

    }
}

