/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.Trace;
import com.streamscape.omf.xml.xstream.converters.reflection.PureJavaReflectionProvider;
import com.streamscape.omf.xml.xstream.converters.reflection.ReflectionProvider;
import com.streamscape.omf.xml.xstream.converters.reflection.Sun14ReflectionProvider;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;

public class JVM {
    private ReflectionProvider reflectionProvider;
    private transient Map<String, WeakReference> loaderCache = new HashMap<String, WeakReference>();
    private final boolean supportsAWT = this.loadClass("java.awt.Color") != null;
    private final boolean supportsSwing = this.loadClass("javax.swing.LookAndFeel") != null;
    private final boolean supportsSQL = this.loadClass("java.sql.Date") != null;
    private static final String NAME = System.getProperty("java.vm.name");
    private static final String VENDOR = System.getProperty("java.vm.vendor");
    private static final float MAJOR_JAVA_VERSION = JVM.getMajorJavaVersion();
    private static final boolean REVERSE_FIELD_ORDER = JVM.isHarmony() || JVM.isIBM() && !JVM.is1_5();
    private static final String OS_NAME = ManagementFactory.getOperatingSystemMXBean().getName();
    private static final float DEFAULT_JAVA_VERSION = 1.8f;

    public static String getPrimaryHostName(boolean suppressException) {
        block3: {
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                if (localhost != null) {
                    return localhost.getHostName();
                }
            }
            catch (UnknownHostException exception) {
                if (suppressException) break block3;
                Trace.logException(JVM.class, exception, true);
            }
        }
        return "unresolved";
    }

    public static String getOSVersion() {
        return "(" + OS_NAME + ", " + System.getProperty("os.arch") + "-" + System.getProperty("os.version") + ")";
    }

    public static String getJVMInfo() {
        return System.getProperty("java.runtime.name");
    }

    public static String getJVMName() {
        return NAME + " (build " + System.getProperty("java.runtime.version") + ", " + System.getProperty("java.vm.info") + ")";
    }

    public static String getJVMNVendorHome() {
        return VENDOR + " (home: " + System.getProperty("java.home") + ")";
    }

    protected static float getMajorJavaVersion() {
        try {
            return Float.parseFloat(System.getProperty("java.specification.version"));
        }
        catch (NumberFormatException e) {
            return 1.8f;
        }
    }

    public static boolean is1_4() {
        return MAJOR_JAVA_VERSION >= 1.4f;
    }

    public static boolean is1_5() {
        return MAJOR_JAVA_VERSION >= 1.5f;
    }

    public static boolean is1_6() {
        return MAJOR_JAVA_VERSION >= 1.6f;
    }

    public static boolean is1_7() {
        return MAJOR_JAVA_VERSION >= 1.7f;
    }

    public static boolean is1_8() {
        return MAJOR_JAVA_VERSION >= 1.8f;
    }

    public static boolean is9() {
        return MAJOR_JAVA_VERSION >= 9.0f;
    }

    public static boolean is10() {
        return MAJOR_JAVA_VERSION >= 10.0f;
    }

    public static boolean is11() {
        return MAJOR_JAVA_VERSION >= 11.0f;
    }

    public static boolean is14() {
        return MAJOR_JAVA_VERSION >= 14.0f;
    }

    public static boolean isOracle() {
        return VENDOR.contains("Oracle");
    }

    public static boolean isSun() {
        return VENDOR.contains("Sun");
    }

    public static boolean isApple() {
        return VENDOR.contains("Apple");
    }

    public static boolean isRedHat() {
        return VENDOR.contains("Red Hat");
    }

    public static boolean isIBM() {
        return VENDOR.contains("IBM");
    }

    public static boolean isAndroid() {
        return VENDOR.contains("Android");
    }

    public static boolean isJRockit() {
        return NAME.contains("JRockit");
    }

    private static boolean isHPUX() {
        return VENDOR.contains("Hewlett-Packard Company");
    }

    private static boolean isBlackdown() {
        return VENDOR.contains("Blackdown");
    }

    private static boolean isDiablo() {
        return VENDOR.contains("FreeBSD Foundation");
    }

    private static boolean isHarmony() {
        return VENDOR.contains("Apache Software Foundation");
    }

    public static int getNumberOfCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static boolean isBEAWithUnsafeSupport() {
        if (VENDOR.contains("BEA")) {
            String vmVersion = System.getProperty("java.vm.version");
            if (vmVersion.startsWith("R")) {
                return true;
            }
            String vmInfo = System.getProperty("java.vm.info");
            if (vmInfo != null) {
                return vmInfo.startsWith("R25.1") || vmInfo.startsWith("R25.2");
            }
        }
        return false;
    }

    private static boolean isHitachi() {
        return VENDOR.contains("Hitachi");
    }

    private static boolean isSAP() {
        return VENDOR.contains("SAP AG");
    }

    public Class loadClass(String name) {
        try {
            Class cached;
            WeakReference reference = this.loaderCache.get(name);
            if (reference != null && (cached = (Class)reference.get()) != null) {
                return cached;
            }
            Class<?> clazz = Class.forName(name, false, this.getClass().getClassLoader());
            this.loaderCache.put(name, new WeakReference(clazz));
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected String getBestReflectionProviderName() {
        return this.bestReflectionProvider().getClass().getSimpleName();
    }

    public synchronized ReflectionProvider bestReflectionProvider() {
        if (this.reflectionProvider == null) {
            try {
                if (this.canUseSun14ReflectionProvider()) {
                    String cls = Sun14ReflectionProvider.class.getName();
                    this.reflectionProvider = (ReflectionProvider)this.loadClass(cls).newInstance();
                }
                if (this.reflectionProvider == null) {
                    this.reflectionProvider = new PureJavaReflectionProvider();
                }
            }
            catch (InstantiationException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (IllegalAccessException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (AccessControlException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
        }
        return this.reflectionProvider;
    }

    protected boolean canUseSun14ReflectionProvider() {
        return JVM.is1_4() && this.loadClass("sun.misc.Unsafe") != null;
    }

    protected boolean canUseHarmonyReflectionProvider() {
        return JVM.isHarmony();
    }

    public static boolean reverseFieldDefinition() {
        return REVERSE_FIELD_ORDER;
    }

    public boolean supportsAWT() {
        return this.supportsAWT;
    }

    public boolean supportsSwing() {
        return this.supportsSwing;
    }

    public boolean supportsSQL() {
        return this.supportsSQL;
    }

    public static String getOSName() {
        return OS_NAME;
    }

    public static boolean isWindowsOS() {
        return OS_NAME.toLowerCase().contains("windows");
    }

    public static boolean isWindows10OS() {
        return OS_NAME.toLowerCase().contains("windows 10");
    }

    public static boolean isMacOS() {
        return OS_NAME.toLowerCase().contains("mac");
    }

    public static boolean isSolarisOS() {
        return OS_NAME.toLowerCase().contains("sun") || OS_NAME.toLowerCase().contains("solaris");
    }

    public static boolean isLinuxOS() {
        return OS_NAME.toLowerCase().contains("linux");
    }

    private Object readResolve() {
        this.loaderCache = new HashMap<String, WeakReference>();
        return this;
    }

    public static String getJVMVendor() {
        return VENDOR;
    }

    public static void main(String[] args) {
        int i;
        boolean reverse = false;
        Field[] fields = AttributedString.class.getDeclaredFields();
        for (i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals("text")) continue;
            reverse = i > 3;
            break;
        }
        if (reverse) {
            fields = JVM.class.getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals("reflectionProvider")) continue;
                reverse = i > 2;
                break;
            }
        }
        JVM jvm = new JVM();
        System.out.println("Fabric Runtime JVM Diagnostics");
        System.out.println("------------------------------");
        System.out.println("java.specification.version: " + System.getProperty("java.specification.version"));
        System.out.println("java.vm.vendor: " + VENDOR);
        System.out.println("Version: " + MAJOR_JAVA_VERSION);
        System.out.println("Supports Serializer Enhanced Mode: " + (jvm.canUseSun14ReflectionProvider() || jvm.canUseHarmonyReflectionProvider()));
        System.out.println("Supports AWT: " + jvm.supportsAWT());
        System.out.println("Supports Swing: " + jvm.supportsSwing());
        System.out.println("Supports SQL: " + jvm.supportsSQL());
        System.out.println("Reverse field order detected (may have failed): " + reverse);
    }
}

