/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JARUtils {
    public static Vector getClassNamesBySuperFromJarFile(String jarFileName, String superClassName) throws UtilitiesException {
        Object classNameList = null;
        Object obj = null;
        Enumeration<JarEntry> jarEntries = null;
        Vector<String> classesList = new Vector<String>();
        if (!FileIOUtils.fileReadable(jarFileName)) {
            throw new UtilitiesException("JAR File Access Exception: File cannot be read : '" + jarFileName + "'.");
        }
        try {
            JarFile jarFile = new JarFile(jarFileName);
            jarEntries = jarFile.entries();
        }
        catch (IOException ex) {
            throw new UtilitiesException("JAR File I/O Exception: " + ex.getMessage());
        }
        while (jarEntries.hasMoreElements()) {
            ZipEntry zipEntry = jarEntries.nextElement();
            String zipEntryName = zipEntry.getName();
            if (!zipEntryName.endsWith(".class") || zipEntryName.lastIndexOf("$") != -1) continue;
            zipEntryName = zipEntryName.replace('\\', '.');
            zipEntryName = zipEntryName.replace('/', '.');
            zipEntryName = zipEntryName.substring(0, zipEntryName.length() - 6);
            try {
                obj = Class.forName(zipEntryName).newInstance();
                if (!obj.getClass().getSuperclass().getName().equals(superClassName.trim())) continue;
                classesList.addElement(zipEntryName);
            }
            catch (ClassNotFoundException ex) {
                throw new UtilitiesException("ClassNotFoundException.. could not load JAR Entry: " + zipEntryName);
            }
            catch (IllegalAccessException ex) {
                throw new UtilitiesException("IllegalAccessException.. could not load  JAR Entry: " + zipEntryName);
            }
            catch (InstantiationException ex) {
                throw new UtilitiesException("InstantiationException.. could not load  JAR Entry: " + zipEntryName);
            }
            catch (NoClassDefFoundError ex) {
                throw new UtilitiesException("NoClassDefFoundError.. could not load  JAR Entry: " + zipEntryName);
            }
        }
        return classesList;
    }

    public static Vector getClassNamesFromJarFile(String jarFileName) throws UtilitiesException {
        Object classNameList = null;
        Enumeration<JarEntry> jarEntries = null;
        Vector<String> classesList = new Vector<String>();
        if (!FileIOUtils.fileReadable(jarFileName)) {
            throw new UtilitiesException("JAR File Access Exception: File cannot be read : '" + jarFileName + "'.");
        }
        try {
            JarFile jarFile = new JarFile(jarFileName);
            jarEntries = jarFile.entries();
        }
        catch (IOException ex) {
            throw new UtilitiesException("JAR File I/O Exception: " + ex.getMessage());
        }
        while (jarEntries.hasMoreElements()) {
            ZipEntry zipEntry = jarEntries.nextElement();
            String zipEntryName = zipEntry.getName();
            if (!zipEntryName.endsWith(".class")) continue;
            zipEntryName = zipEntryName.replace('\\', '.');
            zipEntryName = zipEntryName.replace('/', '.');
            zipEntryName = zipEntryName.substring(0, zipEntryName.length() - 6);
            classesList.addElement(zipEntryName);
        }
        return classesList;
    }

    public static Vector getEntriesFromJarFile(String jarFileName) throws UtilitiesException {
        Object classNameList = null;
        Enumeration<JarEntry> jarEntries = null;
        Vector<String> classesList = new Vector<String>();
        if (!FileIOUtils.fileReadable(jarFileName)) {
            throw new UtilitiesException("JAR File Access Exception: File cannot be read : '" + jarFileName + "'.");
        }
        try {
            JarFile jarFile = new JarFile(jarFileName);
            jarEntries = jarFile.entries();
        }
        catch (IOException ex) {
            throw new UtilitiesException("JAR File I/O Exception: " + ex.getMessage());
        }
        while (jarEntries.hasMoreElements()) {
            ZipEntry zipEntry = jarEntries.nextElement();
            String zipEntryName = zipEntry.getName();
            classesList.addElement(zipEntryName);
        }
        return classesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<String, byte[]> getEntriesMapFromJarFile(String jarFileName) throws UtilitiesException {
        LinkedHashMap<String, byte[]> entries = new LinkedHashMap<String, byte[]>();
        JarFile jarFileWrapper = null;
        File jarFile = null;
        if (!FileIOUtils.fileReadable(jarFileName)) {
            throw new UtilitiesException("JAR File Access Exception: File cannot be read : '" + jarFileName + "'.");
        }
        jarFile = FileIOUtils.openFile(jarFileName);
        if (jarFile != null) {
            try {
                jarFileWrapper = new JarFile(jarFile);
                Enumeration<JarEntry> iter = jarFileWrapper.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry zipEntry = iter.nextElement();
                    InputStream entryStream = jarFileWrapper.getInputStream(zipEntry);
                    try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
                        FileIOUtils.copy(entryStream, (OutputStream)byteArrayStream);
                        entries.put(zipEntry.getName(), byteArrayStream.toByteArray());
                    }
                }
            }
            catch (IOException ex) {
                throw new UtilitiesException("JAR File I/O Exception: " + ex.getMessage());
            }
            finally {
                if (jarFileWrapper != null) {
                    try {
                        jarFileWrapper.close();
                    }
                    catch (IOException ex) {
                        throw new UtilitiesException("JAR File I/O Exception: " + ex.getMessage());
                    }
                }
            }
        }
        return entries;
    }

    public static void appendJarFileEntries(String jarFileName, LinkedHashMap entries) throws Exception {
        File jarFile = null;
        if (entries != null) {
            LinkedHashMap<String, byte[]> combinedEntries = JARUtils.getEntriesMapFromJarFile(jarFileName);
            combinedEntries.putAll(entries);
            File tmpJarFile = File.createTempFile(jarFileName, null);
            JARUtils.createNewJarFromEntriesMap(tmpJarFile, combinedEntries);
            jarFile = FileIOUtils.openFile(jarFileName);
            jarFile.delete();
            tmpJarFile.renameTo(jarFile);
        }
    }

    public static void extractJarToDirectory(String jarURL, String jarEntry, String outDir, boolean keepParentDirectory) throws UtilitiesException {
        File dir = null;
        String jarName = null;
        JarURLConnection jarConnection = null;
        JarFile jarFile = null;
        Enumeration<JarEntry> entries = null;
        InputStream inputStream = null;
        BufferedOutputStream outputStream = null;
        int jarResourceNameLenght = 0;
        try {
            block22: {
                String path;
                File file;
                jarName = (jarEntry == null || jarEntry.equals("")) && jarURL.endsWith(".jar") ? jarURL + "!/" : jarURL + "!/" + jarEntry;
                dir = FileIOUtils.newFile(outDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                jarConnection = (JarURLConnection)new URL(jarName).openConnection();
                jarFile = jarConnection.getJarFile();
                if (jarConnection.getJarEntry() == null) break block22;
                JarEntry entry = jarConnection.getJarEntry();
                String name = entry.getName();
                if (!keepParentDirectory) {
                    name = name.substring(name.lastIndexOf(47) + 1);
                }
                if (!(file = FileIOUtils.newFile(path = dir.getAbsolutePath() + File.separator + name)).getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    throw new UtilitiesException("JAR extraction error: Could not create directory: " + String.valueOf(file.getParentFile()));
                }
                try {
                    inputStream = jarFile.getInputStream(entry);
                    outputStream = new BufferedOutputStream(new FileOutputStream(file));
                    FileIOUtils.copy(inputStream, (OutputStream)outputStream);
                }
                catch (IOException ex) {
                    try {
                        throw new UtilitiesException("JAR extraction error: " + ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        FileIOUtils.closeQuietly(inputStream);
                        FileIOUtils.closeQuietly(outputStream);
                        throw throwable;
                    }
                }
                FileIOUtils.closeQuietly(inputStream);
                FileIOUtils.closeQuietly(outputStream);
                return;
            }
            entries = jarFile.entries();
        }
        catch (IOException ex) {
            throw new UtilitiesException("JAR extraction error: " + ex.getMessage());
        }
        while (entries.hasMoreElements()) {
            File file;
            JarEntry entry = entries.nextElement();
            String path = dir.getPath() + File.separator + entry.getName();
            System.out.println(" start path: " + path);
            if (!keepParentDirectory) {
                if (entry.isDirectory()) {
                    path = dir.getPath() + File.separator + entry.getName().substring(jarResourceNameLenght, entry.getName().length());
                    System.out.println("dir path: " + path);
                } else if (entry.getName().length() > jarResourceNameLenght) {
                    path = dir.getPath() + File.separator + entry.getName().substring(jarResourceNameLenght, entry.getName().length());
                    System.out.println("entry > path: " + path);
                } else {
                    path = dir.getPath() + File.separator + entry.getName().substring(entry.getName().lastIndexOf("/"), entry.getName().length());
                    System.out.println("entry path: " + path);
                }
            }
            if (!(file = FileIOUtils.newFile(path)).getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new UtilitiesException("JAR extraction error: Could not create directory: " + String.valueOf(file.getParentFile()));
            }
            if (entry.isDirectory()) {
                if (file.exists() || file.mkdirs()) continue;
                throw new UtilitiesException("JAR extraction error: Could not create directory: " + String.valueOf(file));
            }
            try {
                inputStream = jarFile.getInputStream(entry);
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                FileIOUtils.copy(inputStream, (OutputStream)outputStream);
            }
            catch (IOException ex) {
                throw new UtilitiesException("JAR extraction error: " + ex.getMessage());
            }
            finally {
                FileIOUtils.closeQuietly(inputStream);
                FileIOUtils.closeQuietly(outputStream);
            }
        }
    }

    public static void createNewJarFromEntriesMap(File jarFile, LinkedHashMap entries) throws UtilitiesException {
        ZipOutputStream jarStream = null;
        FileOutputStream fileStream = null;
        if (jarFile == null) {
            throw new UtilitiesException("Create Jar file Error: Null file object specified.");
        }
        try {
            fileStream = new FileOutputStream(jarFile);
            jarStream = new JarOutputStream(fileStream);
            if (entries != null && !entries.isEmpty()) {
                for (String jarFilePath : entries.keySet()) {
                    Object content = entries.get(jarFilePath);
                    JarEntry entry = new JarEntry(jarFilePath);
                    ((JarOutputStream)jarStream).putNextEntry(entry);
                    if (content instanceof String) {
                        JARUtils.writeJarEntry((OutputStream)jarStream, ((String)content).getBytes());
                        continue;
                    }
                    if (content instanceof byte[]) {
                        JARUtils.writeJarEntry((OutputStream)jarStream, (byte[])content);
                        continue;
                    }
                    if (!(content instanceof File)) continue;
                    JARUtils.writeJarEntry((OutputStream)jarStream, (File)content);
                }
            }
            jarStream.flush();
            fileStream.getFD().sync();
        }
        catch (Exception e) {
            throw new UtilitiesException("Create Jar file Error: " + e.getMessage());
        }
        finally {
            if (jarStream != null) {
                try {
                    jarStream.close();
                }
                catch (Exception ex) {
                    throw new UtilitiesException("Create Jar file (close) Error: " + ex.getMessage());
                }
            }
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (Exception ex) {
                    throw new UtilitiesException("Create Jar file (close) Error: " + ex.getMessage());
                }
            }
        }
    }

    private static void writeJarEntry(OutputStream stream, byte[] entry) throws UtilitiesException {
        try {
            stream.write(entry, 0, entry.length);
        }
        catch (IOException ex) {
            throw new UtilitiesException(ex);
        }
    }

    private static void writeJarEntry(OutputStream stream, File entry) throws UtilitiesException {
        FileInputStream fileContentStream = null;
        try {
            fileContentStream = new FileInputStream(entry);
            FileIOUtils.copy((InputStream)fileContentStream, stream);
        }
        catch (FileNotFoundException ex) {
            throw new UtilitiesException(ex);
        }
        finally {
            if (fileContentStream != null) {
                try {
                    fileContentStream.close();
                }
                catch (IOException ex) {
                    throw new UtilitiesException(ex);
                }
            }
        }
    }

    public static String[] getClassPath() {
        Object[] classPathList = new String[]{""};
        String pathSep = System.getProperty("path.separator");
        String classPath = System.getProperty("java.class.path");
        StringTokenizer sTokenizer = new StringTokenizer(classPath, pathSep);
        int tokenCount = sTokenizer.countTokens();
        if (tokenCount > 0) {
            classPathList = new String[tokenCount];
        }
        for (int i = 0; i < tokenCount; ++i) {
            classPathList[i] = sTokenizer.nextToken();
        }
        Arrays.sort(classPathList);
        return classPathList;
    }
}

