/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.local.LocalFileSystem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipUtils {
    public static final char ZIP_FILE_SEPARATOR = '/';

    public static void compress(File sourceFile, File targetFile) throws IOException {
        GzipUtils.compress(sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), new LocalFileSystem(), new LocalFileSystem());
    }

    public static void compress(String sourceFile, String targetFile, FileSystem sourceFileSystem, FileSystem targetFileSystem) throws IOException {
        byte[] buffer = new byte[65536];
        try (GZIPOutputStream zip = new GZIPOutputStream(new BufferedOutputStream(targetFileSystem.openForWrite(targetFile)));
             InputStream inputStream = sourceFileSystem.open(sourceFile);){
            int bytes_read;
            while ((bytes_read = inputStream.read(buffer)) > 0) {
                zip.write(buffer, 0, bytes_read);
            }
        }
    }

    public static void extract(File sourcePath, File targetFile) throws IOException {
        GzipUtils.extract(sourcePath.getAbsolutePath(), targetFile.getAbsolutePath(), new LocalFileSystem(), new LocalFileSystem());
    }

    public static void extract(String sourcePath, String targetFile, FileSystem sourceFileSystem, FileSystem targetFileSystem) throws IOException {
        byte[] buffer = new byte[65536];
        try (GZIPInputStream zip = new GZIPInputStream(new BufferedInputStream(sourceFileSystem.open(sourcePath)));
             OutputStream outputStream = targetFileSystem.openForWrite(targetFile);){
            int bytes_read;
            while ((bytes_read = zip.read(buffer)) > 0) {
                outputStream.write(buffer, 0, bytes_read);
            }
        }
    }
}

