/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.Trace;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.FileDirectoryFilter;
import com.streamscape.lib.utils.FileOnlyFilter;
import com.streamscape.lib.utils.JavaInternal;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.lib.utils.Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URLConnection;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class FileIOUtils {
    private static final int BUFFER_SIZE = 4096;
    private static final int LARGE_BUFFER_SIZE = 65536;
    private static final int LOCK_WAIT_PERIOD = 100;
    private static final int LOCK_INFO_PERIOD_COUNT = 20;

    public static boolean fileAvailable(String fileURL) {
        return new File(fileURL).exists();
    }

    public static boolean fileAvailable(URI uri) throws IOException {
        return new File(uri).getCanonicalFile().exists();
    }

    public static boolean fileReadable(String fileURL) {
        File file = new File(fileURL);
        return file.exists() && file.canRead();
    }

    public static boolean fileWritable(String fileURL) {
        File file = new File(fileURL);
        return file.exists() && file.canWrite();
    }

    public static boolean renameFile(String oldURL, String newURL) {
        File oldFile = new File(oldURL);
        return oldFile.exists() && oldFile.renameTo(new File(newURL));
    }

    public static boolean deleteFile(String fileURL) {
        File file = new File(fileURL);
        return file.exists() && file.delete();
    }

    public static boolean deleteFileDir(File filePath) {
        return FileIOUtils.deleteFileDir(filePath, true);
    }

    public static boolean deleteFileDir(File filePath, Set<File> excludedFiles) {
        return FileIOUtils.deleteFileDir(filePath, excludedFiles, true);
    }

    public static boolean deleteFileDir(File filePath, boolean withSymbolicLinks) {
        return FileIOUtils.deleteFileDir(filePath, null, withSymbolicLinks);
    }

    public static boolean deleteFileDir(File filePath, Set<File> excludedFiles, boolean withSymbolicLinks) {
        return FileIOUtils.deleteFileDir(filePath, excludedFiles, withSymbolicLinks, null);
    }

    public static boolean deleteFileDir(File filePath, Set<File> excludedFiles, boolean withSymbolicLinks, Function<String, Boolean> filter) {
        return FileIOUtils.deleteFileDir(filePath, excludedFiles, withSymbolicLinks, filter, true);
    }

    private static boolean deleteFileDir(File filePath, Set<File> excludedFiles, boolean withSymbolicLinks, Function<String, Boolean> filter, boolean firstCall) {
        if (!withSymbolicLinks && Files.isSymbolicLink(filePath.toPath())) {
            return (excludedFiles == null || !excludedFiles.contains(filePath)) && filePath.delete();
        }
        if (excludedFiles == null || !excludedFiles.contains(filePath)) {
            boolean filerOk;
            if (filePath.isDirectory()) {
                for (File file : filePath.listFiles()) {
                    FileIOUtils.deleteFileDir(file, excludedFiles, withSymbolicLinks, filter, false);
                }
            }
            boolean bl = filerOk = filter == null || filter.apply(filePath.getName()) != false;
            if (!firstCall && filerOk || firstCall && (filter == null || !filePath.isDirectory() && filerOk)) {
                return filePath.delete();
            }
        }
        return false;
    }

    public static void move(File source, File target) throws UtilitiesException {
        FileIOUtils.move(source, target, new byte[4096]);
    }

    static void move(File source, File target, byte[] sharedBuffer) throws UtilitiesException {
        if (source.isDirectory()) {
            if (!target.exists()) {
                target.mkdirs();
            }
            if (target.isDirectory()) {
                for (File file : source.listFiles()) {
                    File targetFile = new File(target, file.getName());
                    if (file.isFile()) {
                        if (targetFile.exists()) {
                            targetFile.delete();
                        }
                        if (file.renameTo(targetFile)) continue;
                        FileIOUtils.copy(file, targetFile, sharedBuffer);
                        file.delete();
                        continue;
                    }
                    if (!targetFile.exists() && !targetFile.mkdirs()) {
                        throw new UtilitiesException("Creation of directory '" + String.valueOf(targetFile) + "' failed.");
                    }
                    FileIOUtils.move(file, targetFile);
                }
                source.delete();
            }
        } else if (!target.isDirectory()) {
            FileIOUtils.copy(source, target, sharedBuffer);
            source.delete();
        }
    }

    public static void copyFileDir(File source, File target) throws UtilitiesException {
        byte[] sharedBuffer = new byte[4096];
        FileIOUtils.copyFileDir(source, target, sharedBuffer);
    }

    static void copyFileDir(File source, File target, byte[] sharedBuffer) throws UtilitiesException {
        if (source.isDirectory()) {
            if (!target.exists()) {
                target.mkdirs();
            }
            if (target.isDirectory()) {
                File[] files;
                for (File file : files = source.listFiles()) {
                    File targetFile = new File(target, file.getName());
                    if (file.isFile()) {
                        if (targetFile.exists()) {
                            targetFile.delete();
                        }
                        FileIOUtils.copy(file, targetFile, sharedBuffer);
                        continue;
                    }
                    targetFile.mkdirs();
                    FileIOUtils.copyFileDir(file, targetFile);
                }
            }
        } else if (!target.isDirectory()) {
            if (!target.exists()) {
                File dir = target.getParentFile();
                if (!dir.exists() && !dir.mkdirs()) {
                    throw new UtilitiesException("Could not create target directory: " + String.valueOf(dir));
                }
                try {
                    if (!target.createNewFile()) {
                        throw new UtilitiesException("Could not create target file: " + String.valueOf(target));
                    }
                }
                catch (IOException ex) {
                    throw new UtilitiesException(ex);
                }
            }
            FileIOUtils.copy(source, target, sharedBuffer);
        }
    }

    public static List<String> directoryList(String dirPath, String fileFilter, boolean absolute) throws UtilitiesException {
        File[] files;
        File dir = FileIOUtils.openFile(dirPath.equals(".") || dirPath.equals("./") || dirPath.equals("\\.") ? System.getProperty("user.dir") : dirPath);
        if (dir == null) {
            throw new UtilitiesException("File Reference is null.");
        }
        if (!dir.isDirectory()) {
            throw new UtilitiesException("File Reference is not a directory : '" + dirPath + "'.");
        }
        if (fileFilter != null && !fileFilter.isEmpty()) {
            if (fileFilter.startsWith("*.")) {
                filter = new FileDirectoryFilter();
                filter.setFileExtension(fileFilter.substring(2));
                files = dir.listFiles(filter);
            } else if (fileFilter.endsWith(".*")) {
                filter = new FileDirectoryFilter();
                filter.setFilePrefix(fileFilter.substring(0, fileFilter.length() - 1));
                files = dir.listFiles(filter);
            } else {
                filter = new FileDirectoryFilter();
                filter.setFileFilter(fileFilter);
                files = dir.listFiles(filter);
            }
        } else {
            files = dir.listFiles();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (File fileRef : files) {
            if (fileRef.isDirectory()) continue;
            if (absolute) {
                result.add(fileRef.getAbsolutePath());
                continue;
            }
            result.add(fileRef.getName());
        }
        return result;
    }

    public static File[] directoryList(String dirPath, String fileFilter) throws UtilitiesException {
        File[] files;
        String url = dirPath.equals(".") || dirPath.equals("./") || dirPath.equals("\\.") ? System.getProperty("user.dir") : dirPath;
        File dir = FileIOUtils.openFile(url);
        if (dir == null) {
            throw new UtilitiesException("Directory List Error: File Reference is null.");
        }
        if (!dir.isDirectory()) {
            throw new UtilitiesException("Directory List Error: File reference is not a directory : '" + dirPath + "'.");
        }
        if (fileFilter != null && !fileFilter.isEmpty()) {
            if (fileFilter.startsWith("*.")) {
                FileOnlyFilter filter = new FileOnlyFilter();
                filter.setFileExtension(fileFilter.substring(2));
                files = dir.listFiles(filter);
            } else if (fileFilter.endsWith(".*")) {
                FileOnlyFilter filter = new FileOnlyFilter();
                filter.setFilePrefix(fileFilter.substring(0, fileFilter.length() - 1));
                files = dir.listFiles(filter);
            } else {
                FileOnlyFilter filter = new FileOnlyFilter();
                filter.setFileFilter(fileFilter);
                files = dir.listFiles(filter);
            }
        } else {
            files = dir.listFiles(new FileOnlyFilter());
        }
        return files;
    }

    public static List<String> directorySublist(String dirPath, boolean absolute) throws UtilitiesException {
        ArrayList<String> result = new ArrayList<String>();
        File dir = FileIOUtils.openFile(dirPath.equals(".") || dirPath.equals("./") || dirPath.equals("\\.") ? System.getProperty("user.dir") : dirPath);
        for (File fileRef : dir.listFiles()) {
            if (!fileRef.isDirectory()) continue;
            if (absolute) {
                result.add(fileRef.getAbsolutePath());
                continue;
            }
            result.add(fileRef.getName());
        }
        return result;
    }

    public static void directoryListRecursive(File dirFile, Consumer<File> onFile, Function<File, Boolean> onDirectory) throws IOException {
        if (!dirFile.exists()) {
            return;
        }
        if (!onDirectory.apply(dirFile).booleanValue()) {
            return;
        }
        File[] listFiles = dirFile.listFiles();
        if (listFiles != null) {
            for (File file : listFiles) {
                if (file.isDirectory()) {
                    if (!onDirectory.apply(file).booleanValue()) continue;
                    FileIOUtils.directoryListRecursive(file, onFile, onDirectory);
                    continue;
                }
                onFile.accept(file);
            }
        }
    }

    public static File newFileDir(String pathName) throws UtilitiesException {
        try {
            File file = new File(pathName).getCanonicalFile();
            file.mkdirs();
            return file;
        }
        catch (IOException exception) {
            throw new UtilitiesException("Creating directory '" + pathName + "' failed.", exception);
        }
    }

    public static File newFile(String pathName) throws UtilitiesException {
        try {
            File file = new File(pathName).getCanonicalFile();
            file.delete();
            return file;
        }
        catch (IOException exception) {
            throw new UtilitiesException("File '" + pathName + "' Create Error: " + exception.getMessage());
        }
    }

    public static File openFile(String pathName) throws UtilitiesException {
        try {
            File file = new File(pathName).getCanonicalFile();
            if (!file.exists()) {
                throw new UtilitiesException("File or directory '" + pathName + "' does not exist.");
            }
            return file;
        }
        catch (IOException exception) {
            throw new UtilitiesException("File '" + pathName + "' Open Error: " + exception.getMessage());
        }
    }

    public static File newFile(URI uri) throws UtilitiesException {
        try {
            File file = new File(uri).getCanonicalFile();
            file.delete();
            return file;
        }
        catch (IOException exception) {
            throw new UtilitiesException("Create File Error: " + exception.getMessage());
        }
    }

    public static File openFile(URI uri) throws UtilitiesException {
        try {
            File file = new File(uri).getCanonicalFile();
            if (!file.exists()) {
                throw new UtilitiesException("File '" + uri.toASCIIString() + "' does not exist.");
            }
            return file;
        }
        catch (IOException exception) {
            throw new UtilitiesException("Open File Error: " + exception.getMessage());
        }
    }

    public static void closeQuietly(Reader input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] getFileContent(File file) throws UtilitiesException {
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new UtilitiesException("I/O not supported for files larger then 2GB.");
        }
        InputStream stream = null;
        try {
            int nTotalReadBytes;
            int nReadBytes;
            byte[] bytes = new byte[(int)length];
            stream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            for (nTotalReadBytes = 0; nTotalReadBytes < bytes.length && (nReadBytes = stream.read(bytes, nTotalReadBytes, bytes.length - nTotalReadBytes)) >= 0; nTotalReadBytes += nReadBytes) {
            }
            if (nTotalReadBytes < bytes.length) {
                throw new UtilitiesException("Reading file '" + file.getName() + "' failed.");
            }
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException exception) {
            throw new UtilitiesException(exception);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] getStreamContent(InputStream stream, long sizeLimit) throws UtilitiesException {
        ByteArrayOutputStream contentStream = null;
        try {
            contentStream = new ByteArrayOutputStream();
            FileIOUtils.copyLarge(stream, (OutputStream)contentStream, sizeLimit);
            byte[] byArray = contentStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            throw new UtilitiesException("Reading content from stream failed.", exception);
        }
        finally {
            if (contentStream != null) {
                try {
                    contentStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int copy(InputStream input, OutputStream output) throws UtilitiesException {
        long nReadBytes = FileIOUtils.copyLarge(input, output);
        return nReadBytes > Integer.MAX_VALUE ? -1 : (int)nReadBytes;
    }

    public static long processStream(InputStream input, long sizeLimit, StreamProcessor processor) throws UtilitiesException {
        return FileIOUtils.doProcessStream(input, sizeLimit, processor, new byte[4096]);
    }

    public static long processLargeStream(InputStream input, long sizeLimit, StreamProcessor processor) throws UtilitiesException {
        return FileIOUtils.doProcessStream(input, sizeLimit, processor, new byte[65536]);
    }

    private static long doProcessStream(InputStream input, long sizeLimit, StreamProcessor processor, byte[] buffer) throws UtilitiesException {
        try {
            int nReadBytes;
            if (sizeLimit < 0L) {
                sizeLimit = input.available();
            }
            long nTotalReadBytes = 0L;
            long remaining = sizeLimit;
            while (remaining > 0L && (nReadBytes = input.read(buffer, 0, Utils.min(buffer.length, input.available()))) != -1) {
                processor.process(buffer, 0, nReadBytes);
                remaining = sizeLimit - (nTotalReadBytes += (long)nReadBytes);
            }
            return nTotalReadBytes;
        }
        catch (IOException ex) {
            throw new UtilitiesException(ex);
        }
    }

    public static long copyLarge(InputStream input, OutputStream output) throws UtilitiesException {
        return FileIOUtils.copyLarge(input, output, Long.MAX_VALUE);
    }

    public static long copyLarge(final InputStream input, OutputStream output, long sizeLimit) throws UtilitiesException {
        return FileIOUtils.copyLarge(new InputStreamWrapper(){

            @Override
            public long length() throws IOException {
                return input.available();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return input.read(b, off, len);
            }
        }, output, sizeLimit);
    }

    public static long copyLarge(RandomAccessFile input, OutputStream output) throws UtilitiesException {
        return FileIOUtils.copyLarge(input, output, Long.MAX_VALUE);
    }

    public static long copyLarge(final RandomAccessFile input, OutputStream output, long sizeLimit) throws UtilitiesException {
        return FileIOUtils.copyLarge(new InputStreamWrapper(){

            @Override
            public long length() throws IOException {
                return input.length();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return input.read(b, off, len);
            }
        }, output, sizeLimit);
    }

    private static long copyLarge(InputStreamWrapper input, OutputStream output, long sizeLimit) throws UtilitiesException {
        byte[] buffer = new byte[65536];
        try {
            int nReadBytes;
            if (sizeLimit < 0L) {
                sizeLimit = input.length();
            }
            long nTotalReadBytes = 0L;
            long remaining = sizeLimit - nTotalReadBytes;
            while (remaining > 0L && (nReadBytes = input.read(buffer, 0, Utils.min(buffer.length, remaining))) != -1) {
                output.write(buffer, 0, nReadBytes);
                remaining = sizeLimit - (nTotalReadBytes += (long)nReadBytes);
            }
            return nTotalReadBytes;
        }
        catch (IOException exception) {
            throw new UtilitiesException(exception);
        }
    }

    public static long copy(File source, File target) throws UtilitiesException {
        return FileIOUtils.copy(source, target, new byte[4096]);
    }

    public static long copy(File input, File output, byte[] copyBuffer) throws UtilitiesException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(input);
            out = new FileOutputStream(output);
            long l = FileIOUtils.copy((InputStream)in, (OutputStream)out, copyBuffer);
            return l;
        }
        catch (FileNotFoundException ex) {
            throw new UtilitiesException(ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static long copy(InputStream in, OutputStream out, byte[] copyBuffer) throws UtilitiesException {
        long bytesCopied = 0L;
        try {
            int read;
            while ((read = in.read(copyBuffer, 0, copyBuffer.length)) != -1) {
                out.write(copyBuffer, 0, read);
                bytesCopied += (long)read;
            }
        }
        catch (IOException ex) {
            throw new UtilitiesException(ex);
        }
        return bytesCopied;
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        FileIOUtils.copy((Reader)in, output);
    }

    public static void copy(InputStream input, Writer output, String encoding) throws IOException {
        if (encoding == null) {
            FileIOUtils.copy(input, output);
        } else {
            InputStreamReader in = new InputStreamReader(input, encoding);
            FileIOUtils.copy((Reader)in, output);
        }
    }

    public static int copy(Reader input, Writer output) throws IOException {
        long nReadChars = FileIOUtils.copyLarge(input, output);
        return nReadChars > Integer.MAX_VALUE ? -1 : (int)nReadChars;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        int nReadBytes;
        char[] buffer = new char[32768];
        long nTotalReadBytes = 0L;
        while ((nReadBytes = input.read(buffer)) != -1) {
            output.write(buffer, 0, nReadBytes);
            nTotalReadBytes += (long)nReadBytes;
        }
        return nTotalReadBytes;
    }

    public static void copy(Reader input, OutputStream output) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output);
        FileIOUtils.copy(input, (Writer)out);
        out.flush();
    }

    public static void copy(Reader input, OutputStream output, String encoding) throws IOException {
        if (encoding == null) {
            FileIOUtils.copy(input, output);
        } else {
            OutputStreamWriter out = new OutputStreamWriter(output, encoding);
            FileIOUtils.copy(input, (Writer)out);
            out.flush();
        }
    }

    public static byte[] getFile(String workingDir, String filename) throws UtilitiesException {
        if (workingDir == null || workingDir.isEmpty()) {
            throw new UtilitiesException("Null or empty working directory specified.");
        }
        if (filename == null || filename.isEmpty()) {
            throw new UtilitiesException("Null or empty file name specified.");
        }
        try {
            File pkgFile = FileIOUtils.openFile(workingDir + System.getProperty("file.separator") + filename);
            if (pkgFile.length() > Integer.MAX_VALUE) {
                throw new UtilitiesException("File lengh larger then 2GB is unsupported.");
            }
            RandomAccessFile artifact = new RandomAccessFile(pkgFile, "rw");
            FileLock lock = artifact.getChannel().lock();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(artifact.getFD()));
            byte[] bytes = new byte[(int)pkgFile.length()];
            bis.read(bytes);
            lock.release();
            artifact.close();
            bis.close();
            return bytes;
        }
        catch (Exception ex) {
            throw new UtilitiesException(ex);
        }
    }

    public static void putFile(String workingDir, String filename, byte[] data) throws UtilitiesException {
        FileIOUtils.putFile(workingDir, filename, data, 1000L);
    }

    public static void putFile(String workingDir, String filename, byte[] data, long timeout) throws UtilitiesException {
        if (workingDir == null || workingDir.isEmpty()) {
            throw new UtilitiesException("Null or empty working directory specified.");
        }
        if (filename == null || filename.isEmpty()) {
            throw new UtilitiesException("Null or empty file name specified.");
        }
        if (data == null) {
            throw new UtilitiesException("Null data buffer.");
        }
        RandomAccessFile raf = null;
        FileLock lock = null;
        File file = FileIOUtils.newFile(workingDir + System.getProperty("file.separator") + filename);
        try {
            raf = new RandomAccessFile(file, "rw");
            lock = FileIOUtils.tryLock(raf.getChannel(), timeout);
            if (lock == null) {
                throw new UtilitiesException("Access to file '" + file.getCanonicalPath() + "' locked.");
            }
            raf.setLength(0L);
            raf.seek(0L);
            raf.write(data);
            raf.getFD().sync();
        }
        catch (Exception exception) {
            if (exception instanceof UtilitiesException) {
                throw (UtilitiesException)exception;
            }
            throw new UtilitiesException(exception);
        }
        finally {
            try {
                if (lock != null && lock.isValid()) {
                    lock.close();
                }
                if (raf != null && raf.getChannel().isOpen()) {
                    raf.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static File moveToDirWithUniqueName(File source, File destDir) throws UtilitiesException {
        String sourceFileName = source.getName();
        File dest = new File(destDir, sourceFileName);
        if (dest.exists()) {
            String ext;
            String name;
            int extPos = sourceFileName.lastIndexOf(46);
            if (extPos > 0) {
                name = sourceFileName.substring(0, extPos);
                ext = sourceFileName.substring(extPos);
            } else {
                name = sourceFileName;
                ext = "";
            }
            int counter = 1;
            do {
                dest = new File(destDir, name + "_" + counter + ext);
                ++counter;
            } while (dest.exists());
        }
        if (!source.renameTo(dest)) {
            throw new UtilitiesException("Failed to move " + source.getAbsolutePath() + " to " + destDir.getAbsolutePath());
        }
        return dest;
    }

    public static String getExtension(String fileNameOrPath) {
        int lastSlash = fileNameOrPath.lastIndexOf(File.separatorChar);
        int dotPos = fileNameOrPath.lastIndexOf(46);
        return dotPos > lastSlash ? fileNameOrPath.substring(dotPos + 1) : "";
    }

    public static boolean isFile(String location, String ext, String absPath) {
        return absPath.startsWith(location) && absPath.endsWith(ext) && new File(absPath).isFile();
    }

    public static boolean isFirstLevelFile(String location, String ext, String absPath) {
        return FileIOUtils.isFile(location, ext, absPath) && absPath.indexOf(File.separatorChar, location.length()) < 0;
    }

    public static void closeSafe(RandomAccessFile raf) {
        if (raf != null) {
            try {
                raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isDescendantForCanonicalBase(File base, File child) throws IOException {
        String baseCanonicalPath = base.getPath();
        String childCanonicalPath = child.getCanonicalPath();
        int baseCanonicalPathLength = baseCanonicalPath.length();
        return childCanonicalPath.length() > baseCanonicalPathLength && childCanonicalPath.charAt(baseCanonicalPathLength) == File.separatorChar && base.equals(new File(childCanonicalPath.substring(0, baseCanonicalPathLength)));
    }

    public static boolean isDescendant(File base, File child) throws IOException {
        return FileIOUtils.isDescendantForCanonicalBase(base.getCanonicalFile(), child);
    }

    public static String getRelativePathForCanonicalBase(File base, File child) throws IOException {
        String baseCanonicalPath = base.getPath();
        String childCanonicalPath = child.getCanonicalPath();
        int baseCanonicalPathLength = baseCanonicalPath.length();
        if (childCanonicalPath.length() > baseCanonicalPathLength) {
            if (childCanonicalPath.charAt(baseCanonicalPathLength) == File.separatorChar && base.equals(new File(childCanonicalPath.substring(0, baseCanonicalPathLength)))) {
                return childCanonicalPath.substring(baseCanonicalPathLength + 1);
            }
        } else if (childCanonicalPath.length() == baseCanonicalPathLength && base.equals(new File(childCanonicalPath))) {
            return "";
        }
        return null;
    }

    public static String getRelativePath(File base, File child) throws IOException {
        return FileIOUtils.getRelativePathForCanonicalBase(base.getCanonicalFile(), child);
    }

    public static void unmap(MappedByteBuffer buffer) {
        JavaInternal.clean(buffer);
    }

    public static FileLock lock(FileChannel channel, String filename) throws IOException {
        FileLock lock = channel.tryLock();
        int count = 0;
        while (lock == null) {
            Utils.sleep(100L);
            if (++count % 20 == 0) {
                Trace.logError(FileIOUtils.class, "Locking file '" + filename + "' failed. Trying again...");
            }
            lock = channel.tryLock();
        }
        return lock;
    }

    public static FileLock tryLock(FileChannel channel, long timeout) throws IOException {
        long endTime = System.currentTimeMillis() + timeout;
        FileLock lock = null;
        while (lock == null && System.currentTimeMillis() < endTime) {
            try {
                lock = channel.tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                // empty catch block
            }
            if (lock != null) continue;
            Utils.sleep(100L);
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeIfNotLocked(File file) {
        try {
            RandomAccessFile lockArtifact = new RandomAccessFile(file, "rw");
            FileChannel afc = lockArtifact.getChannel();
            try {
                FileLock lockFlock = afc.tryLock();
                if (lockFlock != null) {
                    lockArtifact.close();
                    file.delete();
                    lockFlock.release();
                }
            }
            finally {
                lockArtifact.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean equals(String filename1, String filename2) {
        return new File(filename1).equals(new File(filename2));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean equalsByContent(File file1, File file2) {
        if (file1.equals(file2)) {
            return true;
        }
        try (FileInputStream stream1 = new FileInputStream(file1);){
            boolean bl;
            try (FileInputStream stream2 = new FileInputStream(file2);){
                bl = FileIOUtils.equalsByContent(stream1, (InputStream)stream2);
            }
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean equalsByContent(InputStream stream1, InputStream stream2) {
        try {
            return FileIOUtils.doEqualsByContent(stream1, stream1.available(), stream2, stream2.available());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean equalsByContent(URLConnection stream1, InputStream stream2) {
        try {
            return FileIOUtils.doEqualsByContent(stream1.getInputStream(), stream1.getContentLength(), stream2, stream2.available());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean doEqualsByContent(InputStream stream1, int stream1Length, InputStream stream2, int stream2Length) {
        try {
            if (stream1Length == stream2Length) {
                int nReadBytes2;
                int nReadBytes1;
                byte[] buffer1 = new byte[65536];
                byte[] buffer2 = new byte[65536];
                long nTotalReadBytes = 0L;
                while ((nReadBytes1 = stream1.read(buffer1, 0, 65536)) >= 0 && (nReadBytes2 = stream2.read(buffer2, 0, 65536)) >= 0) {
                    if (nReadBytes1 != nReadBytes2 || !Arrays.equals(buffer1, buffer2)) {
                        return false;
                    }
                    nTotalReadBytes += (long)nReadBytes1;
                }
                return nTotalReadBytes == (long)stream1Length;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static void renameDirectory(FileSystem fileSystem, String src, String dst) throws IOException {
        fileSystem.mkdir(dst);
        for (FileInfo info : fileSystem.list(src)) {
            fileSystem.rename(info.getAbsolutePath(), dst + fileSystem.separator() + info.getName());
        }
        fileSystem.delete(src, true);
    }

    public static void copyDirectory(FileSystem fileSystem, String src, String dst) throws IOException {
        if (!fileSystem.exists(dst)) {
            fileSystem.mkdir(dst);
        }
        for (FileInfo info : fileSystem.list(src)) {
            fileSystem.copy(info.getAbsolutePath(), dst + fileSystem.separator() + info.getName());
        }
    }

    public static long getCreationTime(File file) {
        try {
            return ((FileTime)Files.getAttribute(file.toPath(), "creationTime", new LinkOption[0])).toMillis();
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }

    public static void setCreationTime(File file, long time) {
        try {
            Files.setAttribute(file.toPath(), "creationTime", FileTime.fromMillis(time), new LinkOption[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static File createTempDir(File parentDir) throws UtilitiesException {
        String dirName = UUID.randomUUID().toString();
        return FileIOUtils.newFileDir(parentDir != null ? new File(parentDir, dirName).getPath() : dirName);
    }

    public static interface StreamProcessor {
        public void process(byte[] var1, int var2, int var3);
    }

    private static interface InputStreamWrapper {
        public long length() throws IOException;

        public int read(byte[] var1, int var2, int var3) throws IOException;
    }
}

