/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import java.io.File;
import java.io.FilenameFilter;

public class FileDirectoryFilter
implements FilenameFilter {
    private String fileExtension;
    private String filePrefix;
    private String fileFilter;

    public void setFileExtension(String ext) {
        this.fileExtension = ext.toLowerCase();
        this.filePrefix = null;
    }

    public void setFilePrefix(String prefix) {
        this.filePrefix = prefix.toLowerCase();
        this.fileExtension = null;
    }

    public void setFileFilter(String filter) {
        this.fileFilter = filter.toLowerCase();
        this.fileExtension = "";
        this.filePrefix = "";
    }

    @Override
    public boolean accept(File dir, String name) {
        if (this.filePrefix == null) {
            return name.toLowerCase().endsWith(this.fileExtension);
        }
        if (this.fileExtension == null) {
            return name.toLowerCase().startsWith(this.filePrefix);
        }
        return name.toLowerCase().contains(this.fileFilter.subSequence(0, this.fileFilter.length()));
    }
}

