/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.lib.utils.RandomAccessFileInputStream;
import com.streamscape.lib.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtils
extends Utils {
    private static final int CALC_BUF_SIZE = 262144;

    public static OutputStream encryptOutputStream(OutputStream stream, Key key) throws GeneralSecurityException {
        return CryptoUtils.encryptOutputStream(stream, Cipher.getInstance("AES"), key);
    }

    public static OutputStream encryptOutputStream(OutputStream stream, Cipher cipher, Key key) throws InvalidKeyException {
        if (cipher != null) {
            cipher.init(1, key);
            return new CipherOutputStream(stream, cipher);
        }
        return stream;
    }

    public static InputStream decryptOutputStream(InputStream stream, Key key) throws GeneralSecurityException {
        return CryptoUtils.decryptInputStream(stream, Cipher.getInstance("AES"), key);
    }

    public static InputStream decryptInputStream(InputStream stream, Cipher cipher, Key key) throws InvalidKeyException {
        if (cipher != null) {
            cipher.init(2, key);
            return new CipherInputStream(stream, cipher);
        }
        return stream;
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws GeneralSecurityException {
        return CryptoUtils.encrypt(data, new SecretKeySpec(key, "AES"));
    }

    public static byte[] encrypt(byte[] data, Key key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, key);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(byte[] data, byte[] key) throws GeneralSecurityException {
        return CryptoUtils.decrypt(data, new SecretKeySpec(key, "AES"));
    }

    public static byte[] decrypt(byte[] data, Key key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, key);
        return cipher.doFinal(data);
    }

    public static SecretKey generateSecretKey(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance(algorithm);
        generator.init(keySize);
        return generator.generateKey();
    }

    public static byte[] calcSha256Hash(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.reset();
        digest.update(data);
        return digest.digest();
    }

    public static MessageDigest createSha256Digest() throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.reset();
        return digest;
    }

    public static byte[] calcSha256Hash(InputStream is) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.reset();
        byte[] buffer = new byte[262144];
        int sizeRead = is.read(buffer);
        while (sizeRead > 0) {
            digest.update(buffer, 0, sizeRead);
            sizeRead = is.read(buffer);
        }
        return digest.digest();
    }

    public static String calculateDigest(byte[] data, String algorithm) throws NoSuchAlgorithmException {
        return CryptoUtils.bytesToHex(MessageDigest.getInstance(algorithm).digest(data));
    }

    public static String calculateDigest(String key, String value, String algorithm) throws NoSuchAlgorithmException {
        byte[] data;
        byte[] keyBytes = key != null ? key.getBytes() : null;
        byte[] valueBytes = value != null ? value.getBytes() : null;
        int dataLength = (keyBytes != null ? keyBytes.length : 0) + (valueBytes != null ? valueBytes.length : 0);
        byte[] byArray = data = dataLength != 0 ? new byte[dataLength] : null;
        if (keyBytes != null) {
            System.arraycopy(keyBytes, 0, data, 0, keyBytes.length);
        }
        if (valueBytes != null) {
            System.arraycopy(valueBytes, 0, data, keyBytes != null ? keyBytes.length : 0, valueBytes.length);
        }
        return data != null ? CryptoUtils.calculateDigest(data, algorithm) : null;
    }

    public static class Sha256RandomAccessFileHashCalculator
    implements HashCalculator {
        private RandomAccessFile file;

        public Sha256RandomAccessFileHashCalculator(RandomAccessFile file) {
            this.file = file;
        }

        @Override
        public byte[] calculateHash() throws IOException, NoSuchAlgorithmException {
            RandomAccessFileInputStream is = new RandomAccessFileInputStream(this.file);
            return CryptoUtils.calcSha256Hash(is);
        }
    }

    public static class Sha256FileHashCalculator
    implements HashCalculator {
        private File file;

        public Sha256FileHashCalculator(File file) {
            this.file = file;
        }

        @Override
        public byte[] calculateHash() throws IOException, NoSuchAlgorithmException {
            try (FileInputStream is = new FileInputStream(this.file);){
                byte[] byArray = CryptoUtils.calcSha256Hash(is);
                return byArray;
            }
        }
    }

    public static interface HashCalculator {
        public byte[] calculateHash() throws IOException, NoSuchAlgorithmException;
    }
}

